/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.errors;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.wb.core.controls.BrowserComposite;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.EnvironmentUtils;
import org.eclipse.wb.internal.core.editor.Messages;
import org.eclipse.wb.internal.core.editor.errors.ErrorEntryInfo;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;

public abstract class WarningComposite
extends Composite {
    private Button m_switchButton;
    private final BrowserComposite m_browser;
    private final Label m_titleLabel;
    private int m_sourcePosition;
    private final boolean wbBasic = InstanceScope.INSTANCE.getNode("org.eclipse.wb.core.editor.constants.preferences").getBoolean("basicUserInterface", false);

    public WarningComposite(Composite parent, int style) {
        super(parent, style);
        GridLayoutFactory.create(this);
        Composite titleComposite = new Composite((Composite)this, 0);
        GridDataFactory.create((Control)titleComposite).alignHL();
        GridLayoutFactory.create(titleComposite).columns(2).margins(10);
        Label label = new Label(titleComposite, 0);
        label.setImage(parent.getDisplay().getSystemImage(8));
        Font boldFont = FontDescriptor.createFrom((Font)this.getFont()).setHeight(14).setStyle(1).createFont(null);
        this.m_titleLabel = new Label(titleComposite, 0);
        this.m_titleLabel.setFont(boldFont);
        this.m_titleLabel.addDisposeListener(event -> boldFont.dispose());
        this.m_browser = new BrowserComposite(this, 0);
        GridDataFactory.create((Control)this.m_browser).grab().fill();
        this.createButtons();
    }

    protected void createButtons() {
        Composite buttonsComposite = new Composite((Composite)this, 0);
        GridDataFactory.create((Control)buttonsComposite).alignHR();
        int numButtons = this.getNumButtons();
        GridLayoutFactory.create(buttonsComposite).columns(numButtons).equalColumns().marginsH(0);
        this.createButtons(buttonsComposite);
    }

    protected void createButtons(Composite buttonsComposite) {
        Button refreshButton = new Button(buttonsComposite, 0);
        GridDataFactory.create((Control)refreshButton).fillH();
        refreshButton.setText(Messages.WarningComposite_refreshButton);
        refreshButton.setImage(EnvironmentUtils.IS_MAC ? null : DesignerPlugin.getImage("actions/errors/refresh32.png"));
        refreshButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WarningComposite.this.doRefresh();
            }
        });
        refreshButton.setVisible(!this.wbBasic);
        this.m_switchButton = new Button(buttonsComposite, 0);
        GridDataFactory.create((Control)this.m_switchButton).fillH();
        this.m_switchButton.setText(Messages.WarningComposite_switchButton);
        this.m_switchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WarningComposite.this.doShowSource(WarningComposite.this.m_sourcePosition);
            }
        });
        this.m_switchButton.setVisible(!this.wbBasic);
    }

    protected int getNumButtons() {
        return 2;
    }

    protected abstract void doRefresh();

    protected abstract void doShowSource(int var1);

    public void setException(Throwable e) {
        ErrorEntryInfo entry = DesignerExceptionUtils.getErrorEntry(e);
        this.m_titleLabel.setText(entry.getTitle());
        this.m_browser.setText(DesignerExceptionUtils.getWarningHTML(entry));
        this.updateForSourcePosition(e);
    }

    private void updateForSourcePosition(Throwable e) {
        boolean hasSourcePosition;
        this.m_sourcePosition = DesignerExceptionUtils.getSourcePosition(e);
        boolean bl = hasSourcePosition = this.m_sourcePosition != -1;
        if (hasSourcePosition) {
            this.m_switchButton.setText(Messages.WarningComposite_goProblemButton);
        } else {
            this.m_switchButton.setText(Messages.WarningComposite_switchButton);
        }
        if (!EnvironmentUtils.IS_MAC) {
            Image image = hasSourcePosition ? DesignerPlugin.getImage("actions/errors/switch32locate.png") : DesignerPlugin.getImage("actions/errors/switch32.png");
            this.m_switchButton.setImage(image);
        }
    }
}

