/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.draw2d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.draw2d.Polyline;
import org.eclipse.wb.tests.draw2d.Draw2dFigureTestCase;
import org.eclipse.wb.tests.draw2d.TestCaseRootFigure;
import org.eclipse.wb.tests.gef.TestLogger;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PolylineTest
extends Draw2dFigureTestCase {
    private TestLogger m_actualLogger;
    private TestCaseRootFigure m_root;
    private TestLogger m_expectedLogger;
    private Polyline m_polyline;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.m_actualLogger = new TestLogger();
        this.m_root = new TestCaseRootFigure(this.m_actualLogger);
        this.m_expectedLogger = new TestLogger();
        this.m_polyline = new Polyline();
        this.m_root.add((IFigure)this.m_polyline);
        this.m_actualLogger.clear();
    }

    @Test
    public void test_addPoint_getPoints() throws Exception {
        this.m_polyline.addPoint(new Point(10, 20));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(10, 20, 1, 1)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_polyline.addPoint(new Point(-90, 0));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(-90, 0, 101, 21)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_polyline.addPoint(new Point(120, -70));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(-90, -70, 211, 91)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        try {
            this.m_polyline.addPoint(null);
            PolylineTest.fail();
        }
        catch (NullPointerException e) {
            this.m_actualLogger.assertEmpty();
        }
        PointList list = this.m_polyline.getPoints();
        PolylineTest.assertNotNull((Object)list);
        PolylineTest.assertEquals((int)3, (int)list.size());
        PolylineTest.assertEquals((Object)new Point(10, 20), (Object)list.getPoint(0));
        PolylineTest.assertEquals((Object)new Point(-90, 0), (Object)list.getPoint(1));
        PolylineTest.assertEquals((Object)new Point(120, -70), (Object)list.getPoint(2));
    }

    @Test
    public void test_insertPoint() throws Exception {
        try {
            this.m_polyline.insertPoint(new Point(), 1);
            PolylineTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            this.m_actualLogger.assertEmpty();
        }
        this.m_polyline.insertPoint(new Point(), 0);
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(0, 0, 1, 1)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_polyline.addPoint(new Point(10, 20));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(0, 0, 11, 21)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_polyline.addPoint(new Point(-90, 0));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(-90, 0, 101, 21)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        this.m_polyline.insertPoint(new Point(-1, -1), 1);
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(-90, -1, 101, 22)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PointList list = this.m_polyline.getPoints();
        PolylineTest.assertEquals((int)4, (int)list.size());
        PolylineTest.assertEquals((Object)new Point(), (Object)list.getPoint(0));
        PolylineTest.assertEquals((Object)new Point(-1, -1), (Object)list.getPoint(1));
        PolylineTest.assertEquals((Object)new Point(10, 20), (Object)list.getPoint(2));
        PolylineTest.assertEquals((Object)new Point(-90, 0), (Object)list.getPoint(3));
        try {
            this.m_polyline.insertPoint(null, 0);
            PolylineTest.fail();
        }
        catch (NullPointerException e) {
            this.m_actualLogger.assertEmpty();
        }
    }

    @Test
    public void test_removePoint() throws Exception {
        this.m_polyline.addPoint(new Point(10, -20));
        this.m_polyline.addPoint(new Point(-90, 0));
        this.m_polyline.addPoint(new Point(120, 120));
        this.m_actualLogger.clear();
        PointList list = this.m_polyline.getPoints();
        PolylineTest.assertEquals((int)3, (int)list.size());
        try {
            this.m_polyline.removePoint(4);
            PolylineTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            this.m_actualLogger.assertEmpty();
        }
        this.m_polyline.removePoint(2);
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(-90, -20, 101, 21)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)2, (int)list.size());
        PolylineTest.assertEquals((Object)new Point(10, -20), (Object)list.getPoint(0));
        PolylineTest.assertEquals((Object)new Point(-90, 0), (Object)list.getPoint(1));
        this.m_polyline.removePoint(0);
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(-90, 0, 1, 1)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)1, (int)list.size());
        PolylineTest.assertEquals((Object)new Point(-90, 0), (Object)list.getPoint(0));
        this.m_polyline.removePoint(0);
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)0, (int)list.size());
        try {
            this.m_polyline.removePoint(0);
            PolylineTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            this.m_actualLogger.assertEmpty();
        }
    }

    @Test
    public void test_removeAllPoints() throws Exception {
        this.m_polyline.removeAllPoints();
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PointList list = this.m_polyline.getPoints();
        PolylineTest.assertEquals((int)0, (int)list.size());
        this.m_polyline.addPoint(new Point(10, -20));
        this.m_polyline.addPoint(new Point(-90, 0));
        this.m_polyline.addPoint(new Point(120, 120));
        this.m_actualLogger.clear();
        PolylineTest.assertEquals((int)3, (int)list.size());
        this.m_polyline.removeAllPoints();
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)0, (int)list.size());
        this.m_polyline.removeAllPoints();
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)0, (int)list.size());
    }

    @Test
    public void test_getStart() throws Exception {
        Polyline polyline = new Polyline();
        polyline.addPoint(new Point(10, -20));
        PolylineTest.assertEquals((Object)new Point(10, -20), (Object)polyline.getStart());
        polyline.addPoint(new Point(-90, 0));
        polyline.addPoint(new Point(120, 120));
        PolylineTest.assertEquals((Object)new Point(10, -20), (Object)polyline.getStart());
    }

    @Test
    public void test_getEnd() throws Exception {
        Polyline polyline = new Polyline();
        polyline.addPoint(new Point(10, -20));
        PolylineTest.assertEquals((Object)new Point(10, -20), (Object)polyline.getEnd());
        polyline.addPoint(new Point(-90, 0));
        PolylineTest.assertEquals((Object)new Point(-90, 0), (Object)polyline.getEnd());
        polyline.addPoint(new Point(120, 120));
        PolylineTest.assertEquals((Object)new Point(120, 120), (Object)polyline.getEnd());
    }

    @Test
    public void test_setPoint_Point_int() throws Exception {
        this.m_polyline.addPoint(new Point(10, -20));
        this.m_polyline.addPoint(new Point(40, 40));
        this.m_actualLogger.clear();
        try {
            this.m_polyline.setPoint(new Point(), -1);
            PolylineTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            this.m_actualLogger.assertEmpty();
        }
        try {
            this.m_polyline.setPoint(new Point(), 2);
            PolylineTest.fail();
        }
        catch (IndexOutOfBoundsException e) {
            this.m_actualLogger.assertEmpty();
        }
        try {
            this.m_polyline.setPoint(null, 0);
            PolylineTest.fail();
        }
        catch (NullPointerException e) {
            this.m_actualLogger.assertEmpty();
        }
        Point point = new Point(3, 4);
        this.m_polyline.setPoint(point, 1);
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(3, -20, 8, 25)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((Object)new Point(3, 4), (Object)point);
        PolylineTest.assertNotSame((Object)point, (Object)this.m_polyline.getPoints().getPoint(1));
        PolylineTest.assertEquals((Object)point, (Object)this.m_polyline.getPoints().getPoint(1));
        point = new Point(-1, 2);
        this.m_polyline.setPoint(point, 0);
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(-1, 2, 5, 3)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((Object)new Point(-1, 2), (Object)point);
        PolylineTest.assertNotSame((Object)point, (Object)this.m_polyline.getPoints().getPoint(0));
        PolylineTest.assertEquals((Object)point, (Object)this.m_polyline.getPoints().getPoint(0));
    }

    @Test
    public void test_set_Start() throws Exception {
        PolylineTest.assertEquals((int)0, (int)this.m_polyline.getPoints().size());
        this.m_polyline.setStart(new Point(10, 10));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(10, 10, 1, 1)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)1, (int)this.m_polyline.getPoints().size());
        PolylineTest.assertEquals((Object)new Point(10, 10), (Object)this.m_polyline.getStart());
        this.m_polyline.setStart(new Point(120, -110));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(120, -110, 1, 1)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)1, (int)this.m_polyline.getPoints().size());
        PolylineTest.assertEquals((Object)new Point(120, -110), (Object)this.m_polyline.getStart());
    }

    @Test
    public void test_set_End() throws Exception {
        PolylineTest.assertEquals((int)0, (int)this.m_polyline.getPoints().size());
        this.m_polyline.setEnd(new Point(1, 1));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(1, 1, 1, 1)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)1, (int)this.m_polyline.getPoints().size());
        PolylineTest.assertEquals((Object)new Point(1, 1), (Object)this.m_polyline.getEnd());
        this.m_polyline = new Polyline();
        this.m_root.add((IFigure)this.m_polyline);
        this.m_polyline.addPoint(new Point());
        this.m_polyline.addPoint(new Point());
        PolylineTest.assertEquals((int)2, (int)this.m_polyline.getPoints().size());
        this.m_actualLogger.clear();
        this.m_polyline.setEnd(new Point(10, 10));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(0, 0, 11, 11)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)2, (int)this.m_polyline.getPoints().size());
        PolylineTest.assertEquals((Object)new Point(10, 10), (Object)this.m_polyline.getEnd());
        this.m_polyline.setEnd(new Point(120, -110));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(0, -110, 121, 111)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)2, (int)this.m_polyline.getPoints().size());
        PolylineTest.assertEquals((Object)new Point(120, -110), (Object)this.m_polyline.getEnd());
    }

    @Test
    public void test_set_Endpoints() throws Exception {
        this.m_polyline.addPoint(new Point());
        this.m_polyline.addPoint(new Point());
        this.m_actualLogger.clear();
        PolylineTest.assertEquals((int)2, (int)this.m_polyline.getPoints().size());
        this.m_polyline.setEndpoints(new Point(10, 10), new Point(120, -110));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(0, 0, 11, 11)");
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(10, -110, 111, 121)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)2, (int)this.m_polyline.getPoints().size());
        PolylineTest.assertEquals((Object)new Point(10, 10), (Object)this.m_polyline.getStart());
        PolylineTest.assertEquals((Object)new Point(120, -110), (Object)this.m_polyline.getEnd());
        this.m_polyline.setEndpoints(new Point(120, -110), new Point(10, 10));
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(120, -110, 1, 1)");
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(10, -110, 111, 121)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)2, (int)this.m_polyline.getPoints().size());
        PolylineTest.assertEquals((Object)new Point(120, -110), (Object)this.m_polyline.getStart());
        PolylineTest.assertEquals((Object)new Point(10, 10), (Object)this.m_polyline.getEnd());
    }

    @Test
    public void test_setPoints() throws Exception {
        this.m_polyline.addPoint(new Point(1, 2));
        this.m_polyline.addPoint(new Point(3, 4));
        this.m_actualLogger.clear();
        PointList list1 = this.m_polyline.getPoints();
        PointList list2 = new PointList();
        this.m_polyline.setPoints(list2);
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertNotSame((Object)list1, (Object)this.m_polyline.getPoints());
        PolylineTest.assertSame((Object)list2, (Object)this.m_polyline.getPoints());
    }

    @Test
    public void test_bounds() throws Exception {
        PolylineTest.assertEquals((Object)new Rectangle(), (Object)this.m_polyline.getBounds());
        this.m_polyline.setBounds(new Rectangle(10, 20, 30, 40));
        this.m_actualLogger.assertEmpty();
        PolylineTest.assertEquals((Object)new Rectangle(), (Object)this.m_polyline.getBounds());
        this.m_polyline.addPoint(new Point(10, 10));
        this.m_polyline.addPoint(new Point(20, 20));
        Rectangle bounds = this.m_polyline.getBounds();
        PolylineTest.assertEquals((Object)new Rectangle(10, 10, 11, 11).expand(this.m_polyline.getLineStyle() / 2, this.m_polyline.getLineStyle() / 2), (Object)bounds);
        PolylineTest.assertSame((Object)bounds, (Object)this.m_polyline.getBounds());
        this.m_polyline.addPoint(new Point(40, 40));
        Rectangle boundsNew = this.m_polyline.getBounds();
        PolylineTest.assertEquals((Object)new Rectangle(10, 10, 31, 31).expand(this.m_polyline.getLineStyle() / 2, this.m_polyline.getLineStyle() / 2), (Object)boundsNew);
        PolylineTest.assertSame((Object)bounds, (Object)boundsNew);
        PolylineTest.assertSame((Object)boundsNew, (Object)this.m_polyline.getBounds());
    }

    @Test
    public void test_containsPoint() throws Exception {
        Polyline polyline = new Polyline();
        polyline.addPoint(new Point(10, 10));
        polyline.addPoint(new Point(70, 20));
        polyline.addPoint(new Point(100, 100));
        polyline.addPoint(new Point(10, 100));
        polyline.addPoint(new Point(10, 10));
        PolylineTest.assertFalse((boolean)polyline.containsPoint(0, 0));
        PolylineTest.assertFalse((boolean)polyline.containsPoint(30, 40));
        PolylineTest.assertTrue((boolean)polyline.containsPoint(10, 10));
        PolylineTest.assertTrue((boolean)polyline.containsPoint(10, 100));
        PolylineTest.assertTrue((boolean)polyline.containsPoint(100, 100));
        PolylineTest.assertTrue((boolean)polyline.containsPoint(10, 32));
        PolylineTest.assertTrue((boolean)polyline.containsPoint(35, 100));
        PolylineTest.assertTrue((boolean)polyline.containsPoint(22, 12));
    }

    @Test
    public void test_opaque() throws Exception {
        PolylineTest.assertFalse((boolean)this.m_polyline.isOpaque());
        this.m_polyline.setOpaque(true);
        this.m_actualLogger.assertEmpty();
        PolylineTest.assertFalse((boolean)this.m_polyline.isOpaque());
        this.m_polyline.setOpaque(true);
        this.m_actualLogger.assertEmpty();
        PolylineTest.assertFalse((boolean)this.m_polyline.isOpaque());
        this.m_polyline.setOpaque(false);
        this.m_actualLogger.assertEmpty();
        PolylineTest.assertFalse((boolean)this.m_polyline.isOpaque());
        this.m_polyline.setOpaque(false);
        this.m_actualLogger.assertEmpty();
        PolylineTest.assertFalse((boolean)this.m_polyline.isOpaque());
    }

    @Test
    public void test_lineStyle() throws Exception {
        PolylineTest.assertEquals((int)1, (int)this.m_polyline.getLineStyle());
        this.m_polyline.setLineStyle(1);
        this.m_actualLogger.assertEmpty();
        PolylineTest.assertEquals((int)1, (int)this.m_polyline.getLineStyle());
        this.m_polyline.setLineStyle(3);
        this.m_expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)3, (int)this.m_polyline.getLineStyle());
    }

    @Test
    public void test_lineWidth() throws Exception {
        PolylineTest.assertEquals((int)1, (int)this.m_polyline.getLineWidth());
        this.m_polyline.setLineWidth(3);
        this.m_expectedLogger.log("invalidate");
        this.m_expectedLogger.log("repaint(-1, -1, 2, 2)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertEquals((int)3, (int)this.m_polyline.getLineWidth());
        this.m_polyline.setLineWidth(3);
        this.m_actualLogger.assertEmpty();
        PolylineTest.assertEquals((int)3, (int)this.m_polyline.getLineWidth());
    }

    @Test
    public void test_XorMode() throws Exception {
        PolylineTest.assertFalse((boolean)this.m_polyline.isXorMode());
        this.m_polyline.setXorMode(true);
        this.m_expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertTrue((boolean)this.m_polyline.isXorMode());
        this.m_polyline.setXorMode(true);
        this.m_actualLogger.assertEmpty();
        PolylineTest.assertTrue((boolean)this.m_polyline.isXorMode());
        this.m_polyline.setXorMode(false);
        this.m_expectedLogger.log("repaint(0, 0, 0, 0)");
        this.m_actualLogger.assertEquals(this.m_expectedLogger);
        PolylineTest.assertFalse((boolean)this.m_polyline.isXorMode());
        this.m_polyline.setXorMode(false);
        this.m_actualLogger.assertEmpty();
        PolylineTest.assertFalse((boolean)this.m_polyline.isXorMode());
    }
}

