/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.widgets;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SuperConstructorInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.association.ConstructorAssociation;
import org.eclipse.wb.core.model.association.ImplicitObjectAssociation;
import org.eclipse.wb.core.model.association.InvocationChildAssociation;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.creation.ConstructorCreationSupport;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.order.ComponentOrderFirst;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.ast.StatementTarget;
import org.eclipse.wb.internal.swt.model.layout.FillLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.ImplicitLayoutVariableSupport;
import org.eclipse.wb.internal.swt.model.layout.LayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.RowLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutCreationSupport;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutInfo;
import org.eclipse.wb.internal.swt.model.layout.absolute.AbsoluteLayoutVariableSupport;
import org.eclipse.wb.internal.swt.model.layout.grid.GridLayoutInfo;
import org.eclipse.wb.internal.swt.model.widgets.ButtonInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.core.PreferencesRepairer;
import org.eclipse.wb.tests.designer.rcp.BTestUtils;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class CompositeTest
extends RcpModelTest {
    private static Shell m_shouldNotBeSharedShell;

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_styleValue() throws Exception {
        CompositeInfo composite = this.parseComposite("class Test extends Composite{", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        composite.refresh();
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)composite);
        MethodDeclaration constructorDeclaration = typeDeclaration.getMethods()[0];
        List statements = DomGenerics.statements((Block)constructorDeclaration.getBody());
        SuperConstructorInvocation constructorInvocation = (SuperConstructorInvocation)statements.get(0);
        Expression styleArgument = (Expression)DomGenerics.arguments((SuperConstructorInvocation)constructorInvocation).get(1);
        CompositeTest.assertEquals((Object)0, (Object)JavaInfoEvaluationHelper.getValue((Expression)styleArgument));
        CompositeTest.assertNotNull((Object)composite.getPropertyByTitle("Style"));
    }

    @Test
    public void test_styleValue2() throws Exception {
        CompositeInfo composite = this.parseComposite("class Test extends Composite{", "  public Test(Composite parent, int style) {", "    super(parent, SWT.BORDER);", "  }", "}");
        composite.refresh();
        Expression styleArgument = (Expression)this.m_lastEditor.getEnclosingNode("SWT.BORDER").getParent();
        CompositeTest.assertEquals((Object)2048, (Object)JavaInfoEvaluationHelper.getValue((Expression)styleArgument));
    }

    @Test
    public void test_betterStyleParameterDetection() throws Exception {
        CompositeTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("// filler filler filler filler filler", "public class MyComposite extends Composite {", "  public MyComposite(Composite parent, String title) {", "    super(parent, SWT.NONE);", "  }", "}"));
        CompositeTest.waitForAutoBuild();
        CompositeTest.useStrictEvaluationMode(false);
        this.parseComposite("public class Test extends Composite {", "  public Test(Composite parent, String title) {", "    super(parent, SWT.NONE);", "    new MyComposite(parent, title);", "  }", "}");
    }

    @Test
    public void test_AbsoluteLayout_1() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    Button button = new Button(shell, SWT.NONE);", "    button.setBounds(10, 20, 50, 30);", "    button.setText('push');", "  }", "}");
        List children = shellInfo.getChildrenJava();
        CompositeTest.assertEquals((int)2, (int)children.size());
        CompositeTest.assertSame(children.get(0), (Object)shellInfo.getLayout());
        CompositeTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)shellInfo.getLayout());
        CompositeTest.assertInstanceOf(ControlInfo.class, children.get(1));
    }

    @Test
    public void test_AbsoluteLayout_2() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(null);", "    Button button = new Button(shell, SWT.NONE);", "    button.setBounds(10, 20, 50, 30);", "    button.setText('push');", "  }", "}");
        List children = shellInfo.getChildrenJava();
        CompositeTest.assertEquals((int)2, (int)children.size());
        CompositeTest.assertInstanceOf(ControlInfo.class, children.get(0));
        LayoutInfo layout = shellInfo.getLayout();
        CompositeTest.assertSame(children.get(1), (Object)layout);
        CompositeTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)layout);
        CompositeTest.assertEquals((Object)"null", (Object)layout.getCreationSupport().toString());
        VariableSupport variableSupport = layout.getVariableSupport();
        CompositeTest.assertInstanceOf(AbsoluteLayoutVariableSupport.class, (Object)variableSupport);
        CompositeTest.assertEquals((Object)"absolute", (Object)variableSupport.toString());
        CompositeTest.assertFalse((boolean)variableSupport.hasName());
        try {
            variableSupport.getName();
            CompositeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.setName("foo");
            CompositeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.getTitle();
            CompositeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CompositeTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        try {
            variableSupport.convertLocalToField();
            CompositeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        CompositeTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertFieldToLocal();
            CompositeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.getStatementTarget();
            CompositeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.getReferenceExpression(null);
            CompositeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.getAccessExpression(null);
            CompositeTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test_hasLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        CompositeTest.assertTrue((boolean)shell.hasLayout());
        Assertions.assertThat((List)shell.getChildren(LayoutInfo.class)).hasSize(1);
        shell.markNoLayout();
        CompositeTest.assertFalse((boolean)shell.hasLayout());
        Assertions.assertThat((List)shell.getChildren(LayoutInfo.class)).isEmpty();
    }

    @Test
    public void test_setLayout_1() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "  }", "}");
        LayoutInfo oldLayout = shellInfo.getLayout();
        CompositeTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)oldLayout.getCreationSupport());
        FillLayoutInfo newLayout = (FillLayoutInfo)CompositeTest.createJavaInfo("org.eclipse.swt.layout.FillLayout");
        shellInfo.setLayout((LayoutInfo)newLayout);
        CompositeTest.assertSame((Object)newLayout, (Object)shellInfo.getLayout());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout(SWT.HORIZONTAL));", "  }", "}");
        newLayout.delete();
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "  }", "}");
    }

    @Test
    public void test_setLayout_2() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(null);", "  }", "}");
        shellInfo.refresh();
        LayoutInfo oldLayout = shellInfo.getLayout();
        CompositeTest.assertNotInstanceOf(ImplicitLayoutCreationSupport.class, oldLayout.getCreationSupport());
        FillLayoutInfo newLayout = (FillLayoutInfo)CompositeTest.createJavaInfo("org.eclipse.swt.layout.FillLayout");
        shellInfo.setLayout((LayoutInfo)newLayout);
        CompositeTest.assertSame((Object)newLayout, (Object)shellInfo.getLayout());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout(SWT.HORIZONTAL));", "  }", "}");
        Property property = shellInfo.getPropertyByTitle("Layout");
        CompositeTest.assertTrue((boolean)property.isModified());
        property.setValue(Property.UNKNOWN_VALUE);
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "  }", "}");
    }

    @Test
    public void test_setLayout_3() throws Exception {
        CompositeInfo shellInfo = this.parseComposite("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new FillLayout());", "  }", "}");
        LayoutInfo layout = shellInfo.getLayout();
        CompositeTest.assertInstanceOf(FillLayoutInfo.class, (Object)layout);
        GridLayoutInfo gridLayout = (GridLayoutInfo)CompositeTest.createJavaInfo("org.eclipse.swt.layout.GridLayout");
        shellInfo.setLayout((LayoutInfo)gridLayout);
        CompositeTest.assertSame((Object)gridLayout, (Object)shellInfo.getLayout());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new GridLayout(1, false));", "  }", "}");
        RowLayoutInfo rowLayout = (RowLayoutInfo)CompositeTest.createJavaInfo("org.eclipse.swt.layout.RowLayout");
        shellInfo.setLayout((LayoutInfo)rowLayout);
        CompositeTest.assertSame((Object)rowLayout, (Object)shellInfo.getLayout());
        this.assertEditor("class Test {", "  public static void main(String[] args) {", "    Shell shell = new Shell();", "    shell.setLayout(new RowLayout(SWT.HORIZONTAL));", "  }", "}");
    }

    @Test
    public void test_setLayout_4() throws Exception {
        CompositeTest.setFileContentSrc("test/MyLayout.java", this.getTestSource("public class MyLayout extends Layout {", "  protected Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {", "    return new Point(100, 100);", "  }", "  protected void layout(Composite composite, boolean flushCache) {", "  }", "}"));
        CompositeTest.setFileContentSrc("test/MyLayout.wbp-component.xml", CompositeTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='layout.setInBlock'>true</parameter>", "  </parameters>", "</component>"));
        CompositeTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("// filler filler filler", "class Test extends Shell {", "  Test() {", "  }", "}");
        shell.refresh();
        LayoutInfo newLayout = (LayoutInfo)CompositeTest.createJavaInfo("test.MyLayout");
        shell.setLayout(newLayout);
        CompositeTest.assertSame((Object)newLayout, (Object)shell.getLayout());
        this.assertEditor("// filler filler filler", "class Test extends Shell {", "  Test() {", "    {", "      setLayout(new MyLayout());", "    }", "  }", "}");
    }

    @Test
    public void test_setLayout_order() throws Exception {
        CompositeInfo composite = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new Button(this, SWT.NONE);", "  }", "}");
        CompositeTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new Button(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: org.eclipse.swt.widgets.Button} {empty} {/new Button(this, SWT.NONE)/}");
        LayoutInfo layout = (LayoutInfo)CompositeTest.createJavaInfo("org.eclipse.swt.layout.RowLayout");
        CompositeTest.assertSame((Object)ComponentOrderFirst.INSTANCE, (Object)layout.getDescription().getOrder());
        composite.setLayout(layout);
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout(SWT.HORIZONTAL));", "    new Button(this, SWT.NONE);", "  }", "}");
        CompositeTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new Button(this, SWT.NONE)/ /setLayout(new RowLayout(SWT.HORIZONTAL))/}", "  {new: org.eclipse.swt.layout.RowLayout} {empty} {/setLayout(new RowLayout(SWT.HORIZONTAL))/}", "  {new: org.eclipse.swt.widgets.Button} {empty} {/new Button(this, SWT.NONE)/}", "    {virtual-layout_data: org.eclipse.swt.layout.RowData} {virtual-layout-data} {}");
    }

    @Test
    public void test_setLayout_ifMarkedAsNoLayout() throws Exception {
        CompositeTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "}"));
        CompositeTest.setFileContentSrc("test/MyComposite.wbp-component.xml", CompositeTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='layout.has'>false</parameter>", "  </parameters>", "</component>"));
        CompositeTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("// filler filler filler", "public class Test extends MyComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new RowLayout());", "  }", "}");
        CompositeTest.assertFalse((boolean)composite.hasLayout());
        CompositeTest.assertHierarchy("{this: test.MyComposite} {this} {/setLayout(new RowLayout())/}");
    }

    @Test
    public void test_ImplicitLayout_1() throws Exception {
        CompositeTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "  }", "}"));
        CompositeTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        composite.refresh();
        LayoutInfo layout = composite.getLayout();
        CreationSupport creationSupport = layout.getCreationSupport();
        CompositeTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)creationSupport);
        CompositeTest.assertTrue((boolean)creationSupport.canDelete());
        CompositeTest.assertEquals((Object)"implicit-layout: org.eclipse.swt.layout.GridLayout", (Object)creationSupport.toString());
        VariableSupport variableSupport = layout.getVariableSupport();
        CompositeTest.assertInstanceOf(ImplicitLayoutVariableSupport.class, (Object)variableSupport);
        CompositeTest.assertTrue((boolean)variableSupport.isDefault());
        CompositeTest.assertEquals((Object)"implicit-layout", (Object)variableSupport.toString());
        CompositeTest.assertEquals((Object)"(implicit layout)", (Object)variableSupport.getTitle());
        Property property = layout.getPropertyByTitle("marginWidth");
        CompositeTest.assertNotNull((Object)property);
        CompositeTest.assertEquals((Object)5, (Object)property.getValue());
        property.setValue((Object)10);
        CompositeTest.assertEquals((Object)10, (Object)property.getValue());
        this.assertEditor("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    GridLayout gridLayout = (GridLayout) getLayout();", "    gridLayout.marginWidth = 10;", "  }", "}");
        CompositeTest.assertNotInstanceOf(ImplicitLayoutVariableSupport.class, layout.getVariableSupport());
        composite.getLayout().delete();
        CompositeTest.assertInstanceOf(ImplicitLayoutVariableSupport.class, (Object)layout.getVariableSupport());
        this.assertEditor("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
    }

    @Test
    public void test_ImplicitLayout_2() throws Exception {
        CompositeTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "}"));
        CompositeTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        composite.refresh();
        LayoutInfo layout = composite.getLayout();
        CreationSupport creationSupport = layout.getCreationSupport();
        CompositeTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)creationSupport);
        CompositeTest.assertTrue((boolean)creationSupport.canDelete());
        CompositeTest.assertEquals((Object)"implicit-layout: absolute", (Object)creationSupport.toString());
        VariableSupport variableSupport = layout.getVariableSupport();
        CompositeTest.assertInstanceOf(ImplicitLayoutVariableSupport.class, (Object)variableSupport);
        CompositeTest.assertTrue((boolean)variableSupport.isDefault());
        CompositeTest.assertEquals((Object)"implicit-layout", (Object)variableSupport.toString());
        CompositeTest.assertEquals((Object)"(implicit layout)", (Object)variableSupport.getTitle());
    }

    @Test
    public void test_ImplicitLayout_3() throws Exception {
        CompositeTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "  }", "}"));
        CompositeTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        LayoutInfo implicitLayout = composite.getLayout();
        CompositeTest.assertInstanceOf(GridLayoutInfo.class, (Object)implicitLayout);
        CompositeTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)implicitLayout.getCreationSupport());
        GridLayoutInfo gridLayout = (GridLayoutInfo)CompositeTest.createJavaInfo("org.eclipse.swt.layout.GridLayout");
        composite.setLayout((LayoutInfo)gridLayout);
        CompositeTest.assertSame((Object)gridLayout, (Object)composite.getLayout());
        this.assertEditor("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(1, false));", "  }", "}");
        gridLayout.delete();
        CompositeTest.assertSame((Object)implicitLayout, (Object)composite.getLayout());
        this.assertEditor("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
    }

    @Test
    public void test_ImplicitLayout_overset() throws Exception {
        CompositeTest.setFileContentSrc("test/ImplicitComposite.java", this.getTestSource("public class ImplicitComposite extends Composite {", "  public ImplicitComposite(Composite parent, int style) {", "    super(parent, style);", "    setLayout(new GridLayout(2, false));", "  }", "}"));
        CompositeTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends ImplicitComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "    setLayout(null);", "  }", "}");
        composite.refresh();
        LayoutInfo layout = composite.getLayout();
        CompositeTest.assertInstanceOf(AbsoluteLayoutInfo.class, (Object)layout);
        CompositeTest.assertInstanceOf(AbsoluteLayoutCreationSupport.class, (Object)layout.getCreationSupport());
        CompositeTest.assertInstanceOf(AbsoluteLayoutVariableSupport.class, (Object)layout.getVariableSupport());
        CompositeTest.assertInstanceOf(InvocationChildAssociation.class, (Object)layout.getAssociation());
        CompositeTest.assertTrue((boolean)layout.canDelete());
        layout.delete();
        layout = composite.getLayout();
        CompositeTest.assertNotInstanceOf(AbsoluteLayoutInfo.class, layout);
        CompositeTest.assertInstanceOf(ImplicitLayoutCreationSupport.class, (Object)layout.getCreationSupport());
        CompositeTest.assertInstanceOf(ImplicitLayoutVariableSupport.class, (Object)layout.getVariableSupport());
        CompositeTest.assertInstanceOf(ImplicitObjectAssociation.class, (Object)layout.getAssociation());
    }

    @Test
    public void test_placeholder_hasLayout() throws Exception {
        CompositeTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    throw new IllegalStateException('actual');", "  }", "}"));
        CompositeTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new MyComposite(this, SWT.NONE);", "  }", "}");
        CompositeTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new MyComposite(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: test.MyComposite} {empty} {/new MyComposite(this, SWT.NONE)/}");
        shell.refresh();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        CompositeTest.assertFalse((boolean)composite.hasLayout());
    }

    @Test
    public void test_placeholder_andChildren() throws Exception {
        CompositeTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "    throw new IllegalStateException('actual');", "  }", "}"));
        CompositeTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    Composite composite = new MyComposite(this, SWT.NONE);", "    new Button(composite, SWT.NONE);", "  }", "}");
        CompositeTest.assertHierarchy("{this: org.eclipse.swt.widgets.Shell} {this} {/new MyComposite(this, SWT.NONE)/}", "  {implicit-layout: absolute} {implicit-layout} {}", "  {new: test.MyComposite} {local-unique: composite} {/new MyComposite(this, SWT.NONE)/ /new Button(composite, SWT.NONE)/}", "    {new: org.eclipse.swt.widgets.Button} {empty} {/new Button(composite, SWT.NONE)/}");
        shell.refresh();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        ControlInfo button = (ControlInfo)composite.getChildrenControls().get(0);
        CompositeTest.assertNotNull((Object)composite.getObject());
        CompositeTest.assertNotNull((Object)button.getObject());
    }

    @Test
    public void test_setDefaultLayout() throws Exception {
        CompositeInfo composite;
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        IPreferenceStore preferences = shell.getDescription().getToolkit().getPreferences();
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(preferences);
        CompositeTest.assertTrue((boolean)StringUtils.isEmpty((CharSequence)preferences.getString("layout.default")));
        preferencesRepairer.setValue("layout.default", "gridLayout");
        try {
            composite = (CompositeInfo)BTestUtils.createControl("org.eclipse.swt.widgets.Composite");
            composite.putArbitraryValue((Object)"manuallyCreatedComponent", (Object)Boolean.TRUE);
            fillLayout.command_CREATE((ControlInfo)composite, null);
            CompositeTest.waitEventLoop(1);
        }
        finally {
            preferencesRepairer.restore();
        }
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new GridLayout(1, false));", "    }", "  }", "}");
        CompositeTest.assertNotSame((Object)fillLayout, (Object)composite.getLayout());
    }

    @Test
    public void test_inheritParentLayout() throws Exception {
        CompositeInfo composite;
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "  }", "}");
        FillLayoutInfo fillLayout = (FillLayoutInfo)shell.getLayout();
        IPreferenceStore preferences = shell.getDescription().getToolkit().getPreferences();
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(preferences);
        CompositeTest.assertFalse((boolean)preferences.getBoolean("layout.inheritLayoutOfParent"));
        preferencesRepairer.setValue("layout.inheritLayoutOfParent", true);
        try {
            composite = (CompositeInfo)BTestUtils.createControl("org.eclipse.swt.widgets.Composite");
            composite.putArbitraryValue((Object)"manuallyCreatedComponent", (Object)Boolean.TRUE);
            fillLayout.command_CREATE((ControlInfo)composite, null);
            CompositeTest.waitEventLoop(1);
        }
        finally {
            preferencesRepairer.restore();
        }
        this.assertEditor("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(new FillLayout(SWT.HORIZONTAL));", "    }", "  }", "}");
        CompositeTest.assertNotSame((Object)fillLayout, (Object)composite.getLayout());
    }

    @Test
    public void test_inheritParentLayout_nullImplicit() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        IPreferenceStore preferences = shell.getDescription().getToolkit().getPreferences();
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(preferences);
        CompositeTest.assertFalse((boolean)preferences.getBoolean("layout.inheritLayoutOfParent"));
        preferencesRepairer.setValue("layout.inheritLayoutOfParent", true);
        try {
            CompositeInfo composite = (CompositeInfo)CompositeTest.createJavaInfo("org.eclipse.swt.widgets.Composite");
            shell.getLayout().command_CREATE((ControlInfo)composite, null);
            CompositeTest.waitEventLoop(1);
        }
        finally {
            preferencesRepairer.restore();
        }
        this.assertEditor("// filler filler filler filler filler", "public class Test extends Shell {", "  public Test() {", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "    }", "  }", "}");
    }

    @Test
    public void test_inheritParentLayout_nullExplicit() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "  }", "}");
        IPreferenceStore preferences = shell.getDescription().getToolkit().getPreferences();
        PreferencesRepairer preferencesRepairer = new PreferencesRepairer(preferences);
        CompositeTest.assertFalse((boolean)preferences.getBoolean("layout.inheritLayoutOfParent"));
        preferencesRepairer.setValue("layout.inheritLayoutOfParent", true);
        try {
            CompositeInfo composite = (CompositeInfo)CompositeTest.createJavaInfo("org.eclipse.swt.widgets.Composite");
            shell.getLayout().command_CREATE((ControlInfo)composite, null);
            CompositeTest.waitEventLoop(1);
        }
        finally {
            preferencesRepairer.restore();
        }
        this.assertEditor("// filler filler filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "      composite.setLayout(null);", "    }", "  }", "}");
    }

    @Test
    public void test_checkSubclass_andBinaryExecutionFlow() throws Exception {
        CompositeTest.setFileContentSrc("test/MyComposite.java", this.getTestSource("public class MyComposite extends Composite {", "  public MyComposite(Composite parent, int style) {", "    super(parent, style);", "  }", "}"));
        CompositeTest.waitForAutoBuild();
        CompositeInfo composite = this.parseComposite("public class Test extends MyComposite {", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "  protected void checkSubclass() {", "  }", "}");
        composite.refresh();
        CompositeTest.assertNoErrors((JavaInfo)composite);
    }

    @Test
    public void test_setLayoutMenu_1() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
        CompositeTest.assertTrue((boolean)shell.hasLayout());
        IMenuManager menuManager = CompositeTest.getContextMenu(new ObjectInfo[]{shell});
        IMenuManager layoutManager = CompositeTest.findChildMenuManager((IContributionManager)menuManager, "Set layout");
        CompositeTest.assertNotNull((Object)layoutManager);
        CompositeTest.assertNotNull((Object)CompositeTest.findChildAction((IContributionManager)layoutManager, "GridLayout"));
        CompositeTest.assertNotNull((Object)CompositeTest.findChildAction((IContributionManager)layoutManager, "FillLayout"));
        CompositeTest.assertNotNull((Object)CompositeTest.findChildAction((IContributionManager)layoutManager, "RowLayout"));
        IAction action = CompositeTest.findChildAction((IContributionManager)layoutManager, "RowLayout");
        action.run();
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setLayout(new RowLayout(SWT.HORIZONTAL));", "  }", "}");
        action = CompositeTest.findChildAction((IContributionManager)layoutManager, "Absolute layout");
        action.run();
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setLayout(null);", "  }", "}");
    }

    @Test
    public void test_setLayoutMenu_2() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    new Table(this, SWT.BORDER);", "  }", "}");
        CompositeInfo table = (CompositeInfo)shell.getChildrenControls().get(0);
        CompositeTest.assertFalse((boolean)table.hasLayout());
        IMenuManager menuManager = CompositeTest.getContextMenu(new ObjectInfo[]{table});
        IMenuManager layoutManager = CompositeTest.findChildMenuManager((IContributionManager)menuManager, "Set layout");
        CompositeTest.assertNull((Object)layoutManager);
    }

    @Test
    public void test_contextMenu_setMinimalSize_forRoot() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Button button = new Button(this, SWT.NONE);", "      button.setText('Some long long long long long long text');", "    }", "  }", "}");
        shell.refresh();
        IMenuManager contextMenu = CompositeTest.getContextMenu(new ObjectInfo[]{shell});
        IAction action = CompositeTest.findChildAction((IContributionManager)contextMenu, "Set minimal size, as after pack()");
        CompositeTest.assertNotNull((Object)action);
        action.run();
        CompositeTest.assertEquals((Object)shell.getPreferredSize(), (Object)shell.getBounds().getSize());
    }

    @Test
    public void test_contextMenu_setMinimalSize_noActionForInner() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    {", "      Composite composite = new Composite(this, SWT.NONE);", "    }", "  }", "}");
        shell.refresh();
        CompositeInfo composite = (CompositeInfo)shell.getChildrenControls().get(0);
        IMenuManager contextMenu = CompositeTest.getContextMenu(new ObjectInfo[]{composite});
        IAction action = CompositeTest.findChildAction((IContributionManager)contextMenu, "Set minimal size, as after pack()");
        CompositeTest.assertNull((Object)action);
    }

    @Test
    public void test_contextMenu_removeSize() throws Exception {
        CompositeInfo shell = this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setSize(400, 500);", "  }", "}");
        shell.refresh();
        IMenuManager contextMenu = CompositeTest.getContextMenu(new ObjectInfo[]{shell});
        IAction action = CompositeTest.findChildAction((IContributionManager)contextMenu, "Remove setSize()");
        CompositeTest.assertNotNull((Object)action);
        action.run();
        this.assertEditor("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "  }", "}");
    }

    @Test
    public void test_getAssociation_Control() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    Button button = new Button(this, SWT.NONE);", "    button.setText('');", "  }", "}");
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        ConstructorCreationSupport support = (ConstructorCreationSupport)button.getCreationSupport();
        ConstructorAssociation association = (ConstructorAssociation)button.getAssociation();
        CompositeTest.assertSame((Object)support.getCreation(), (Object)association.getCreation());
    }

    @Test
    public void test_getAssociation_setLayout() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    Button button = new Button(this, SWT.NONE);", "    button.setText('');", "  }", "}");
        LayoutInfo layout = shell.getLayout();
        InvocationChildAssociation association = (InvocationChildAssociation)layout.getAssociation();
        CompositeTest.assertSame((Object)shell.getMethodInvocation("setLayout(org.eclipse.swt.widgets.Layout)"), (Object)association.getInvocation());
    }

    @Test
    public void test_createInMethod() throws Exception {
        CompositeInfo shell = this.parseComposite("class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    createButton(this).setEnabled(false);", "  }", "  private Button createButton(Composite parent) {", "    Button button = new Button(parent, SWT.NONE);", "    button.setText('abc');", "    return button;", "  }", "}");
        ButtonInfo buttonInfo = (ButtonInfo)shell.getChildrenControls().get(0);
        shell.refresh();
        Button button = buttonInfo.getWidget();
        CompositeTest.assertEquals((Object)"abc", (Object)button.getText());
        CompositeTest.assertEquals((Object)Boolean.FALSE, (Object)button.getEnabled());
    }

    @Test
    public void test_target_Shell() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test {", "  public static void main(String[] args) {", "    Display display = Display.getDefault();", "    Shell shell = new Shell();", "    shell.setLayout(new GridLayout());", "    shell.open();", "    shell.layout();", "    while (!shell.isDisposed()) {", "      if (!display.readAndDispatch()) {", "        display.sleep();", "      }", "    }", "  }", "}");
        StatementTarget target = JavaInfoUtils.getTarget((JavaInfo)shell, null);
        CompositeTest.assertNull((Object)target.getBlock());
        CompositeTest.assertEquals((Object)"shell.setLayout(new GridLayout());", (Object)this.m_lastEditor.getSource((ASTNode)target.getStatement()));
    }

    @Test
    public void test_shouldDrawDotsBorder() throws Exception {
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setLayout(new FillLayout());", "    new Composite(this, SWT.NONE);", "    new Composite(this, SWT.BORDER);", "    new Table(this, SWT.NONE);", "  }", "}");
        shell.refresh();
        CompositeInfo composite_noBorder = (CompositeInfo)shell.getChildrenControls().get(0);
        CompositeInfo composite_withBorder = (CompositeInfo)shell.getChildrenControls().get(1);
        CompositeInfo table = (CompositeInfo)shell.getChildrenControls().get(2);
        CompositeTest.assertTrue((boolean)composite_noBorder.shouldDrawDotsBorder());
        CompositeTest.assertFalse((boolean)composite_withBorder.shouldDrawDotsBorder());
        CompositeTest.assertFalse((boolean)table.shouldDrawDotsBorder());
    }

    @Test
    public void test_useSeparateShell_1() throws Exception {
        Shell shell_1;
        CompositeInfo composite = this.parseComposite("class Test extends Composite{", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        composite.refresh();
        m_shouldNotBeSharedShell = shell_1 = composite.getWidget().getShell();
    }

    @Test
    public void test_useSeparateShell_2() throws Exception {
        CompositeInfo composite = this.parseComposite("class Test extends Composite{", "  public Test(Composite parent, int style) {", "    super(parent, style);", "  }", "}");
        composite.refresh();
        Shell shell_2 = composite.getWidget().getShell();
        CompositeTest.assertNotSame((Object)shell_2, (Object)m_shouldNotBeSharedShell);
        CompositeTest.assertTrue((boolean)m_shouldNotBeSharedShell.isDisposed());
        m_shouldNotBeSharedShell = null;
    }
}

