/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swt.model.property;

import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.rcp.ToolkitProvider;
import org.eclipse.wb.internal.swt.model.property.editor.color.ColorPropertyEditor;
import org.eclipse.wb.tests.designer.swt.model.property.ColorPropertyEditorTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;
import org.eclipse.wb.tests.designer.tests.common.GenericPropertyNoValue;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ColorPropertyEditorTestNoManager
extends ColorPropertyEditorTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("useResourceManager", false);
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_textSource_noValue() throws Exception {
        GenericPropertyNoValue property = new GenericPropertyNoValue(null, null, ColorPropertyEditor.INSTANCE);
        ColorPropertyEditorTestNoManager.assertNull((Object)PropertyEditorTestUtils.getText((Property)property));
        ColorPropertyEditorTestNoManager.assertNull((Object)PropertyEditorTestUtils.getClipboardSource((Property)property));
    }

    @Test
    public void test_textSource_systemConstant() throws Exception {
        this.assert_getText_getClipboardSource_forSource("Display.getCurrent().getSystemColor(SWT.COLOR_RED)", "COLOR_RED", "org.eclipse.swt.widgets.Display.getCurrent().getSystemColor(org.eclipse.swt.SWT.COLOR_RED)");
    }

    @Test
    public void test_textSource_systemNumber() throws Exception {
        this.assert_getText_getClipboardSource_forSource("Display.getCurrent().getSystemColor(3)", "COLOR_RED", "org.eclipse.swt.widgets.Display.getCurrent().getSystemColor(org.eclipse.swt.SWT.COLOR_RED)");
    }

    @Test
    public void test_textSource_systemBad() throws Exception {
        try {
            this.assert_getText_getClipboardSource_forSource("Display.getCurrent().getSystemColor(-1)", null, null);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void test_getText_constructor_ints() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Color(null, 1, 2, 3)", "1, 2, 3", "new org.eclipse.swt.graphics.Color(null, 1, 2, 3)");
    }

    @Test
    public void test_getText_constructor_RGB() throws Exception {
        this.assert_getText_getClipboardSource_forSource("new Color(null, new RGB(1, 2, 3))", "1, 2, 3", "new org.eclipse.swt.graphics.Color(null, 1, 2, 3)");
    }
}

