/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gef;

import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gef.AbstractLayoutPolicyTest;
import org.junit.jupiter.api.Test;

public class BorderLayoutPolicyTest
extends AbstractLayoutPolicyTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_canvas_setLayout() throws Exception {
        String source = "// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t}\n}";
        String source2 = "// filler filler filler\npublic class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout(0, 0));\n\t}\n}";
        this.check_setLayout(source, "java.awt.BorderLayout", source2, 10, 10);
    }

    @Test
    public void test_canvas_CREATE() throws Exception {
        this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t}\n}");
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.canvas.moveTo((Object)this.m_contentEditPart, 10, 10);
        this.canvas.assertFeedbackFigures(6);
        BorderLayoutPolicyTest.waitEventLoop(10);
        this.canvas.click();
        this.canvas.assertNoFeedbackFigures();
        BorderLayoutPolicyTest.waitEventLoop(10);
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_canvas_MOVE_1() throws Exception {
        this.check_MOVE("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton(\"Button\");\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_canvas_MOVE_2() throws Exception {
        this.check_MOVE("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(getButton(), BorderLayout.NORTH);\n\t}\n\tprivate JButton button;\n\tprivate JButton getButton() {\n\t\tif (button == null) {\n\t\t\tbutton = new JButton();\n\t\t}\n\t\treturn button;\n\t}\n}");
    }

    @Test
    public void test_canvas_MOVE_3() throws Exception {
        String source = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tfinal JButton button = new JButton();\n\t\t\tadd(button);\n\t\t}\n\t}\n}";
        String expectedSource = source.replace("add(button);", "add(button, BorderLayout.SOUTH);");
        this.check_MOVE(source, expectedSource);
    }

    private void check_MOVE(String lines) throws Exception {
        String expectedSource = lines.replace("NORTH", "SOUTH");
        this.check_MOVE(lines, expectedSource);
    }

    private void check_MOVE(String source, String expectedSource) throws Exception, InterruptedException {
        ContainerInfo panel = this.openContainer(source);
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        this.canvas.beginDrag(button);
        this.canvas.assertNoFeedbackFigures();
        this.canvas.dragTo((Object)panel, 10, -10);
        this.canvas.assertFeedbackFigures(5);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        this.assertEditor(expectedSource);
    }

    @Test
    public void test_canvas_ADD_1() throws Exception {
        String source = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tpanel.setBackground(Color.PINK);\n\t\t\tpanel.setPreferredSize(new Dimension(0, 150));\n\t\t\tadd(panel, BorderLayout.SOUTH);\n\t\t\t{\n\t\t\t\tJButton button_1 = new JButton(\"Button 1\");\n\t\t\t\tpanel.add(button_1);\n\t\t\t}\n\t\t\t{\n\t\t\t\tJButton button_2 = new JButton(\"Button 2\");\n\t\t\t\tpanel.add(button_2);\n\t\t\t}\n\t\t}\n\t}\n}";
        String source2 = "public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJPanel panel = new JPanel();\n\t\t\tpanel.setBackground(Color.PINK);\n\t\t\tpanel.setPreferredSize(new Dimension(0, 150));\n\t\t\tadd(panel, BorderLayout.SOUTH);\n\t\t\t{\n\t\t\t\tJButton button_2 = new JButton(\"Button 2\");\n\t\t\t\tpanel.add(button_2);\n\t\t\t}\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton(\"Button 1\");\n\t\t\tadd(button_1, BorderLayout.NORTH);\n\t\t}\n\t}\n}";
        this.check_ADD(source, source2);
    }

    @Test
    public void test_canvas_ADD_2() throws Exception {
        String source = "public class Test extends JPanel {\n\tprivate JPanel panel;\n\tprivate JButton button_1;\n\tprivate JButton button_2;\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(getPanel(), BorderLayout.SOUTH);\n\t}\n\tprivate JPanel getPanel() {\n\t\tif (panel == null) {\n\t\t\tpanel = new JPanel();\n\t\t\tpanel.setBackground(Color.PINK);\n\t\t\tpanel.setPreferredSize(new Dimension(0, 150));\n\t\t\tpanel.add(getButton_1());\n\t\t\tpanel.add(getButton_2());\n\t\t}\n\t\treturn panel;\n\t}\n\tprivate JButton getButton_1() {\n\t\tif (button_1 == null) {\n\t\t\tbutton_1 = new JButton(\"Button 1\");\n\t\t}\n\t\treturn button_1;\n\t}\n\tprivate JButton getButton_2() {\n\t\tif (button_2 == null) {\n\t\t\tbutton_2 = new JButton(\"button 2\");\n\t\t}\n\t\treturn button_2;\n\t}\n}";
        String source2 = "public class Test extends JPanel {\n\tprivate JPanel panel;\n\tprivate JButton button_1;\n\tprivate JButton button_2;\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(getPanel(), BorderLayout.SOUTH);\n\t\tadd(getButton_1(), BorderLayout.NORTH);\n\t}\n\tprivate JPanel getPanel() {\n\t\tif (panel == null) {\n\t\t\tpanel = new JPanel();\n\t\t\tpanel.setBackground(Color.PINK);\n\t\t\tpanel.setPreferredSize(new Dimension(0, 150));\n\t\t\tpanel.add(getButton_2());\n\t\t}\n\t\treturn panel;\n\t}\n\tprivate JButton getButton_1() {\n\t\tif (button_1 == null) {\n\t\t\tbutton_1 = new JButton(\"Button 1\");\n\t\t}\n\t\treturn button_1;\n\t}\n\tprivate JButton getButton_2() {\n\t\tif (button_2 == null) {\n\t\t\tbutton_2 = new JButton(\"button 2\");\n\t\t}\n\t\treturn button_2;\n\t}\n}";
        this.check_ADD(source, source2);
    }

    private void check_ADD(String source, String source2) throws Exception {
        ContainerInfo panel = this.openContainer(source);
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)inner.getChildrenComponents().get(0);
        this.canvas.beginDrag(button);
        this.canvas.assertNoFeedbackFigures();
        this.canvas.dragTo((Object)panel, 10, 10);
        this.canvas.assertFeedbackFigures(5);
        BorderLayoutPolicyTest.waitEventLoop(10);
        this.canvas.endDrag();
        this.canvas.assertNoFeedbackFigures();
        BorderLayoutPolicyTest.waitEventLoop(10);
        this.assertEditor(source2);
    }

    @Test
    public void test_tree_CREATE_hasEmptyRegion() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t}\n}");
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNotNull();
        this.tree.click();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_tree_CREATE_noEmptyRegion() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\tadd(new JButton(), BorderLayout.NORTH);\n\t\tadd(new JButton(), BorderLayout.SOUTH);\n\t\tadd(new JButton(), BorderLayout.WEST);\n\t\tadd(new JButton(), BorderLayout.EAST);\n\t\tadd(new JButton(), BorderLayout.CENTER);\n\t}\n}");
        this.loadCreationTool("javax.swing.JButton", "empty");
        this.tree.moveOn(panel);
        this.tree.assertFeedback_on(panel);
        this.tree.assertCommandNull();
    }

    @Test
    public void test_tree_MOVE() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tadd(button_1, BorderLayout.NORTH);\n\t\t}\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tadd(button_2, BorderLayout.SOUTH);\n\t\t}\n\t}\n}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        this.tree.startDrag(button_2).dragBefore(button_1);
        this.tree.assertCommandNotNull();
        this.tree.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button_2 = new JButton();\n\t\t\tadd(button_2, BorderLayout.SOUTH);\n\t\t}\n\t\t{\n\t\t\tJButton button_1 = new JButton();\n\t\t\tadd(button_1, BorderLayout.NORTH);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_tree_ADD() throws Exception {
        ContainerInfo panel = this.openContainer("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner, BorderLayout.CENTER);\n\t\t\t{\n\t\t\t\tJButton button = new JButton();\n\t\t\t\tinner.add(button);\n\t\t\t}\n\t\t}\n\t}\n}");
        ContainerInfo inner = (ContainerInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button = (ComponentInfo)inner.getChildrenComponents().get(0);
        this.tree.startDrag(button).dragBefore(inner);
        this.tree.assertCommandNotNull();
        this.tree.endDrag();
        this.assertEditor("public class Test extends JPanel {\n\tpublic Test() {\n\t\tsetLayout(new BorderLayout());\n\t\t{\n\t\t\tJButton button = new JButton();\n\t\t\tadd(button, BorderLayout.NORTH);\n\t\t}\n\t\t{\n\t\t\tJPanel inner = new JPanel();\n\t\t\tadd(inner, BorderLayout.CENTER);\n\t\t}\n\t}\n}");
    }
}

