/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.gbl;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.swing.Activator;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.gbl.GridBagLayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.gbl.AbstractGridBagLayoutTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;

public class GridBagLayoutParametersTest
extends AbstractGridBagLayoutTest {
    @Override
    @AfterEach
    public void tearDown() throws Exception {
        IPreferenceStore preferences = Activator.getDefault().getPreferenceStore();
        preferences.setToDefault("GridBagLayout.enableGrab");
        preferences.setToDefault("GridBagLayout.enableRightAlignment");
        super.tearDown();
    }

    @Test
    public void test_CREATE_Text() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JTextField.class);
                layout.command_CREATE(newComponent, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {1.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.HORIZONTAL;\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(textField, gbc);\n\t\t\ttextField.setColumns(10);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_Text_disabled() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t}\n}");
        panel.refresh();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("GridBagLayout.enableGrab", false);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JTextField.class);
                layout.command_CREATE(newComponent, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(textField, gbc);\n\t\t\ttextField.setColumns(10);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_Table() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JTable.class);
                layout.command_CREATE(newComponent, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {1.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {1.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJTable table = new JTable();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.BOTH;\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(table, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_LabelBeforeText() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 1.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.HORIZONTAL;\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(textField, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JLabel.class);
                layout.command_CREATE(newComponent, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 1.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJLabel label = new JLabel(\"New label\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.anchor = GridBagConstraints.EAST;\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(label, gbc);\n\t\t}\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.HORIZONTAL;\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(textField, gbc);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_TextAfterLabel() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 0.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJLabel label = new JLabel(\"New label\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(label, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JTextField.class);
                layout.command_CREATE(newComponent, 1, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 1.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJLabel label = new JLabel(\"New label\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.anchor = GridBagConstraints.EAST;\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(label, gbc);\n\t\t}\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.HORIZONTAL;\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(textField, gbc);\n\t\t\ttextField.setColumns(10);\n\t\t}\n\t}\n}");
    }

    @Test
    public void test_CREATE_LabelBeforeText_disabled() throws Exception {
        final ContainerInfo panel = this.parseContainer("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 1.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.HORIZONTAL;\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(textField, gbc);\n\t\t}\n\t}\n}");
        panel.refresh();
        ToolkitProvider.DESCRIPTION.getPreferences().setValue("GridBagLayout.enableRightAlignment", false);
        ExecutionUtils.run((ObjectInfo)panel, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                GridBagLayoutInfo layout = (GridBagLayoutInfo)panel.getLayout();
                ComponentInfo newComponent = GridBagLayoutParametersTest.createComponent(JLabel.class);
                layout.command_CREATE(newComponent, 0, false, 0, false);
            }
        });
        this.assertEditor("class Test extends JPanel {\n\tpublic Test() {\n\t\tGridBagLayout layout = new GridBagLayout();\n\t\tlayout.columnWidths = new int[] {0, 0, 0};\n\t\tlayout.rowHeights = new int[] {0, 0};\n\t\tlayout.columnWeights = new double[] {0.0, 1.0, Double.MIN_VALUE};\n\t\tlayout.rowWeights = new double[] {0.0, Double.MIN_VALUE};\n\t\tsetLayout(layout);\n\t\t{\n\t\t\tJLabel label = new JLabel(\"New label\");\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.insets = new Insets(0, 0, 0, 5);\n\t\t\tgbc.gridx = 0;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(label, gbc);\n\t\t}\n\t\t{\n\t\t\tJTextField textField = new JTextField();\n\t\t\tGridBagConstraints gbc = new GridBagConstraints();\n\t\t\tgbc.fill = GridBagConstraints.HORIZONTAL;\n\t\t\tgbc.gridx = 1;\n\t\t\tgbc.gridy = 0;\n\t\t\tadd(textField, gbc);\n\t\t}\n\t}\n}");
    }
}

