/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.layout.MigLayout;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.eclipse.jface.action.IAction;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.LayoutInfo;
import org.eclipse.wb.tests.designer.swing.model.layout.MigLayout.AbstractMigLayoutTest;
import org.junit.jupiter.api.Test;

public class MigLayoutSelectionActionsTest
extends AbstractMigLayoutTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_selectionActions_ALL() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(), 'cell 0 0');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(List.of(button), actions);
        MigLayoutSelectionActionsTest.assertEquals((int)15, (int)actions.size());
        MigLayoutSelectionActionsTest.assertNotNull((Object)MigLayoutSelectionActionsTest.findAction(actions, "Default"));
        MigLayoutSelectionActionsTest.assertNotNull((Object)MigLayoutSelectionActionsTest.findAction(actions, "Left"));
        MigLayoutSelectionActionsTest.assertNotNull((Object)MigLayoutSelectionActionsTest.findAction(actions, "Center"));
        MigLayoutSelectionActionsTest.assertNotNull((Object)MigLayoutSelectionActionsTest.findAction(actions, "Right"));
        MigLayoutSelectionActionsTest.assertNotNull((Object)MigLayoutSelectionActionsTest.findAction(actions, "Fill"));
        MigLayoutSelectionActionsTest.assertNotNull((Object)MigLayoutSelectionActionsTest.findAction(actions, "Leading"));
        MigLayoutSelectionActionsTest.assertNotNull((Object)MigLayoutSelectionActionsTest.findAction(actions, "Trailing"));
        MigLayoutSelectionActionsTest.assertNotNull((Object)MigLayoutSelectionActionsTest.findAction(actions, "Top"));
        MigLayoutSelectionActionsTest.assertNotNull((Object)MigLayoutSelectionActionsTest.findAction(actions, "Bottom"));
        MigLayoutSelectionActionsTest.assertNotNull((Object)MigLayoutSelectionActionsTest.findAction(actions, "Baseline"));
    }

    @Test
    public void test_selectionActions_noSelection() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        panel.refresh();
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(Collections.emptyList(), actions);
        Assertions.assertThat(actions).isEmpty();
    }

    @Test
    public void test_selectionActions_invalidSelection() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "  }", "}");
        panel.refresh();
        ArrayList actions = new ArrayList();
        List<LayoutInfo> selectedObjects = List.of(panel.getLayout());
        panel.getBroadcastObject().addSelectionActions(selectedObjects, actions);
        Assertions.assertThat(actions).isEmpty();
    }

    @Test
    public void test_horizontalAlignment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(), 'cell 0 0,alignx leading');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(List.of(button), actions);
        IAction leadingAction = MigLayoutSelectionActionsTest.findAction(actions, "Leading");
        MigLayoutSelectionActionsTest.assertTrue((boolean)leadingAction.isChecked());
        IAction rightAction = MigLayoutSelectionActionsTest.findAction(actions, "Right");
        rightAction.setChecked(true);
        rightAction.run();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(), 'cell 0 0,alignx right');", "  }", "}");
    }

    @Test
    public void test_verticalAlignment() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(), 'cell 0 0,aligny top');", "  }", "}");
        panel.refresh();
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        ArrayList actions = new ArrayList();
        panel.getBroadcastObject().addSelectionActions(List.of(button), actions);
        IAction topAction = MigLayoutSelectionActionsTest.findAction(actions, "Top");
        MigLayoutSelectionActionsTest.assertTrue((boolean)topAction.isChecked());
        IAction bottomAction = MigLayoutSelectionActionsTest.findAction(actions, "Bottom");
        bottomAction.setChecked(true);
        bottomAction.run();
        this.assertEditor("public class Test extends JPanel implements IConstants {", "  public Test() {", "    setLayout(new MigLayout());", "    add(new JButton(), 'cell 0 0,aligny bottom');", "  }", "}");
    }
}

