/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.swing.model.component;

import org.assertj.core.api.Assertions;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.component.JInternalFrameInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class JInternalFrameTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_this() throws Exception {
        JInternalFrameInfo frame = (JInternalFrameInfo)this.parseJavaInfo("// filler filler filler", "public class Test extends JInternalFrame {", "  public Test() {", "  }", "}");
        JInternalFrameTest.assertHierarchy("{this: javax.swing.JInternalFrame} {this} {}", "  {method: public java.awt.Container javax.swing.JInternalFrame.getContentPane()} {property} {}", "    {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
        frame.refresh();
        JInternalFrameTest.assertNoErrors((JavaInfo)frame);
        ComponentInfo contentPane = (ComponentInfo)frame.getChildrenComponents().get(0);
        Rectangle bounds = frame.getBounds();
        JInternalFrameTest.assertEquals((int)bounds.width, (int)450);
        JInternalFrameTest.assertEquals((int)bounds.height, (int)300);
        bounds = contentPane.getBounds();
        Assertions.assertThat((int)bounds.x).isGreaterThanOrEqualTo(0);
        Assertions.assertThat((int)bounds.y).isGreaterThanOrEqualTo(0);
        Assertions.assertThat((int)bounds.width).isGreaterThan(420);
        Assertions.assertThat((int)bounds.height).isGreaterThan(250);
    }

    @Test
    public void test_onJDesktopPane() throws Exception {
        ContainerInfo panel = (ContainerInfo)this.parseJavaInfo("public class Test extends JPanel {", "  public Test() {", "    JDesktopPane desktop = new JDesktopPane();", "    add(desktop);", "    {", "      JInternalFrame frame = new JInternalFrame();", "      desktop.add(frame);", "      frame.setBounds(5, 5, 200, 150);", "    }", "  }", "}");
        JInternalFrameTest.assertHierarchy("{this: javax.swing.JPanel} {this} {/add(desktop)/}", "  {implicit-layout: java.awt.FlowLayout} {implicit-layout} {}", "  {new: javax.swing.JDesktopPane} {local-unique: desktop} {/new JDesktopPane()/ /add(desktop)/ /desktop.add(frame)/}", "    {implicit-layout: absolute} {implicit-layout} {}", "    {new: javax.swing.JInternalFrame} {local-unique: frame} {/new JInternalFrame()/ /desktop.add(frame)/ /frame.setBounds(5, 5, 200, 150)/}", "      {method: public java.awt.Container javax.swing.JInternalFrame.getContentPane()} {property} {}", "        {implicit-layout: java.awt.BorderLayout} {implicit-layout} {}");
        panel.refresh();
        JInternalFrameInfo frame = (JInternalFrameInfo)JInternalFrameTest.getJavaInfoByName("frame");
        JInternalFrameTest.assertEquals((Object)true, (Object)frame.getComponent().isVisible());
    }
}

