/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.widgets;

import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swt.model.widgets.ButtonInfo;
import org.eclipse.wb.internal.swt.model.widgets.CompositeInfo;
import org.eclipse.wb.internal.swt.model.widgets.ControlInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.junit.jupiter.api.Test;

public class AsyncMessagesSupportTest
extends RcpModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_hasAsync_noMessagesRequest() throws Exception {
        this.prepareButtonWithAsync();
        AsyncMessagesSupportTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(450, 300);", "    MyButton button = new MyButton(this, SWT.NONE);", "    button.setValue(5);", "  }", "}");
        shell.refresh();
        ButtonInfo button = (ButtonInfo)shell.getChildrenControls().get(0);
        AsyncMessagesSupportTest.assertEquals((Object)0, (Object)ReflectionUtils.invokeMethod((Object)button.getObject(), (String)"getValue()", (Object[])new Object[0]));
    }

    @Test
    public void test_hasAsync_hasMessagesRequest() throws Exception {
        this.prepareButtonWithAsync();
        AsyncMessagesSupportTest.setFileContentSrc("test/MyButton.wbp-component.xml", AsyncMessagesSupportTest.getSourceDQ("<?xml version='1.0' encoding='UTF-8'?>", "<component xmlns='http://www.eclipse.org/wb/WBPComponent'>", "  <parameters>", "    <parameter name='SWT.runAsyncMessages'>true</parameter>", "  </parameters>", "</component>"));
        AsyncMessagesSupportTest.waitForAutoBuild();
        CompositeInfo shell = this.parseComposite("public class Test extends Shell {", "  public Test() {", "    setSize(450, 300);", "    MyButton button = new MyButton(this, SWT.NONE);", "    button.setValue(5);", "  }", "}");
        shell.refresh();
        ControlInfo button = (ControlInfo)shell.getChildrenControls().get(0);
        AsyncMessagesSupportTest.assertEquals((Object)5, (Object)ReflectionUtils.invokeMethod((Object)button.getObject(), (String)"getValue()", (Object[])new Object[0]));
    }

    private void prepareButtonWithAsync() throws Exception {
        AsyncMessagesSupportTest.setFileContentSrc("test/MyButton.java", this.getTestSource("public class MyButton extends Button {", "  private int m_value;", "  public MyButton(Composite parent, int style) {", "    super(parent, style);", "  }", "  public void setValue(final int value) {", "    getDisplay().asyncExec(new Runnable() {", "      public void run() {", "        m_value = value;", "      }", "    });", "  }", "  public int getValue() {", "    return m_value;", "  }", "  protected void checkSubclass() {", "  }", "}"));
    }
}

