/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.rcp.model.property;

import java.io.File;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.swt.model.widgets.ShellInfo;
import org.eclipse.wb.tests.designer.rcp.RcpModelTest;
import org.eclipse.wb.tests.designer.swt.model.property.PropertyEditorTestUtils;

public abstract class ImagePropertyEditorTest
extends RcpModelTest {
    protected final GenericProperty createImagePropertyForSource(String imageSource) throws Exception {
        this.m_waitForAutoBuild = true;
        ShellInfo shell = (ShellInfo)this.parseComposite("// filler filler filler", "public class Test extends Shell {", "  public Test() {", "    setImage(" + imageSource + ");", "  }", "}");
        shell.refresh();
        ImagePropertyEditorTest.assertNoErrors((JavaInfo)shell);
        Image image = shell.getWidget().getImage();
        ImagePropertyEditorTest.assertNotNull((Object)image);
        return (GenericProperty)shell.getPropertyByTitle("image");
    }

    protected final void assert_getText_getClipboardSource_forSource(String imageSource, String expectedText, String expectedClipboardSource) throws Exception {
        GenericProperty property = this.createImagePropertyForSource(imageSource);
        ImagePropertyEditorTest.assertEquals((Object)expectedText, (Object)PropertyEditorTestUtils.getText((Property)property));
        ImagePropertyEditorTest.assertEquals((Object)expectedClipboardSource, (Object)PropertyEditorTestUtils.getClipboardSource((Property)property));
    }

    protected static File createTempImage() throws Exception {
        File file = File.createTempFile("testcase", ".png");
        Image image = new Image(null, 1, 1);
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save(file.getAbsolutePath(), 5);
        image.dispose();
        return file;
    }
}

