/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.editor;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.ui.ide.IDE;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.tests.designer.core.AbstractJavaTest;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ContentDescriberTest
extends AbstractJavaTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        DesignerPlugin.getPreferences().setValue("editor.recognizeSourceGUI", true);
        if (m_testProject == null) {
            ContentDescriberTest.do_projectCreate();
        }
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        DesignerPlugin.getPreferences().setToDefault("editor.recognizeSourceGUI");
        super.tearDown();
        ContentDescriberTest.do_projectDispose();
    }

    @Test
    public void test_notGUI() throws Exception {
        IFile file = ContentDescriberTest.setFileContentSrc("test/Test.java", ContentDescriberTest.getSourceDQ("package test;", "public class Test {", "  // filler", "}"));
        this.waitForContentType();
        ContentDescriberTest.assertFalse((boolean)ContentDescriberTest.isDesignerType(file));
    }

    @Test
    public void test_disableRecognition() throws Exception {
        DesignerPlugin.getPreferences().setValue("editor.recognizeSourceGUI", false);
        IFile file = ContentDescriberTest.setFileContentSrc("test/Test.java", ContentDescriberTest.getSourceDQ("package test;", "import javax.swing.*;", "public class Test extends JPanel {", "  // filler", "}"));
        this.waitForContentType();
        ContentDescriberTest.assertFalse((boolean)ContentDescriberTest.isDesignerType(file));
    }

    @Test
    public void test_useExcludePattern() throws Exception {
        TestBundle testBundle = new TestBundle();
        try {
            testBundle.addExtension("org.eclipse.wb.core.designerContentPatterns", "<excludePattern>use this string to exclude</excludePattern>");
            testBundle.install();
            IFile file = ContentDescriberTest.setFileContentSrc("test/Test.java", ContentDescriberTest.getSourceDQ("package test;", "import javax.swing.*;", "public class Test extends JPanel {", "  // use this string to exclude", "}"));
            this.waitForContentType();
            ContentDescriberTest.assertFalse((boolean)ContentDescriberTest.isDesignerType(file));
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_AWT_Applet() throws Exception {
        IFile file = ContentDescriberTest.setFileContentSrc("test/Test.java", ContentDescriberTest.getSourceDQ("package test;", "import java.applet.Applet;", "public class Test extends Applet {", "  // filler", "}"));
        this.waitForContentType();
        ContentDescriberTest.assertTrue((boolean)ContentDescriberTest.isDesignerType(file));
    }

    @Test
    public void test_Swing() throws Exception {
        IFile file = ContentDescriberTest.setFileContentSrc("test/Test.java", ContentDescriberTest.getSourceDQ("package test;", "import javax.swing.*;", "public class Test extends JPanel {", "  // filler", "}"));
        this.waitForContentType();
        ContentDescriberTest.assertTrue((boolean)ContentDescriberTest.isDesignerType(file));
    }

    @Test
    public void test_SWT() throws Exception {
        IFile file = ContentDescriberTest.setFileContentSrc("test/Test.java", ContentDescriberTest.getSourceDQ("package test;", "public class Test {", "  // org.eclipse.swt.widgets.Button", "}"));
        this.waitForContentType();
        ContentDescriberTest.assertTrue((boolean)ContentDescriberTest.isDesignerType(file));
    }

    @Test
    public void test_RCP_ActionBarAdvisor() throws Exception {
        IFile file = ContentDescriberTest.setFileContentSrc("test/Test.java", ContentDescriberTest.getSourceDQ("package test;", "public class Test {", "  // org.eclipse.ui.application.ActionBarAdvisor", "}"));
        this.waitForContentType();
        ContentDescriberTest.assertTrue((boolean)ContentDescriberTest.isDesignerType(file));
    }

    @Test
    public void test_RCP_IPerspectiveFactory() throws Exception {
        IFile file = ContentDescriberTest.setFileContentSrc("test/Test.java", ContentDescriberTest.getSourceDQ("package test;", "public class Test {", "  // org.eclipse.ui.IPerspectiveFactory", "}"));
        this.waitForContentType();
        ContentDescriberTest.assertTrue((boolean)ContentDescriberTest.isDesignerType(file));
    }

    private static boolean isDesignerType(IFile file) {
        IContentType contentType = IDE.getContentType((IFile)file);
        return "org.eclipse.wb.core.java.javaSourceGUI".equals(contentType.getId());
    }

    private void waitForContentType() throws Exception {
        ContentDescriberTest.waitEventLoop(1);
        ContentDescriberTest.waitForAutoBuild();
    }
}

