/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.variable.ThisVariableSupport;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.internal.swing.model.layout.FlowLayoutInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.junit.jupiter.api.Test;

public class ThisTest
extends AbstractVariableTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_support() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    //", "  }", "}");
        ThisTest.assertEquals((int)1, (int)panel.getChildrenJava().size());
        ThisTest.assertTrue((boolean)(panel.getChildrenJava().get(0) instanceof FlowLayoutInfo));
        ThisVariableSupport variableSupport = (ThisVariableSupport)panel.getVariableSupport();
        ThisTest.assertNotNull((Object)variableSupport);
        ThisTest.assertEquals((Object)"this", (Object)variableSupport.toString());
        ThisTest.assertEquals((Object)"(javax.swing.JPanel)", (Object)variableSupport.getTitle());
        TypeDeclaration typeDeclaration = JavaInfoUtils.getTypeDeclaration((JavaInfo)panel);
        MethodDeclaration constructor = AstNodeUtils.getMethodBySignature((TypeDeclaration)typeDeclaration, (String)"<init>()");
        ThisTest.assertSame((Object)constructor, (Object)variableSupport.getConstructor());
        ThisTest.assertEquals((Object)false, (Object)variableSupport.hasName());
        try {
            variableSupport.getName();
            ThisTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.setName("foo");
            ThisTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ThisTest.assertEquals((Object)"this", (Object)variableSupport.getComponentName());
        ThisTest.assertFalse((boolean)panel.getCreationSupport().canReorder());
        ThisTest.assertFalse((boolean)panel.getCreationSupport().canReparent());
        ThisTest.assertTrue((boolean)variableSupport.isValidStatementForChild(null));
        ThisTest.assertTrue((boolean)variableSupport.hasExpression(null));
        ThisTest.assertEquals((Object)"this", (Object)variableSupport.getReferenceExpression(null));
        ThisTest.assertEquals((Object)"", (Object)variableSupport.getAccessExpression(null));
        ThisTest.assertFalse((boolean)variableSupport.canConvertLocalToField());
        ThisTest.assertFalse((boolean)variableSupport.canConvertFieldToLocal());
        try {
            variableSupport.convertLocalToField();
            ThisTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            variableSupport.convertFieldToLocal();
            ThisTest.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void test_target_1() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    //", "  }", "}");
        TypeDeclaration typeDeclaration = AstNodeUtils.getTypeByName((CompilationUnit)this.m_lastEditor.getAstUnit(), (String)"Test");
        ThisTest.assertStatementTarget((JavaInfo)panel, typeDeclaration.getMethods()[0].getBody(), null, true);
    }

    @Test
    public void test_target_2() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    setVisible(true);", "  }", "}");
        TypeDeclaration typeDeclaration = AstNodeUtils.getTypeByName((CompilationUnit)this.m_lastEditor.getAstUnit(), (String)"Test");
        ThisTest.assertStatementTarget((JavaInfo)panel, typeDeclaration.getMethods()[0].getBody(), null, true);
    }

    @Test
    public void test_target_3() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    super();", "  }", "}");
        TypeDeclaration typeDeclaration = AstNodeUtils.getTypeByName((CompilationUnit)this.m_lastEditor.getAstUnit(), (String)"Test");
        MethodDeclaration constructor = typeDeclaration.getMethods()[0];
        ThisTest.assertStatementTarget((JavaInfo)panel, null, (Statement)constructor.getBody().statements().get(0), false);
    }
}

