/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.variables;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.function.FailableConsumer;
import org.apache.commons.lang3.function.FailableRunnable;
import org.eclipse.swtbot.swt.finder.SWTBot;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.variable.AbstractNamedVariableSupport;
import org.eclipse.wb.internal.core.model.variable.AbstractSimpleVariableSupport;
import org.eclipse.wb.internal.core.model.variable.LocalUniqueVariableSupport;
import org.eclipse.wb.internal.core.model.variable.VariableProperty;
import org.eclipse.wb.internal.core.model.variable.VariableSupport;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.core.model.variables.AbstractVariableTest;
import org.eclipse.wb.tests.gef.UiContext;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class AbstractNamedTest
extends AbstractVariableTest {
    private static final Set<AbstractNamedVariableSupport> NO_VARIABLES = new HashSet<AbstractNamedVariableSupport>();

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_accessName() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        VariableSupport variableSupport = button.getVariableSupport();
        AbstractNamedTest.assertTrue((boolean)variableSupport.hasName());
        AbstractNamedTest.assertEquals((Object)"button", (Object)variableSupport.getName());
        AbstractNamedTest.assertEquals((Object)"button", (Object)variableSupport.getTitle());
        AbstractNamedTest.assertEquals((Object)"button", (Object)variableSupport.getComponentName());
    }

    @Test
    public void test_getName_whenNoVariable() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "class Test extends JPanel {", "  Test() {", "  }", "}");
        LocalUniqueVariableSupport variable = new LocalUniqueVariableSupport((JavaInfo)panel);
        AbstractNamedTest.assertFalse((boolean)variable.hasName());
        AbstractNamedTest.assertEquals((Object)"no-variable-yet", (Object)variable.getName());
    }

    @Test
    public void test_getAccessExpression() throws Exception {
        AbstractNamedVariableSupport variable = (AbstractNamedVariableSupport)Mockito.mock(AbstractNamedVariableSupport.class);
        NodeTarget target = null;
        Mockito.when((Object)variable.getAccessExpression(target)).thenCallRealMethod();
        Mockito.when((Object)variable.getReferenceExpression(target)).thenReturn((Object)"button");
        AbstractNamedTest.assertEquals((Object)"button.", (Object)variable.getAccessExpression(target));
        ((AbstractNamedVariableSupport)Mockito.verify((Object)variable)).getAccessExpression(target);
        ((AbstractNamedVariableSupport)Mockito.verify((Object)variable)).getReferenceExpression(target);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{variable});
    }

    @Test
    public void test_setNameBase_sameName() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbstractNamedVariableSupport variable = (AbstractNamedVariableSupport)button.getVariableSupport();
        variable.setNameBase("button");
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
    }

    @Test
    public void test_setNameBase_shadowConflict() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "    //", "    int button2;", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbstractNamedVariableSupport variable = (AbstractNamedVariableSupport)button.getVariableSupport();
        variable.setNameBase("button2");
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JButton button2_1 = new JButton();", "    add(button2_1);", "    //", "    int button2;", "  }", "}");
    }

    @Test
    public void test_variableProperty() throws Exception {
        ContainerInfo panel = this.parseContainer("class Test extends JPanel {", "  Test() {", "    JButton button = new JButton();", "    add(button);", "    //", "    JButton button_2 = new JButton();", "    add(button_2);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        final VariableProperty variableProperty = (VariableProperty)button.getPropertyByTitle("Variable");
        AbstractNamedTest.assertTrue((boolean)variableProperty.isModified());
        AbstractNamedTest.assertTrue((boolean)variableProperty.getCategory().isSystem());
        AbstractNamedTest.assertEquals((Object)"button", (Object)variableProperty.getValue());
        variableProperty.setValue((Object)this);
        variableProperty.setValue((Object)"abc");
        this.assertEditor("class Test extends JPanel {", "  Test() {", "    JButton abc = new JButton();", "    add(abc);", "    //", "    JButton button_2 = new JButton();", "    add(button_2);", "  }", "}");
        AbstractNamedTest.assertEquals((Object)"abc", (Object)AbstractNamedTest.getPropertyText((Property)variableProperty));
        AbstractNamedTest.assertEquals((Object)"abc", (Object)AbstractNamedTest.getTextEditorText((Property)variableProperty));
        new UiContext().executeAndCheck(new FailableRunnable<Exception>(){

            public void run() throws Exception {
                AbstractNamedTest.setTextEditorText((Property)variableProperty, "button_2");
            }
        }, new FailableConsumer<SWTBot, Exception>(){

            public void accept(SWTBot bot) {
                SWTBot shell = bot.shell("Variable").bot();
                shell.button("OK").click();
            }
        });
        AbstractNamedTest.assertEquals((Object)"abc", (Object)AbstractNamedTest.getPropertyText((Property)variableProperty));
        AbstractNamedTest.assertEquals((Object)"abc", (Object)AbstractNamedTest.getTextEditorText((Property)variableProperty));
        AbstractNamedTest.setTextEditorText((Property)variableProperty, "button_1");
        AbstractNamedTest.assertEquals((Object)"button_1", (Object)button.getVariableSupport().getName());
    }

    private static String validateVariables(Map<AbstractNamedVariableSupport, String> variablesNames) {
        return AbstractNamedTest.validateVariables(variablesNames, NO_VARIABLES, NO_VARIABLES);
    }

    private static void validateVariables(boolean valid, Map<AbstractNamedVariableSupport, String> variablesNames) {
        String message = AbstractNamedTest.validateVariables(variablesNames);
        if (valid) {
            AbstractNamedTest.assertNull((Object)message, (String)message);
        } else {
            AbstractNamedTest.assertNotNull((Object)message);
        }
    }

    private static String validateVariables(Map<AbstractNamedVariableSupport, String> variablesNames, Set<AbstractNamedVariableSupport> toLocalVariables, Set<AbstractNamedVariableSupport> toFieldVariables) {
        return AbstractNamedVariableSupport.validateVariables(variablesNames, toLocalVariables, toFieldVariables);
    }

    @Test
    public void test_validateVariables_singleVariable() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private int m_field;", "  public Test() {", "    JButton button = new JButton();", "    add(button);", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        Map<AbstractNamedVariableSupport, String> variablesNames = Map.of((AbstractNamedVariableSupport)button.getVariableSupport(), "in-valid");
        AbstractNamedTest.assertTrue((boolean)AbstractNamedTest.validateVariables(variablesNames).contains("identifier"));
        variablesNames = Map.of((AbstractNamedVariableSupport)button.getVariableSupport(), "myButton");
        AbstractNamedTest.validateVariables(true, variablesNames);
    }

    @Test
    public void test_validateVariables_twoVariables_plain() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  private int m_field;", "  public Test() {", "    JButton button1 = new JButton();", "    add(button1);", "    //", "    JButton button2 = new JButton();", "    add(button2);", "  }", "}");
        ComponentInfo button1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        AbstractNamedVariableSupport variable1 = (AbstractNamedVariableSupport)button1.getVariableSupport();
        AbstractNamedVariableSupport variable2 = (AbstractNamedVariableSupport)button2.getVariableSupport();
        Map<AbstractNamedVariableSupport, String> variablesNames = Collections.emptyMap();
        AbstractNamedTest.validateVariables(true, variablesNames);
        AbstractNamedTest.validateVariables(false, Map.of(variable2, "button1"));
        variablesNames = Map.of(variable2, "button1", variable1, "button_1");
        AbstractNamedTest.validateVariables(true, variablesNames);
        variablesNames = Map.of(variable2, "button1", variable1, "button2");
        AbstractNamedTest.validateVariables(true, variablesNames);
        variablesNames = Map.of(variable1, "button2");
        AbstractNamedTest.validateVariables(false, variablesNames);
        variablesNames = Map.of(variable1, "button2", variable2, "button_2");
        AbstractNamedTest.validateVariables(true, variablesNames);
    }

    @Test
    public void test_validateName_local() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  JButton m_field;", "  public Test() {", "    JButton button1 = new JButton();", "    add(button1);", "    //", "    {", "      JButton button2 = new JButton();", "    }", "    //", "    JButton button3 = new JButton();", "    add(button3);", "    //", "    {", "      JButton button4 = new JButton();", "    }", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        ComponentInfo button_2 = (ComponentInfo)panel.getChildrenComponents().get(1);
        AbstractSimpleVariableSupport variable_1 = (AbstractSimpleVariableSupport)button_1.getVariableSupport();
        AbstractSimpleVariableSupport variable_2 = (AbstractSimpleVariableSupport)button_2.getVariableSupport();
        String errorMessage = variable_2.validateName("@#$%");
        AbstractNamedTest.assertNotNull((Object)errorMessage);
        errorMessage = variable_2.validateName("while");
        AbstractNamedTest.assertNotNull((Object)errorMessage);
        errorMessage = variable_2.validateName("button1");
        AbstractNamedTest.assertNotNull((Object)errorMessage);
        errorMessage = variable_2.validateName("m_field");
        AbstractNamedTest.assertNotNull((Object)errorMessage);
        errorMessage = variable_2.validateName("buttonA");
        AbstractNamedTest.assertNull((Object)errorMessage);
        errorMessage = variable_2.validateName("button2");
        AbstractNamedTest.assertNull((Object)errorMessage);
        errorMessage = variable_1.validateName("button3");
        AbstractNamedTest.assertNotNull((Object)errorMessage);
        errorMessage = variable_1.validateName("button4");
        AbstractNamedTest.assertNotNull((Object)errorMessage);
    }

    @Test
    public void test_validateName_field() throws Exception {
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  JButton button1 = new JButton();", "  JButton m_field;", "  public Test() {", "    add(button1);", "    //", "    JButton button2 = new JButton();", "    add(button2);", "  }", "}");
        ComponentInfo button_1 = (ComponentInfo)panel.getChildrenComponents().get(0);
        AbstractSimpleVariableSupport variable_1 = (AbstractSimpleVariableSupport)button_1.getVariableSupport();
        String errorMessage = variable_1.validateName("m_field");
        AbstractNamedTest.assertNotNull((Object)errorMessage);
        errorMessage = variable_1.validateName("button2");
        AbstractNamedTest.assertNotNull((Object)errorMessage);
    }
}

