/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.util;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.model.util.factory.FactoryActionsSupport;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.swing.model.component.ComponentInfo;
import org.eclipse.wb.internal.swing.model.component.ContainerInfo;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class FactoryActionsSupportTest
extends SwingModelTest {
    @Test
    public void test_previousTypeNames() throws Exception {
        ContainerInfo panel = this.parseContainer("// filler filler filler", "public class Test extends JPanel {", "  public Test() {", "  }", "}");
        FactoryActionsSupportTest.clearPreviousTypeNames((JavaInfo)panel);
        FactoryActionsSupportTest.assertTrue((boolean)Arrays.equals(new String[0], FactoryActionsSupportTest.getPreviousTypeNames((JavaInfo)panel)));
        FactoryActionsSupportTest.addPreviousTypeName((JavaInfo)panel, "a");
        FactoryActionsSupportTest.assertTrue((boolean)Arrays.equals(new String[]{"a"}, FactoryActionsSupportTest.getPreviousTypeNames((JavaInfo)panel)));
        FactoryActionsSupportTest.addPreviousTypeName((JavaInfo)panel, "b");
        FactoryActionsSupportTest.assertTrue((boolean)Arrays.equals(new String[]{"b", "a"}, FactoryActionsSupportTest.getPreviousTypeNames((JavaInfo)panel)));
        FactoryActionsSupportTest.addPreviousTypeName((JavaInfo)panel, "c");
        FactoryActionsSupportTest.assertTrue((boolean)Arrays.equals(new String[]{"c", "b", "a"}, FactoryActionsSupportTest.getPreviousTypeNames((JavaInfo)panel)));
        FactoryActionsSupportTest.addPreviousTypeName((JavaInfo)panel, "b");
        FactoryActionsSupportTest.assertTrue((boolean)Arrays.equals(new String[]{"b", "c", "a"}, FactoryActionsSupportTest.getPreviousTypeNames((JavaInfo)panel)));
        FactoryActionsSupportTest.addPreviousTypeName((JavaInfo)panel, "1");
        FactoryActionsSupportTest.assertTrue((boolean)Arrays.equals(new String[]{"1", "b", "c", "a"}, FactoryActionsSupportTest.getPreviousTypeNames((JavaInfo)panel)));
        FactoryActionsSupportTest.addPreviousTypeName((JavaInfo)panel, "2");
        FactoryActionsSupportTest.assertTrue((boolean)Arrays.equals(new String[]{"2", "1", "b", "c", "a"}, FactoryActionsSupportTest.getPreviousTypeNames((JavaInfo)panel)));
        FactoryActionsSupportTest.addPreviousTypeName((JavaInfo)panel, "3");
        FactoryActionsSupportTest.assertTrue((boolean)Arrays.equals(new String[]{"3", "2", "1", "b", "c"}, FactoryActionsSupportTest.getPreviousTypeNames((JavaInfo)panel)));
        FactoryActionsSupportTest.clearPreviousTypeNames((JavaInfo)panel);
    }

    private static void clearPreviousTypeNames(JavaInfo component) throws Exception {
        ReflectionUtils.invokeMethod2(FactoryActionsSupport.class, (String)"clearPreviousTypeNames", JavaInfo.class, (Object)component);
    }

    private static String[] getPreviousTypeNames(JavaInfo component) throws Exception {
        return (String[])ReflectionUtils.invokeMethod2(FactoryActionsSupport.class, (String)"getPreviousTypeNames", JavaInfo.class, (Object)component);
    }

    private static void addPreviousTypeName(JavaInfo component, String typeName) throws Exception {
        ReflectionUtils.invokeMethod2(FactoryActionsSupport.class, (String)"addPreviousTypeName", JavaInfo.class, String.class, (Object)component, (Object)typeName);
    }

    @Test
    public void test_actions_thisPackage() throws Exception {
        FactoryActionsSupportTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton create_1(String text) {", "    return new JButton(text);", "  }", "  public static JButton create_2(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryActionsSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryActionsSupportTest.assertNull((Object)this.getFactoryManager((ComponentInfo)panel));
        IMenuManager factoryManager = this.getFactoryManager(button);
        FactoryActionsSupportTest.assertNotNull((Object)factoryManager);
        FactoryActionsSupportTest.assertNotNull((Object)FactoryActionsSupportTest.findChildAction((IContributionManager)factoryManager, "Create factory..."));
        IAction action = FactoryActionsSupportTest.findChildAction((IContributionManager)factoryManager, "StaticFactory.create_1(...)");
        FactoryActionsSupportTest.assertNotNull((Object)action);
        FactoryActionsSupportTest.assertNotNull((Object)action.getImageDescriptor());
        action = FactoryActionsSupportTest.findChildAction((IContributionManager)factoryManager, "StaticFactory.create_2(...)");
        FactoryActionsSupportTest.assertNotNull((Object)action);
        FactoryActionsSupportTest.assertNotNull((Object)action.getImageDescriptor());
    }

    @Test
    public void test_actions_fromHistory() throws Exception {
        FactoryActionsSupportTest.setFileContentSrc("test2/SecondStaticFactory.java", FactoryActionsSupportTest.getSourceDQ("package test2;", "import javax.swing.*;", "public final class SecondStaticFactory {", "  public static JButton create_3(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryActionsSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        FactoryActionsSupportTest.clearPreviousTypeNames((JavaInfo)button);
        IMenuManager factoryManager = this.getFactoryManager(button);
        FactoryActionsSupportTest.assertNotNull((Object)factoryManager);
        FactoryActionsSupportTest.assertNotNull((Object)FactoryActionsSupportTest.findChildAction((IContributionManager)factoryManager, "Select factory..."));
        FactoryActionsSupportTest.assertNull((Object)FactoryActionsSupportTest.findChildAction((IContributionManager)factoryManager, "SecondStaticFactory.create_3(...)"));
        try {
            FactoryActionsSupportTest.addPreviousTypeName((JavaInfo)button, "test2.SecondStaticFactory");
            factoryManager = this.getFactoryManager(button);
            FactoryActionsSupportTest.assertNotNull((Object)factoryManager);
            FactoryActionsSupportTest.assertNotNull((Object)FactoryActionsSupportTest.findChildAction((IContributionManager)factoryManager, "Select factory..."));
            FactoryActionsSupportTest.assertNotNull((Object)FactoryActionsSupportTest.findChildAction((IContributionManager)factoryManager, "SecondStaticFactory.create_3(...)"));
        }
        finally {
            FactoryActionsSupportTest.clearPreviousTypeNames((JavaInfo)button);
        }
    }

    @Test
    public void test_actions_onlyCompatibleTypes() throws Exception {
        FactoryActionsSupportTest.setFileContentSrc("test/StaticFactory.java", this.getTestSource("public final class StaticFactory {", "  public static JButton createButton(String text) {", "    return new JButton(text);", "  }", "  public static JComponent createComponent(String text) {", "    return new JButton(text);", "  }", "}"));
        FactoryActionsSupportTest.waitForAutoBuild();
        ContainerInfo panel = this.parseContainer("public class Test extends JPanel {", "  public Test() {", "    add(new JButton());", "  }", "}");
        ComponentInfo button = (ComponentInfo)panel.getChildrenComponents().get(0);
        IMenuManager factoryManager = this.getFactoryManager(button);
        FactoryActionsSupportTest.assertNotNull((Object)factoryManager);
        FactoryActionsSupportTest.assertNotNull((Object)FactoryActionsSupportTest.findChildAction((IContributionManager)factoryManager, "Create factory..."));
        FactoryActionsSupportTest.assertNotNull((Object)FactoryActionsSupportTest.findChildAction((IContributionManager)factoryManager, "StaticFactory.createButton(...)"));
        FactoryActionsSupportTest.assertNull((Object)FactoryActionsSupportTest.findChildAction((IContributionManager)factoryManager, "StaticFactory.createComponent(...)"));
    }

    private IMenuManager getFactoryManager(ComponentInfo component) throws Exception {
        MenuManager menuManager = FactoryActionsSupportTest.getDesignerMenuManager();
        component.getBroadcastObject().addContextMenu(List.of(component), (ObjectInfo)component, (IMenuManager)menuManager);
        return FactoryActionsSupportTest.findChildMenuManager((IContributionManager)menuManager, "Factory");
    }
}

