/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.model.description;

import java.util.List;
import org.eclipse.wb.internal.core.model.description.LayoutDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescription;
import org.eclipse.wb.internal.core.model.description.ToolkitDescriptionJava;
import org.eclipse.wb.internal.core.model.description.helpers.LayoutDescriptionHelper;
import org.eclipse.wb.internal.swing.ToolkitProvider;
import org.eclipse.wb.tests.designer.swing.SwingModelTest;
import org.junit.jupiter.api.Test;

public class LayoutDescriptionTest
extends SwingModelTest {
    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_get_Swing() throws Exception {
        ToolkitDescriptionJava toolkit = ToolkitProvider.DESCRIPTION;
        List layouts = LayoutDescriptionHelper.get((ToolkitDescription)toolkit);
        LayoutDescription layout = LayoutDescriptionTest.getLayoutById(layouts, "flowLayout");
        LayoutDescriptionTest.assertSame((Object)toolkit, (Object)layout.getToolkit());
        LayoutDescriptionTest.assertEquals((Object)"flowLayout", (Object)layout.getId());
        LayoutDescriptionTest.assertEquals((Object)"FlowLayout", (Object)layout.getName());
        LayoutDescriptionTest.assertEquals((Object)"java.awt.FlowLayout", (Object)layout.getLayoutClassName());
        LayoutDescriptionTest.assertEquals((Object)"new FlowLayout()", (Object)layout.getSourceSmart());
        LayoutDescriptionTest.assertNotNull((Object)LayoutDescriptionTest.getLayoutById(layouts, "flowLayout"));
        LayoutDescriptionTest.assertNotNull((Object)LayoutDescriptionTest.getLayoutById(layouts, "borderLayout"));
        LayoutDescriptionTest.assertNotNull((Object)LayoutDescriptionTest.getLayoutById(layouts, "gridLayout"));
        LayoutDescriptionTest.assertNotNull((Object)LayoutDescriptionTest.getLayoutById(layouts, "cardLayout"));
        LayoutDescriptionTest.assertNotNull((Object)LayoutDescriptionTest.getLayoutById(layouts, "gridBagLayout"));
        LayoutDescriptionTest.assertNull((Object)LayoutDescriptionTest.getLayoutById(layouts, "rowLayout"));
        LayoutDescriptionTest.assertNotNull((Object)LayoutDescriptionHelper.get((ToolkitDescription)toolkit, (String)"flowLayout"));
        LayoutDescriptionTest.assertNull((Object)LayoutDescriptionHelper.get((ToolkitDescription)toolkit, (String)"rowLayout"));
    }

    private static LayoutDescription getLayoutById(List<LayoutDescription> layouts, String id) {
        for (LayoutDescription layout : layouts) {
            if (!layout.getId().equals(id)) continue;
            return layout;
        }
        return null;
    }
}

