/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval.other;

import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class StringTest
extends AbstractEngineTest {
    @BeforeAll
    public static void setUpClass() throws Exception {
        StringTest.do_projectCreate();
    }

    @Test
    public void test_string_literal() throws Exception {
        this.check_String("string", "\"string\"");
    }

    @Test
    public void test_string_literal_quoted() throws Exception {
        this.check_String("a\"b\"", "\"a\\\"b\\\"\"");
    }

    @Test
    public void test_string_plus() throws Exception {
        this.check_String("ab", "\"a\" + \"b\"");
    }

    @Test
    public void test_string_plus3() throws Exception {
        this.check_String("abc", "\"a\" + \"b\" + \"c\"");
    }

    @Test
    public void test_string_plus4() throws Exception {
        this.check_String("abcd", "\"a\" + \"b\" + \"c\" + \"d\"");
    }

    @Test
    public void test_String_plus_int() throws Exception {
        this.check_String("a2", "\"a\" + 2");
    }

    @Test
    public void test_String_plus_null() throws Exception {
        this.check_String("anull", "\"a\" + null");
    }

    private void check_String(String expected, String expression) throws Exception {
        StringTest.assertEquals((Object)expected, (Object)this.evaluateExpression(expression, "java.lang.String"));
    }
}

