/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core.eval;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.assertj.core.api.Assertions;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.wb.core.eval.AstEvaluationEngine;
import org.eclipse.wb.core.eval.EvaluationContext;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.eval.InvocationEvaluatorInterceptor;
import org.eclipse.wb.internal.core.eval.evaluators.AnonymousEvaluationError;
import org.eclipse.wb.internal.core.utils.ast.AstNodeUtils;
import org.eclipse.wb.internal.core.utils.exception.DesignerException;
import org.eclipse.wb.internal.core.utils.exception.DesignerExceptionUtils;
import org.eclipse.wb.internal.core.utils.jdt.core.CodeUtils;
import org.eclipse.wb.internal.core.utils.reflect.ProjectClassLoader;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.tests.designer.core.TestBundle;
import org.eclipse.wb.tests.designer.core.eval.AbstractEngineTest;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MethodInvocationTest
extends AbstractEngineTest {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        if (m_testProject == null) {
            MethodInvocationTest.do_projectCreate();
        }
    }

    public void _test_exit() throws Exception {
        System.exit(0);
    }

    @Test
    public void test_System_currentTimeMillis() throws Exception {
        Object actual = this.evaluateExpression("System.currentTimeMillis()", "long");
        MethodInvocationTest.assertTrue((boolean)(actual instanceof Long));
    }

    @Test
    public void test_staticPublicMethod() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic int call_staticPublicMethod() {\n\t\treturn staticPublicMethod(5);\n\t}\n\tpublic static int staticPublicMethod(int i) {\n\t\treturn 2 * i;\n\t}\n}");
        MethodInvocationTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "call_staticPublicMethod()");
        MethodInvocationTest.assertEquals((Object)10, (Object)actual);
    }

    @Test
    public void test_instancePublicMethod_bad() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic int root() {\n\t\treturn instancePublicMethod(5);\n\t}\n\tpublic int instancePublicMethod(int i) {\n\t\treturn 2 * i;\n\t}\n}");
        MethodInvocationTest.waitForAutoBuild();
        try {
            this.evaluateSingleMethod(typeDeclaration, "root()");
            MethodInvocationTest.fail();
        }
        catch (Throwable e_) {
            DesignerException e = DesignerExceptionUtils.getDesignerException((Throwable)e_);
            MethodInvocationTest.assertEquals((int)306, (int)e.getCode());
        }
    }

    @Test
    public void test_instancePublicMethod_simpleReturn() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic int root() {\n\t\treturn instancePublicMethod();\n\t}\n\tpublic int instancePublicMethod() {\n\t\treturn 5;\n\t}\n}");
        MethodInvocationTest.waitForAutoBuild();
        MethodInvocationTest.assertEquals((Object)5, (Object)this.evaluateSingleMethod(typeDeclaration, "root()"));
    }

    @Test
    public void test_instancePublicMethod_simpleReturn_fail() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic int root() {\n\t\treturn instancePublicMethod();\n\t}\n\tpublic int instancePublicMethod() {\n\t\treturn 5 / 0;\n\t}\n}");
        MethodInvocationTest.waitForAutoBuild();
        try {
            this.evaluateSingleMethod(typeDeclaration, "root()");
            MethodInvocationTest.fail();
        }
        catch (Throwable e) {
            Throwable rootCause = DesignerExceptionUtils.getRootCause((Throwable)e);
            Assertions.assertThat((Throwable)rootCause).isExactlyInstanceOf(ArithmeticException.class);
            DesignerException de = DesignerExceptionUtils.getDesignerException((Throwable)e);
            MethodInvocationTest.assertEquals((int)306, (int)de.getCode());
        }
    }

    @Test
    public void test_instancePublicMethod_withReturnTag() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic int root() {\n\t\treturn instancePublicMethod(5);\n\t}\n\t/**\n\t * @wbp.eval.method.return value\n\t */\n\tpublic int instancePublicMethod(int value) {\n\t\treturn 2 * value;\n\t}\n}");
        MethodInvocationTest.waitForAutoBuild();
        MethodInvocationTest.assertEquals((Object)5, (Object)this.evaluateSingleMethod(typeDeclaration, "root()"));
    }

    @Test
    public void test_instancePublicMethod_withReturnTag2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic int root() {\n\t\treturn instancePublicMethod(5);\n\t}\n\t/**\n\t * Some description.\n\t * @wbp.eval.method.return value\n\t */\n\tpublic int instancePublicMethod(int value) {\n\t\treturn 2 * value;\n\t}\n}");
        MethodInvocationTest.waitForAutoBuild();
        MethodInvocationTest.assertEquals((Object)5, (Object)this.evaluateSingleMethod(typeDeclaration, "root()"));
    }

    @Test
    public void test_staticPublicMethod_inner() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic int call_innerMethod() {\n\t\treturn Foo.innerMethod(5);\n\t}\n\tpublic static class Foo {\n\t\tpublic static int innerMethod(int i) {\n\t\t\treturn 3 * i;\n\t\t}\n\t}\n}");
        MethodInvocationTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "call_innerMethod()");
        MethodInvocationTest.assertEquals((Object)15, (Object)actual);
    }

    @Test
    public void test_publicMethod_1() throws Exception {
        MethodInvocationTest.assertTrue((boolean)(this.evaluateExpression("Runtime.getRuntime().totalMemory()", "long") instanceof Long));
    }

    @Test
    public void test_staticImportMethod() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("import static java.lang.System.currentTimeMillis;\nclass Test {\n\tpublic long callMe() {\n\t\treturn currentTimeMillis();\n\t}\n}");
        long actual = (Long)this.evaluateSingleMethod(typeDeclaration, "callMe()");
        Assertions.assertThat((long)actual).isGreaterThan(1200000000000L);
    }

    @Test
    public void test_methodInvocation_invalidArguments() throws Exception {
        try {
            this.m_ignoreModelCompileProblems = true;
            this.evaluateExpression("Runtime.getRuntime().totalMemory(123)", "long");
            MethodInvocationTest.fail();
        }
        catch (Throwable e_) {
            DesignerException e = DesignerExceptionUtils.getDesignerException((Throwable)e_);
            MethodInvocationTest.assertEquals((int)308, (int)e.getCode());
        }
    }

    @Test
    public void test_methodInvocation_nullExpression() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic int root() {\n\t\tObject obj = null;\n\t\treturn obj.hashCode();\n\t}\n}");
        try {
            this.evaluateSingleMethod(typeDeclaration, "root()");
            MethodInvocationTest.fail();
        }
        catch (Throwable e_) {
            DesignerException e = DesignerExceptionUtils.getDesignerException((Throwable)e_);
            MethodInvocationTest.assertEquals((int)312, (int)e.getCode());
        }
    }

    @Test
    public void test_methodInvocation_generic() throws Exception {
        Object actual = this.evaluateExpression("java.util.Arrays.asList(\"a\", \"b\", \"c\")", "java.util.List");
        MethodInvocationTest.assertEquals((Object)"[a, b, c]", (Object)actual.toString());
    }

    @Test
    public void test_staticPublicMethod_varArgsObject() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", MethodInvocationTest.getSource(MethodInvocationTest.getDoubleQuotes(new String[]{"package test;", "class Test {", "  public static String getValue(int value, Object... parameters) {", "    String result = '';", "    for (Object p : parameters) {", "      result += p;", "    }", "    return result;", "  }", "  public String callMe() {", "    return getValue(5, 'p1', 'p2', 'p3');", "  }", "}"})));
        MethodInvocationTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "callMe()");
        MethodInvocationTest.assertEquals((Object)"p1p2p3", (Object)actual);
    }

    @Test
    public void test_staticPublicMethod_varArgsObject_useArray() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", MethodInvocationTest.getSource(MethodInvocationTest.getDoubleQuotes(new String[]{"package test;", "class Test {", "  public static String getValue(int value, String... parameters) {", "    String result = '';", "    for (Object p : parameters) {", "      result += p;", "    }", "    return result;", "  }", "  public String callMe() {", "    return getValue(5, new String[]{'p1', 'p2', 'p3'});", "  }", "}"})));
        MethodInvocationTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "callMe()");
        MethodInvocationTest.assertEquals((Object)"p1p2p3", (Object)actual);
    }

    @Test
    public void test_staticPublicMethod_varArgsEmpty() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", MethodInvocationTest.getSource(MethodInvocationTest.getDoubleQuotes(new String[]{"package test;", "class Test {", "  public static String getValue(Object... parameters) {", "    String result = 'parameters: ';", "    for (Object p : parameters) {", "      result += p;", "    }", "    return result;", "  }", "  public String callMe() {", "    return getValue();", "  }", "}"})));
        MethodInvocationTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "callMe()");
        MethodInvocationTest.assertEquals((Object)"parameters: ", (Object)actual);
    }

    @Test
    public void test_staticPublicMethod_varArgsInt() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", MethodInvocationTest.getSource(MethodInvocationTest.getDoubleQuotes(new String[]{"package test;", "class Test {", "  public static int getValue(int value, int... parameters) {", "    int result = 0;", "    for (int p : parameters) {", "      result += p;", "    }", "    return result;", "  }", "  public int callMe() {", "    return getValue(5, 1, 2, 3);", "  }", "}"})));
        MethodInvocationTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "callMe()");
        MethodInvocationTest.assertEquals((Object)6, (Object)actual);
    }

    @Test
    public void test_staticPublicMethod_varArgsDouble() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", MethodInvocationTest.getSource(MethodInvocationTest.getDoubleQuotes(new String[]{"package test;", "class Test {", "  public static double getValue(int value, double... parameters) {", "    double result = 0;", "    for (double p : parameters) {", "      result += p;", "    }", "    return result;", "  }", "  public double callMe() {", "    return getValue(5, 1.0, 2.0, 3.0);", "  }", "}"})));
        MethodInvocationTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "callMe()");
        MethodInvocationTest.assertEquals((Object)6.0, (Object)actual);
    }

    @Test
    public void test_InvocationEvaluatorInterceptor_resolveMethod() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyObject.java", MethodInvocationTest.getSourceDQ("package test;", "public class MyObject {", "  public static int foo() {", "    return 1;", "  }", "  public static int bar() {", "    return 2;", "  }", "}"));
        MethodInvocationTest.waitForAutoBuild();
        TestBundle testBundle = new TestBundle();
        try {
            Class<Test_InvocationEvaluatorInterceptor_resolveMethod> interceptorClass = Test_InvocationEvaluatorInterceptor_resolveMethod.class;
            testBundle.addClass(interceptorClass);
            testBundle.addExtension("org.eclipse.wb.core.invocationEvaluatorInterceptors", "<interceptor class='" + interceptorClass.getName() + "'/>");
            testBundle.install();
            try {
                MethodInvocationTest.assertEquals((Object)2, (Object)this.evaluateExpression("MyObject.foo()", "int"));
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_InvocationEvaluatorInterceptor_MethodInvocation() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyObject.java", MethodInvocationTest.getSourceDQ("package test;", "public class MyObject {", "  public static int foo() {", "    return 1;", "  }", "}"));
        MethodInvocationTest.waitForAutoBuild();
        TestBundle testBundle = new TestBundle();
        try {
            Class<Test_InvocationEvaluatorInterceptor_MI> interceptorClass = Test_InvocationEvaluatorInterceptor_MI.class;
            testBundle.addClass(interceptorClass);
            testBundle.addExtension("org.eclipse.wb.core.invocationEvaluatorInterceptors", "<interceptor class='" + interceptorClass.getName() + "'/>");
            testBundle.install();
            try {
                MethodInvocationTest.assertEquals((Object)2, (Object)this.evaluateExpression("MyObject.foo()", "int"));
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_InvocationEvaluatorInterceptor_rewriteException() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyObject.java", MethodInvocationTest.getSourceDQ("package test;", "public class MyObject {", "  public MyObject() {", "    throw new Error('original');", "  }", "}"));
        MethodInvocationTest.waitForAutoBuild();
        TestBundle testBundle = new TestBundle();
        try {
            Class<Test_InvocationEvaluatorInterceptor_rewriteException> interceptorClass = Test_InvocationEvaluatorInterceptor_rewriteException.class;
            testBundle.addClass(interceptorClass);
            testBundle.addExtension("org.eclipse.wb.core.invocationEvaluatorInterceptors", "<interceptor class='" + interceptorClass.getName() + "'/>");
            testBundle.install();
            try {
                try {
                    this.evaluateExpression("new MyObject()", "Object");
                    MethodInvocationTest.fail();
                }
                catch (Throwable e) {
                    e = DesignerExceptionUtils.getRootCause((Throwable)e);
                    MethodInvocationTest.assertEquals((Object)"rewrite", (Object)e.getMessage());
                    testBundle.uninstall();
                }
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_creation_1() throws Exception {
        MethodInvocationTest.assertEquals((Object)0, (Object)this.evaluateExpression("new java.util.ArrayList().size()", "int"));
    }

    @Test
    public void test_creation_2() throws Exception {
        MethodInvocationTest.assertEquals((Object)0, (Object)this.evaluateExpression("new java.util.ArrayList(5).size()", "int"));
    }

    @Test
    public void test_creation_invalidArguments() throws Exception {
        try {
            this.m_ignoreModelCompileProblems = true;
            this.evaluateExpression("new java.util.ArrayList(-3)", "java.lang.Object");
            MethodInvocationTest.fail();
        }
        catch (Throwable e_) {
            DesignerException e = DesignerExceptionUtils.getDesignerException((Throwable)e_);
            MethodInvocationTest.assertEquals((int)307, (int)e.getCode());
        }
    }

    @Test
    public void test_creation_String() throws Exception {
        MethodInvocationTest.assertEquals((Object)new String(new char[]{'a', 'b', 'c', 'd'}, 1, 2), (Object)this.evaluateExpression("new String(new char[]{'a', 'b', 'c', 'd'}, 1, 2)", "java.lang.String"));
    }

    @Test
    public void test_creation_innerStatic() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic Object root() {\n\t\treturn new Foo();\n\t}\n\tpublic static class Foo {\n\t}\n}");
        MethodInvocationTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "root()");
        MethodInvocationTest.assertNotNull((Object)actual);
    }

    @Test
    public void test_creation_innerNotStatic() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("class Test {\n\tpublic Object root() {\n\t\treturn new Foo();\n\t}\n\tpublic class Foo {\n\t}\n}");
        MethodInvocationTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "root()");
        MethodInvocationTest.assertNull((Object)actual);
    }

    @Test
    public void test_creation_varArgsDouble() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", MethodInvocationTest.getSource(MethodInvocationTest.getDoubleQuotes(new String[]{"package test;", "public class Test {", "  double result = 0;", "  public Test(int value, double... parameters) {", "    for (double p : parameters) {", "      result += p;", "    }", "  }", "  public static Object callMe() {", "    return new Test(5, 1.0, 2.0, 3.0);", "  }", "}"})));
        MethodInvocationTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "callMe()");
        MethodInvocationTest.assertEquals((Object)6.0, (Object)ReflectionUtils.getFieldObject((Object)actual, (String)"result"));
    }

    @Test
    public void test_creation_varArgsEmpty() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", MethodInvocationTest.getSource(MethodInvocationTest.getDoubleQuotes(new String[]{"package test;", "public class Test {", "  String result = '';", "  public Test(String... parameters) {", "    for (String p : parameters) {", "      result += p;", "    }", "  }", "  public static Object callMe() {", "    return new Test();", "  }", "}"})));
        MethodInvocationTest.waitForAutoBuild();
        Object actual = this.evaluateSingleMethod(typeDeclaration, "callMe()");
        MethodInvocationTest.assertEquals((Object)"", (Object)ReflectionUtils.getFieldObject((Object)actual, (String)"result"));
    }

    @Test
    public void test_creation_genericType() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyObject.java", MethodInvocationTest.getSourceDQ("package test;", "public class MyObject<E> {", "  public MyObject(E e, int s) {", "  }", "}"));
        MethodInvocationTest.waitForAutoBuild();
        String source = MethodInvocationTest.getSourceDQ("new MyObject<String>('', 0)");
        Object object = this.evaluateExpression(source, "Object");
        MethodInvocationTest.assertNotNull((Object)object);
    }

    @Test
    public void test_creation_genericType_array() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyObject.java", MethodInvocationTest.getSourceDQ("package test;", "public class MyObject<E> {", "  public MyObject(E[] e, int s) {", "  }", "}"));
        MethodInvocationTest.waitForAutoBuild();
        String source = MethodInvocationTest.getSourceDQ("new MyObject<String>(new String[]{}, 0)");
        Object object = this.evaluateExpression(source, "Object");
        MethodInvocationTest.assertNotNull((Object)object);
    }

    @Test
    public void test_anonymous_InvocationEvaluatorInterceptor_evaluateAnonymous() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyClass.java", MethodInvocationTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class MyClass {", "}"));
        MethodInvocationTest.waitForAutoBuild();
        TestBundle testBundle = new TestBundle();
        try {
            Class<TestAnonymousInvocationEvaluatorInterceptor> interceptorClass = TestAnonymousInvocationEvaluatorInterceptor.class;
            testBundle.addClass(interceptorClass);
            testBundle.addExtension("org.eclipse.wb.core.invocationEvaluatorInterceptors", "<interceptor class='" + interceptorClass.getName() + "'/>");
            testBundle.install();
            TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", MethodInvocationTest.getSource("// filler filler filler filler filler", "package test;", "public class Test {", "  public Object foo() {", "    return new MyClass() {", "    };", "  }", "}"));
            Object result = this.evaluateSingleMethod(typeDeclaration, "foo()");
            MethodInvocationTest.assertSame(Object.class, result.getClass());
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_anonymous_InvocationEvaluatorInterceptor_evaluateAnonymousAbstract() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyClass.java", MethodInvocationTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class MyClass {", "}"));
        MethodInvocationTest.setFileContentSrc("test/AbstractSubClass.java", MethodInvocationTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public abstract class AbstractSubClass extends MyClass {", "}"));
        MethodInvocationTest.waitForAutoBuild();
        TestBundle testBundle = new TestBundle();
        try {
            Class<TestAnonymousInvocationEvaluatorInterceptor> interceptorClass = TestAnonymousInvocationEvaluatorInterceptor.class;
            testBundle.addClass(interceptorClass);
            testBundle.addExtension("org.eclipse.wb.core.invocationEvaluatorInterceptors", "<interceptor class='" + interceptorClass.getName() + "'/>");
            testBundle.install();
            TypeDeclaration typeDeclaration = this.createTypeDeclaration("test", "Test.java", MethodInvocationTest.getSource("// filler filler filler filler filler", "package test;", "public class Test {", "  public Object foo() {", "    return new AbstractSubClass() {", "    };", "  }", "}"));
            Object result = this.evaluateSingleMethod(typeDeclaration, "foo()");
            MethodInvocationTest.assertSame(Object.class, result.getClass());
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_anonymous_AnonymousEvaluationError() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyClass.java", MethodInvocationTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class MyClass {", "}"));
        MethodInvocationTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler filler filler\npublic class Test {\n\tpublic Object foo() {\n\t\treturn new MyClass() {\n\t\t};\n\t}\n}");
        try {
            this.evaluateSingleMethod(typeDeclaration, "foo()");
            MethodInvocationTest.fail();
        }
        catch (Throwable e) {
            MethodInvocationTest.assertTrue((boolean)AnonymousEvaluationError.is((Throwable)e));
        }
    }

    @Test
    public void test_anonymous_evaluateListener() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyListener.java", MethodInvocationTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class MyListener {", "}"));
        MethodInvocationTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler filler filler\npublic class Test {\n\tpublic Object foo() {\n\t\treturn new MyListener() {\n\t\t};\n\t}\n}");
        Object o = this.evaluateSingleMethod(typeDeclaration, "foo()");
        MethodInvocationTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)o, (String)"test.MyListener"));
    }

    @Test
    public void test_anonymous_evaluateHandler() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyHandler.java", MethodInvocationTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public class MyHandler {", "}"));
        MethodInvocationTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler filler filler\npublic class Test {\n\tpublic Object foo() {\n\t\treturn new MyHandler() {\n\t\t};\n\t}\n}");
        Object o = this.evaluateSingleMethod(typeDeclaration, "foo()");
        MethodInvocationTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)o, (String)"test.MyHandler"));
    }

    @Test
    public void test_anonymous_evaluateListenerAdapter() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyListener.java", MethodInvocationTest.getSource("// filler filler filler filler filler", "// filler filler filler filler filler", "package test;", "public interface MyListener {", "}"));
        MethodInvocationTest.setFileContentSrc("test/MyListenerAdapter.java", MethodInvocationTest.getSource("// filler filler filler filler filler", "package test;", "public class MyListenerAdapter implements MyListener {", "}"));
        MethodInvocationTest.waitForAutoBuild();
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("// filler filler filler filler filler\npublic class Test {\n\tpublic Object foo() {\n\t\treturn new MyListenerAdapter() {\n\t\t};\n\t}\n}");
        Object o = this.evaluateSingleMethod(typeDeclaration, "foo()");
        MethodInvocationTest.assertTrue((boolean)ReflectionUtils.isSuccessorOf((Object)o, (String)"test.MyListener"));
    }

    @Test
    public void test_creation_InvocationEvaluatorInterceptor_goodResult() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyObject.java", MethodInvocationTest.getSourceDQ("package test;", "public class MyObject {", "  public MyObject() {", "  }", "  public MyObject(int value) {", "    throw new IllegalStateException();", "  }", "}"));
        MethodInvocationTest.waitForAutoBuild();
        TestBundle testBundle = new TestBundle();
        try {
            Class<TestConstructorInvocationEvaluatorInterceptor> interceptorClass = TestConstructorInvocationEvaluatorInterceptor.class;
            testBundle.addClass(interceptorClass);
            testBundle.addExtension("org.eclipse.wb.core.invocationEvaluatorInterceptors", "<interceptor class='" + interceptorClass.getName() + "'/>");
            testBundle.install();
            try {
                TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Object foo() {\n\t\treturn new MyObject(0);\n\t}\n}");
                this.evaluateSingleMethod(typeDeclaration, "foo()");
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_creation_InvocationEvaluatorInterceptor_badResult() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/MyObject.java", MethodInvocationTest.getSourceDQ("package test;", "public class MyObject {", "  public MyObject() {", "    throw new IllegalStateException();", "  }", "  public MyObject(int value) {", "  }", "}"));
        MethodInvocationTest.waitForAutoBuild();
        TestBundle testBundle = new TestBundle();
        try {
            Class<TestConstructorInvocationEvaluatorInterceptor> interceptorClass = TestConstructorInvocationEvaluatorInterceptor.class;
            testBundle.addClass(interceptorClass);
            testBundle.addExtension("org.eclipse.wb.core.invocationEvaluatorInterceptors", "<interceptor class='" + interceptorClass.getName() + "'/>");
            testBundle.install();
            try {
                TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test {\n\tpublic Object foo() {\n\t\treturn new MyObject(0);\n\t}\n}");
                try {
                    this.evaluateSingleMethod(typeDeclaration, "foo()");
                    MethodInvocationTest.fail();
                }
                catch (Throwable e_) {
                    Throwable e = DesignerExceptionUtils.getRootCause((Throwable)e_);
                    MethodInvocationTest.assertInstanceOf(IllegalStateException.class, (Object)e);
                }
            }
            finally {
                testBundle.uninstall();
            }
        }
        finally {
            testBundle.dispose();
        }
    }

    @Test
    public void test_creation_useThisExpression_compatible() throws Exception {
        String[] myObjectLines = new String[]{"package test;", "public class MyObject {", "  private Object m_field;", "  public MyObject(Object p) {", "    m_field = p;", "  }", "}"};
        Object myObject = this.check_creation_replaceThisExpression_withNull(myObjectLines);
        MethodInvocationTest.assertNotSame(null, (Object)ReflectionUtils.getFieldObject((Object)myObject, (String)"m_field"));
    }

    @Test
    public void test_creation_useThisExpression_notCompatible() throws Exception {
        String[] myObjectLines = new String[]{"package test;", "public class MyObject {", "  private Test m_field;", "  public MyObject(Test p) {", "    m_field = p;", "  }", "}"};
        Object myObject = this.check_creation_replaceThisExpression_withNull(myObjectLines);
        MethodInvocationTest.assertSame(null, (Object)ReflectionUtils.getFieldObject((Object)myObject, (String)"m_field"));
    }

    private Object check_creation_replaceThisExpression_withNull(String[] myObjectLines) throws Exception {
        this.m_ignoreModelCompileProblems = true;
        MethodInvocationTest.setFileContentSrc("test/MyObject.java", MethodInvocationTest.getSource(myObjectLines));
        MethodInvocationTest.setFileContentSrc("test/Test.java", MethodInvocationTest.getSourceDQ("package test;", "public class Test {", "  public Object foo() {", "    return new MyObject(this);", "  }", "}"));
        MethodInvocationTest.waitForAutoBuild();
        ICompilationUnit testUnit = m_testProject.getCompilationUnit("test.Test");
        TypeDeclaration typeDeclaration = (TypeDeclaration)this.createASTCompilationUnit(testUnit).types().get(0);
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        ReturnStatement returnStatement = (ReturnStatement)this.m_lastEditor.getEnclosingNode("return ");
        Expression expression = returnStatement.getExpression();
        ProjectClassLoader projectClassLoader = CodeUtils.getProjectClassLoader((IJavaProject)this.m_lastEditor.getModelUnit().getJavaProject());
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{methodDeclaration});
        EvaluationContext context = new EvaluationContext((ClassLoader)projectClassLoader, flowDescription){

            public Object evaluate(Expression e) throws Exception {
                if (e instanceof ThisExpression) {
                    return new Object();
                }
                return super.evaluate(e);
            }
        };
        return AstEvaluationEngine.evaluate((EvaluationContext)context, (Expression)expression);
    }

    @Test
    public void test_SuperMethodInvocation() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/Base.java", MethodInvocationTest.getSourceDQ("package test;", "public class Base {", "  public int getSize() {", "    return 5;", "  }", "}"));
        MethodInvocationTest.waitForAutoBuild();
        Object evaluate = this.test_SuperMethodInvocation2();
        MethodInvocationTest.assertEquals((Object)5, (Object)evaluate);
    }

    @Test
    public void test_SuperMethodInvocation_withException() throws Exception {
        MethodInvocationTest.setFileContentSrc("test/Base.java", MethodInvocationTest.getSourceDQ("package test;", "public class Base {", "  public int getSize() {", "    throw new NullPointerException();", "  }", "}"));
        MethodInvocationTest.waitForAutoBuild();
        try {
            this.m_ignoreModelCompileProblems = true;
            this.test_SuperMethodInvocation2();
            MethodInvocationTest.fail();
        }
        catch (Throwable e_) {
            DesignerException e = DesignerExceptionUtils.getDesignerException((Throwable)e_);
            MethodInvocationTest.assertEquals((int)309, (int)e.getCode());
        }
    }

    private Object test_SuperMethodInvocation2() throws Exception {
        TypeDeclaration typeDeclaration = this.createTypeDeclaration_Test("public class Test extends Base {\n\tpublic int getSize() {\n\t\treturn super.getSize();\n\t}\n}");
        MethodDeclaration methodDeclaration = typeDeclaration.getMethods()[0];
        ReturnStatement returnStatement = (ReturnStatement)this.m_lastEditor.getEnclosingNode("return ");
        Expression expression = returnStatement.getExpression();
        ProjectClassLoader projectClassLoader = CodeUtils.getProjectClassLoader((IJavaProject)this.m_lastEditor.getModelUnit().getJavaProject());
        final Object baseInstance = projectClassLoader.loadClass("test.Base").getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        ExecutionFlowDescription flowDescription = new ExecutionFlowDescription(new MethodDeclaration[]{methodDeclaration});
        EvaluationContext context = new EvaluationContext((ClassLoader)projectClassLoader, flowDescription){

            public Object evaluate(Expression e) throws Exception {
                if (e == null) {
                    return baseInstance;
                }
                return super.evaluate(e);
            }
        };
        Object evaluate = AstEvaluationEngine.evaluate((EvaluationContext)context, (Expression)expression);
        return evaluate;
    }

    public static class TestAnonymousInvocationEvaluatorInterceptor
    extends InvocationEvaluatorInterceptor {
        public Object evaluateAnonymous(EvaluationContext context, ClassInstanceCreation expression, ITypeBinding typeBinding, ITypeBinding typeBindingConcrete, IMethodBinding methodBinding, Object[] arguments) throws Exception {
            if (AstNodeUtils.getFullyQualifiedName((ITypeBinding)typeBindingConcrete, (boolean)false).equals("test.MyClass")) {
                return new Object();
            }
            return AstEvaluationEngine.UNKNOWN;
        }
    }

    public static class TestConstructorInvocationEvaluatorInterceptor
    extends InvocationEvaluatorInterceptor {
        public Object evaluate(EvaluationContext context, ClassInstanceCreation expression, ITypeBinding typeBinding, Class<?> clazz, Constructor<?> actualConstructor, Object[] arguments) throws Exception {
            if (AstNodeUtils.isSuccessorOf((ITypeBinding)typeBinding, (String)"test.MyObject")) {
                return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            return AstEvaluationEngine.UNKNOWN;
        }
    }

    public static class Test_InvocationEvaluatorInterceptor_MI
    extends InvocationEvaluatorInterceptor {
        public Object evaluate(EvaluationContext context, MethodInvocation invocation, IMethodBinding methodBinding, Class<?> clazz, Method method, Object[] argumentValues) {
            if (method.getName().equals("foo")) {
                return 2;
            }
            return AstEvaluationEngine.UNKNOWN;
        }
    }

    public static class Test_InvocationEvaluatorInterceptor_resolveMethod
    extends InvocationEvaluatorInterceptor {
        public Method resolveMethod(Class<?> clazz, String signature) throws Exception {
            if (clazz.getName().equals("test.MyObject") && signature.equals("foo()")) {
                return ReflectionUtils.getMethodBySignature(clazz, (String)"bar()");
            }
            return null;
        }
    }

    public static class Test_InvocationEvaluatorInterceptor_rewriteException
    extends InvocationEvaluatorInterceptor {
        public Throwable rewriteException(Throwable e) {
            if ("original".equals(e.getMessage())) {
                return new Error("rewrite");
            }
            return null;
        }
    }
}

