/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.tests.designer.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifest;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;

public class PdeProjectConversionUtils {
    public static final String BUNDLE_FILENAME_DESCRIPTOR = "META-INF/MANIFEST.MF";
    public static final String BUILD_FILENAME_DESCRIPTOR = "build.properties";
    private final String m_hostPluginId;
    private final String m_pluginActivator;
    private String fLibraryName;
    private String[] fSrcEntries;
    private String[] fLibEntries;

    public static void convertToPDE(IProject project, String hostPluginId) throws CoreException {
        new PdeProjectConversionUtils(hostPluginId).convertProject(project, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void convertToPDE(IProject project, String hostPluginId, String pluginActivator) throws CoreException {
        new PdeProjectConversionUtils(hostPluginId, pluginActivator).convertProject(project, (IProgressMonitor)new NullProgressMonitor());
    }

    public PdeProjectConversionUtils(String hostPluginId) {
        this(hostPluginId, null);
    }

    public PdeProjectConversionUtils(String hostPluginId, String pluginActivator) {
        this.m_hostPluginId = hostPluginId;
        this.m_pluginActivator = pluginActivator;
    }

    private void convertProject(IProject project, IProgressMonitor monitor) throws CoreException {
        IFile buildFile;
        CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", (IProgressMonitor)monitor);
        this.loadClasspathEntries(project, monitor);
        this.loadLibraryName(project);
        if (!WorkspaceModelManager.isPluginProject((IProject)project)) {
            this.createManifestFile(project.getFile(BUNDLE_FILENAME_DESCRIPTOR), monitor);
        }
        if (!(buildFile = project.getFile(BUILD_FILENAME_DESCRIPTOR)).exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(buildFile);
            IBuild build = model.getBuild(true);
            IBuildEntry entry = model.getFactory().createEntry("bin.includes");
            if (project.getFile("plugin.xml").exists()) {
                entry.addToken("plugin.xml");
            }
            if (project.getFile(BUNDLE_FILENAME_DESCRIPTOR).exists()) {
                entry.addToken("META-INF/");
            }
            int i = 0;
            while (i < this.fLibEntries.length) {
                entry.addToken(this.fLibEntries[i]);
                ++i;
            }
            if (this.fSrcEntries.length > 0) {
                entry.addToken(this.fLibraryName);
                IBuildEntry source = model.getFactory().createEntry("source." + this.fLibraryName);
                int i2 = 0;
                while (i2 < this.fSrcEntries.length) {
                    source.addToken(this.fSrcEntries[i2]);
                    ++i2;
                }
                build.add(source);
            }
            if (entry.getTokens().length > 0) {
                build.add(entry);
            }
            model.save();
        }
    }

    private void loadClasspathEntries(IProject project, IProgressMonitor monitor) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] currentClassPath = new IClasspathEntry[]{};
        ArrayList<Object> sources = new ArrayList<Object>();
        ArrayList<String> libraries = new ArrayList<String>();
        try {
            currentClassPath = javaProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        int i = 0;
        while (i < currentClassPath.length) {
            int contentType = currentClassPath[i].getEntryKind();
            if (contentType == 3) {
                String relativePath = this.getRelativePath(currentClassPath[i], project);
                if (relativePath.equals("")) {
                    sources.add(".");
                } else {
                    sources.add(relativePath + "/");
                }
            } else if (contentType == 1) {
                String path = this.getRelativePath(currentClassPath[i], project);
                if (path.length() > 0) {
                    libraries.add(path);
                } else {
                    libraries.add(".");
                }
            }
            ++i;
        }
        this.fSrcEntries = sources.toArray(new String[sources.size()]);
        this.fLibEntries = libraries.toArray(new String[libraries.size()]);
        IClasspathEntry[] classPath = new IClasspathEntry[currentClassPath.length + 1];
        System.arraycopy(currentClassPath, 0, classPath, 0, currentClassPath.length);
        try {
            classPath[classPath.length - 1] = PdeProjectConversionUtils.createContainerEntry();
            javaProject.setRawClasspath(classPath, monitor);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static IClasspathEntry createContainerEntry() throws Exception {
        return (IClasspathEntry)ReflectionUtils.invokeMethod((Object)PdeProjectConversionUtils.getClass_ClasspathComputer(), (String)"createContainerEntry()", (Object[])new Object[0]);
    }

    private static Object getClass_ClasspathComputer() throws ClassNotFoundException {
        try {
            return Class.forName("org.eclipse.pde.internal.core.ClasspathComputer");
        }
        catch (Throwable e) {
            return Class.forName("org.eclipse.pde.internal.ui.wizards.plugin.ClasspathComputer");
        }
    }

    private String getRelativePath(IClasspathEntry cpe, IProject project) {
        IPath path = project.getFile(cpe.getPath()).getProjectRelativePath();
        return path.removeFirstSegments(1).toString();
    }

    private void loadLibraryName(IProject project) {
        if (this.isOldTarget() || this.fLibEntries.length > 0 && this.fSrcEntries.length > 0) {
            String libName = project.getName();
            int i = libName.lastIndexOf(".");
            if (i != -1) {
                libName = libName.substring(i + 1);
            }
            this.fLibraryName = libName + ".jar";
        } else {
            this.fLibraryName = ".";
        }
    }

    private boolean isOldTarget() {
        return TargetPlatformHelper.getTargetVersion() < 3.1;
    }

    private String createInitialName(String id) {
        int loc;
        if (this.m_hostPluginId != null) {
            id = (String)id + " Fragment";
        }
        if ((loc = ((String)id).lastIndexOf(46)) != -1) {
            return id;
        }
        StringBuffer buf = new StringBuffer(((String)id).substring(loc + 1));
        buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
        return buf.toString();
    }

    private void createManifestFile(IFile file, IProgressMonitor monitor) throws CoreException {
        WorkspaceBundlePluginModel model = new WorkspaceBundlePluginModel(file, null);
        model.load();
        IPlugin plugin = model.getPlugin();
        plugin.setId(IdUtil.getValidId((String)file.getProject().getName()));
        plugin.setName(this.createInitialName(plugin.getId()));
        plugin.setVersion("1.0.0");
        if (this.m_pluginActivator != null) {
            plugin.setClassName(this.m_pluginActivator);
        }
        IPluginModelFactory factory = model.getPluginFactory();
        IPluginBase base = model.getPluginBase();
        if (this.fLibraryName != null && !this.fLibraryName.equals(".")) {
            IPluginLibrary library = factory.createLibrary();
            library.setName(this.fLibraryName);
            library.setExported(true);
            base.add(library);
        }
        int i = 0;
        while (i < this.fLibEntries.length) {
            IPluginLibrary library = factory.createLibrary();
            library.setName(this.fLibEntries[i]);
            library.setExported(true);
            base.add(library);
            ++i;
        }
        if (this.m_pluginActivator != null) {
            IPluginImport uiImport = factory.createImport();
            uiImport.setId("org.eclipse.ui");
            base.add(uiImport);
            IPluginImport uiFormsImport = factory.createImport();
            uiFormsImport.setId("org.eclipse.ui.forms");
            base.add(uiFormsImport);
            IPluginImport resourceImport = factory.createImport();
            resourceImport.setId("org.eclipse.core.resources");
            base.add(resourceImport);
            IPluginImport runtimeImport = factory.createImport();
            runtimeImport.setId("org.eclipse.core.runtime");
            base.add(runtimeImport);
        }
        if (TargetPlatformHelper.getTargetVersion() >= 3.1) {
            model.getBundleModel().getBundle().setHeader("Bundle-ManifestVersion", "2");
        }
        if (this.m_hostPluginId != null) {
            model.getBundleModel().getBundle().setHeader("Fragment-Host", this.m_hostPluginId);
        }
        model.save();
        monitor.done();
        this.organizeExports(file.getProject());
    }

    private void organizeExports(final IProject project) {
        PDEModelUtility.modifyModel((ModelModification)new ModelModification(project.getFile(BUNDLE_FILENAME_DESCRIPTOR)){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (!(model instanceof IBundlePluginModelBase)) {
                    return;
                }
                OrganizeManifest.organizeExportPackages((IBundle)((IBundlePluginModelBase)model).getBundleModel().getBundle(), (IProject)project, (boolean)true, (boolean)true);
            }
        }, null);
    }
}

