/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.configurable;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.eval.ExecutionFlowDescription;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.model.JavaInfoEvaluationHelper;
import org.eclipse.wb.internal.core.model.JavaInfoUtils;
import org.eclipse.wb.internal.core.model.property.IConfigurablePropertyObject;
import org.eclipse.wb.internal.core.model.property.JavaProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.converter.StringConverter;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.core.utils.ui.dialogs.StringsDialog;

public final class StringsAddPropertyEditor
extends TextDialogPropertyEditor
implements IConfigurablePropertyObject {
    private String m_addMethodSignature;
    private String[] m_removeMethodsSignatures;

    protected String getText(Property property) throws Exception {
        Object[] items = this.getItems(property);
        return "[" + StringUtils.join((Object[])items, (String)",") + "]";
    }

    String[] getItems(Property _property) throws Exception {
        JavaInfo javaInfo = ((JavaProperty)_property).getJavaInfo();
        List<MethodInvocation> invocations = javaInfo.getMethodInvocations(this.m_addMethodSignature);
        ExecutionFlowDescription flowDescription = EditorState.get(javaInfo.getEditor()).getFlowDescription();
        JavaInfoUtils.sortNodesByFlow(flowDescription, false, invocations);
        ArrayList<String> items = new ArrayList<String>();
        for (MethodInvocation invocation : invocations) {
            Expression itemExpression = DomGenerics.arguments(invocation).get(0);
            String item = (String)JavaInfoEvaluationHelper.getValue(itemExpression);
            items.add(item);
        }
        return items.toArray(new String[items.size()]);
    }

    void setItems(Property _property, final String[] items) throws Exception {
        final JavaInfo javaInfo = ((JavaProperty)_property).getJavaInfo();
        ExecutionUtils.run((ObjectInfo)javaInfo, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                StringsAddPropertyEditor.this.setItems0(items, javaInfo);
            }
        });
    }

    private void setItems0(String[] items, JavaInfo javaInfo) throws Exception {
        javaInfo.removeMethodInvocations(this.m_addMethodSignature);
        String[] stringArray = this.m_removeMethodsSignatures;
        int n = this.m_removeMethodsSignatures.length;
        int n2 = 0;
        while (n2 < n) {
            String removeMethodSignature = stringArray[n2];
            javaInfo.removeMethodInvocations(removeMethodSignature);
            ++n2;
        }
        int i = items.length - 1;
        while (i >= 0) {
            String item = items[i];
            String itemSource = StringConverter.INSTANCE.toJavaSource(javaInfo, item);
            javaInfo.addMethodInvocation(this.m_addMethodSignature, itemSource);
            --i;
        }
    }

    protected void openDialog(Property property) throws Exception {
        StringsDialog itemsDialog = new StringsDialog(DesignerPlugin.getShell(), (AbstractUIPlugin)DesignerPlugin.getDefault(), property.getTitle(), "String items:", "Each line in the above text field represents a single item.");
        itemsDialog.setItems(this.getItems(property));
        if (itemsDialog.open() == 0) {
            String[] items = itemsDialog.getItems();
            this.setItems(property, items);
        }
    }

    @Override
    public void configure(EditorState state, Map<String, Object> parameters) throws Exception {
        String addMethodName = (String)parameters.get("addMethod");
        Assert.isNotNull((Object)addMethodName, (String)"No 'addMethod' parameter in %s.", (Object[])new Object[]{parameters});
        this.m_addMethodSignature = addMethodName + "(java.lang.String)";
        String removeMethodsString = (String)parameters.get("removeMethods");
        this.m_removeMethodsSignatures = removeMethodsString != null ? StringUtils.split((String)removeMethodsString) : ArrayUtils.EMPTY_STRING_ARRAY;
    }
}

