/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.creation;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.WrapperByMethod;
import org.eclipse.wb.core.model.association.Association;
import org.eclipse.wb.core.model.association.WrappedObjectAssociation;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.creation.ILiveCreationSupport;
import org.eclipse.wb.internal.core.model.creation.WrapperMethodCreationSupport;
import org.eclipse.wb.internal.core.utils.ast.NodeTarget;

public class WrapperMethodLiveCreationSupport
extends WrapperMethodCreationSupport
implements ILiveCreationSupport {
    public WrapperMethodLiveCreationSupport(WrapperByMethod viewer) {
        super(viewer);
    }

    @Override
    public CreationSupport getLiveComponentCreation() {
        return new LiveCreationSupport();
    }

    private class LiveCreationSupport
    extends CreationSupport {
        private Expression m_expression;

        private LiveCreationSupport() {
        }

        @Override
        public ASTNode getNode() {
            return this.m_expression;
        }

        @Override
        public boolean isJavaInfo(ASTNode node) {
            return node == this.m_expression;
        }

        @Override
        public Association getAssociation() throws Exception {
            return new WrappedObjectAssociation(WrapperMethodLiveCreationSupport.this.m_wrapper);
        }

        @Override
        public String add_getSource(NodeTarget target) throws Exception {
            String controlSource = "." + WrapperMethodLiveCreationSupport.this.m_wrapper.getControlMethod().getName() + "()";
            return WrapperMethodLiveCreationSupport.this.m_wrapper.getWrapperInfo().getCreationSupport().add_getSource(target) + controlSource;
        }

        @Override
        public void add_setSourceExpression(Expression expression) throws Exception {
            this.m_expression = expression;
            this.m_javaInfo.bindToExpression(expression);
        }
    }
}

