/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.property.editor.image;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.icon.AbstractImagePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImageDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.ClasspathImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.DefaultImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.FileImagePage;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.NullImagePage;
import org.eclipse.wb.internal.swt.Activator;
import org.eclipse.wb.internal.swt.model.jface.resource.ManagerContainerInfo;
import org.eclipse.wb.internal.swt.model.property.editor.image.ImageDescriptorPropertyEditor;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.PluginFileImagePage;
import org.eclipse.wb.internal.swt.model.property.editor.image.plugin.PluginImagesRoot;

public final class ImagePropertyEditor
extends AbstractImagePropertyEditor {
    public static final PropertyEditor INSTANCE = new ImagePropertyEditor();

    private ImagePropertyEditor() {
        super(Image.class);
    }

    public static String getInvocationSource(JavaInfo javaInfo, String location, String filename) throws Exception {
        String resourceManager = ManagerContainerInfo.getResourceManagerInfo(javaInfo.getRootJava()).getVariableSupport().getName();
        return String.format("%s.create(%s)", resourceManager, ImageDescriptorPropertyEditor.getInvocationSource(location, filename));
    }

    public static boolean useResourceManager(JavaInfo javaInfo) {
        IPreferenceStore preferences = javaInfo.getDescription().getToolkit().getPreferences();
        return preferences.getBoolean("useResourceManager");
    }

    protected AbstractImageDialog createImageDialog(IJavaProject javaProject) {
        return new ImageDialog(javaProject);
    }

    private static final class ImageDialog
    extends AbstractImageDialog {
        private final IJavaProject m_javaProject;

        protected ImageDialog(IJavaProject javaProject) {
            super(DesignerPlugin.getShell(), (AbstractUIPlugin)Activator.getDefault());
            this.m_javaProject = javaProject;
        }

        protected void addPages(Composite parent) {
            this.addPage((AbstractImagePage)new ClasspathImagePage(parent, 0, (AbstractImageDialog)this, this.m_javaProject));
            this.addPage((AbstractImagePage)new FileImagePage(parent, 0, (AbstractImageDialog)this));
            this.addPage((AbstractImagePage)new NullImagePage(parent, 0, (AbstractImageDialog)this));
            this.addPage((AbstractImagePage)new DefaultImagePage(parent, 0, (AbstractImageDialog)this));
            if (PluginImagesRoot.testPluginProject(this.m_javaProject.getProject())) {
                this.addPage((AbstractImagePage)PluginFileImagePage.createPage(parent, 0, this, this.m_javaProject.getProject()));
            }
        }
    }
}

