/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.dialogs.NamespaceInfoErrorHelper;
import org.eclipse.wst.xml.ui.internal.dialogs.UpdateListener;
import org.eclipse.wst.xml.ui.internal.nsedit.CommonEditNamespacesDialog;

public class EditSchemaInfoDialog
extends Dialog
implements UpdateListener {
    protected Label errorMessageLabel;
    protected List namespaceInfoList;
    protected IPath resourceLocation;

    public EditSchemaInfoDialog(Shell parentShell, IPath resourceLocation) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.resourceLocation = resourceLocation;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)dialogArea, "org.eclipse.wst.xml.ui.xcui0100");
        CommonEditNamespacesDialog editNamespacesControl = new CommonEditNamespacesDialog(dialogArea, this.resourceLocation, XMLUIMessages._UI_NAMESPACE_DECLARATIONS, false, true);
        editNamespacesControl.setNamespaceInfoList(this.namespaceInfoList);
        editNamespacesControl.updateErrorMessage(this.namespaceInfoList);
        return dialogArea;
    }

    protected Control getDialogArea(Composite parent) {
        return super.createDialogArea(parent);
    }

    public List getNamespaceInfoList() {
        return this.namespaceInfoList;
    }

    public void setNamespaceInfoList(List list) {
        this.namespaceInfoList = list;
    }

    public void updateErrorMessage(List namespaceInfoList) {
        NamespaceInfoErrorHelper helper = new NamespaceInfoErrorHelper();
        String errorMessage = helper.computeErrorMessage(namespaceInfoList, null);
        this.errorMessageLabel.setText(errorMessage != null ? errorMessage : "");
    }

    @Override
    public void updateOccured(Object object, Object arg) {
        this.updateErrorMessage((List)arg);
    }
}

