/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.compare.internal;

import java.util.ArrayList;
import org.eclipse.compare.internal.CompareMessages;
import org.eclipse.compare.internal.Worker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.operation.IRunnableWithProgress;

public class WorkerJob
extends Job {
    private final Worker worker;

    public WorkerJob(String name) {
        super(name);
        this.worker = new Worker(name);
    }

    protected IStatus run(IProgressMonitor monitor) {
        this.worker.run(monitor);
        IStatus result = this.getResult(this.worker);
        this.schedule();
        return result;
    }

    private IStatus getResult(Worker w) {
        Throwable[] errors = w.getErrors();
        if (errors.length == 0) {
            return Status.OK_STATUS;
        }
        if (errors.length == 1) {
            return new Status(4, "org.eclipse.compare", 0, errors[0].getMessage(), errors[0]);
        }
        ArrayList<Status> statii = new ArrayList<Status>();
        Throwable[] throwableArray = errors;
        int n = errors.length;
        int n2 = 0;
        while (n2 < n) {
            Throwable throwable = throwableArray[n2];
            statii.add(new Status(4, "org.eclipse.compare", 0, errors[0].getMessage(), throwable));
            ++n2;
        }
        return new MultiStatus("org.eclipse.compare", 0, statii.toArray(new IStatus[statii.size()]), CompareMessages.WorkerJob_0, null);
    }

    public boolean shouldRun() {
        return this.worker.hasWork();
    }

    public void add(IRunnableWithProgress runnable) {
        this.worker.add(runnable);
        this.schedule();
    }
}

