/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.SDView;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.Criteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.FilterCriteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.SearchFilterDialog;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDFilterProvider;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.util.Messages;
import org.eclipse.ui.IViewPart;

public class FilterListDialog
extends Dialog {
    protected static final String FILTERS_LIST_CRITERIA = "filtersListsCriteria";
    protected static final String FILTERS_LIST_SIZE = "filtersListSize";
    private final IViewPart fViewer;
    private final ISDFilterProvider fProvider;
    private List<FilterCriteria> fFilters;
    private Button fAdd;
    private Button fRemove;
    private Button fEdit;
    private Table fTable;

    public FilterListDialog(IViewPart view, ISDFilterProvider loader) {
        super(view.getSite().getShell());
        this.fViewer = view;
        this.fProvider = loader;
        this.fFilters = null;
        this.setShellStyle(67680);
    }

    protected void addCriteria(Criteria criteria, boolean checked, boolean positive, String loaderClassName) {
        CriteriaTableItem cti = new CriteriaTableItem(this.fTable, checked, positive, loaderClassName);
        cti.setCriteria(criteria);
    }

    protected void replaceSelectedCriteria(Criteria newCriteria) {
        CriteriaTableItem cti = (CriteriaTableItem)this.fTable.getSelection()[0].getData();
        cti.setCriteria(newCriteria);
    }

    protected void handleTableSelectionCount() {
        int count = this.fTable.getSelectionCount();
        this.fEdit.setEnabled(count == 1);
        this.fRemove.setEnabled(count > 0);
    }

    public Control createDialogArea(Composite parent) {
        Group ret = new Group(parent, 0);
        ret.setText(Messages.SequenceDiagram_ListOfHideDisplayPatterns);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = false;
        rowLayout.pack = true;
        rowLayout.justify = false;
        rowLayout.type = 256;
        rowLayout.marginLeft = 4;
        rowLayout.marginTop = 4;
        rowLayout.marginRight = 4;
        rowLayout.marginBottom = 4;
        rowLayout.spacing = 8;
        ret.setLayout((Layout)rowLayout);
        this.fTable = new Table((Composite)ret, 34);
        this.fTable.setLayoutData((Object)new RowData(220, 84));
        this.fTable.setHeaderVisible(false);
        this.fTable.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                Criteria criteria;
                int count = FilterListDialog.this.fTable.getSelectionCount();
                if (count == 1 && (criteria = FilterListDialog.this.openFilterDialog(((CriteriaTableItem)FilterListDialog.this.fTable.getSelection()[0].getData()).getCriteria(), Messages.SequenceDiagram_Update)) != null) {
                    FilterListDialog.this.replaceSelectedCriteria(criteria);
                }
            }

            public void widgetSelected(SelectionEvent e) {
                FilterListDialog.this.handleTableSelectionCount();
            }
        });
        if (this.fFilters != null) {
            for (FilterCriteria filterCriteria : this.fFilters) {
                this.addCriteria(filterCriteria.getCriteria(), filterCriteria.isActive(), filterCriteria.isPositive(), filterCriteria.getLoaderClassName());
            }
        }
        Composite commands = new Composite((Composite)ret, 0);
        RowLayout rowLayoutCommands = new RowLayout();
        rowLayoutCommands.wrap = false;
        rowLayoutCommands.pack = false;
        rowLayoutCommands.justify = true;
        rowLayoutCommands.type = 512;
        rowLayoutCommands.marginLeft = 0;
        rowLayoutCommands.marginTop = 4;
        rowLayoutCommands.marginRight = 0;
        rowLayoutCommands.marginBottom = 4;
        rowLayoutCommands.spacing = 8;
        commands.setLayout((Layout)rowLayoutCommands);
        this.fAdd = new Button(commands, 0);
        this.fAdd.setText(Messages.SequenceDiagram_Add);
        this.fAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Criteria init = new Criteria();
                Criteria c = FilterListDialog.this.openFilterDialog(init, Messages.SequenceDiagram_Create);
                if (c != null) {
                    FilterListDialog.this.addCriteria(c, true, false, null);
                }
            }
        });
        this.fEdit = new Button(commands, 0);
        this.fEdit.setText(Messages.SequenceDiagram_EditIt);
        this.fEdit.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Criteria c = FilterListDialog.this.openFilterDialog(((CriteriaTableItem)FilterListDialog.this.fTable.getSelection()[0].getData()).getCriteria(), Messages.SequenceDiagram_Update);
                if (c != null) {
                    FilterListDialog.this.replaceSelectedCriteria(c);
                }
            }
        });
        this.fEdit.setEnabled(false);
        this.fRemove = new Button(commands, 0);
        this.fRemove.setText(Messages.SequenceDiagram_Remove);
        this.fRemove.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FilterListDialog.this.fTable.remove(FilterListDialog.this.fTable.getSelectionIndices());
                FilterListDialog.this.handleTableSelectionCount();
            }
        });
        this.fRemove.setEnabled(false);
        this.getShell().setText(Messages.SequenceDiagram_SequenceDiagramHidePatterns);
        return ret;
    }

    protected Criteria openFilterDialog(Criteria criteria, String action) {
        SearchFilterDialog filter = new SearchFilterDialog((SDView)this.fViewer, this.fProvider, true, 65536);
        filter.setCriteria(criteria);
        filter.setOkText(action);
        filter.setTitle(Messages.SequenceDiagram_DefinitionOfHidePattern);
        filter.open();
        return filter.getCriteria();
    }

    public int open() {
        this.create();
        this.getShell().pack();
        this.getShell().setLocation(this.getShell().getDisplay().getCursorLocation());
        this.loadFiltersCriteria();
        return super.open();
    }

    public void okPressed() {
        this.fFilters = this.fTable.getItemCount() > 0 ? new ArrayList<FilterCriteria>() : null;
        int i = 0;
        while (i < this.fTable.getItemCount()) {
            TableItem item = this.fTable.getItem(i);
            CriteriaTableItem cti = (CriteriaTableItem)item.getData();
            FilterCriteria fc = new FilterCriteria(cti.getCriteria(), item.getChecked(), cti.isPositive(), cti.getLoaderClassName());
            FilterCriteria efc = FilterCriteria.find(fc, this.fFilters);
            if (efc == null) {
                this.fFilters.add(fc);
            } else {
                efc.setActive(efc.isActive() || fc.isActive());
            }
            ++i;
        }
        super.close();
        this.fProvider.filter(this.fFilters);
        FilterListDialog.saveFiltersCriteria(this.fFilters);
    }

    public void setFilters(List<FilterCriteria> filters) {
        this.fFilters = filters;
    }

    public List<FilterCriteria> getFilters() {
        return this.fFilters;
    }

    protected void loadFiltersCriteria() {
        List<FilterCriteria> globalFilters = FilterListDialog.getGlobalFilters();
        for (FilterCriteria filterCriteria : globalFilters) {
            this.addCriteria(filterCriteria.getCriteria(), filterCriteria.isActive(), filterCriteria.isPositive(), filterCriteria.getLoaderClassName());
        }
    }

    public static List<FilterCriteria> getGlobalFilters() {
        DialogSettings settings = (DialogSettings)Activator.getDefault().getDialogSettings().getSection(FILTERS_LIST_CRITERIA);
        int i = 0;
        DialogSettings section = null;
        int size = 0;
        ArrayList<FilterCriteria> globalFilters = new ArrayList<FilterCriteria>();
        if (settings != null) {
            try {
                size = settings.getInt(FILTERS_LIST_SIZE);
            }
            catch (NumberFormatException e) {
                size = 0;
            }
            section = (DialogSettings)settings.getSection(FILTERS_LIST_CRITERIA + i);
            while (section != null && i < size) {
                FilterCriteria criteria = new FilterCriteria();
                criteria.setCriteria(new Criteria());
                criteria.load(section);
                globalFilters.add(criteria);
                section = (DialogSettings)settings.getSection(FILTERS_LIST_CRITERIA + ++i);
            }
        }
        return globalFilters;
    }

    public static void saveFiltersCriteria(List<FilterCriteria> globalFilters) {
        DialogSettings settings = (DialogSettings)Activator.getDefault().getDialogSettings();
        DialogSettings section = (DialogSettings)settings.getSection(FILTERS_LIST_CRITERIA);
        if (section == null) {
            section = (DialogSettings)settings.addNewSection(FILTERS_LIST_CRITERIA);
        }
        if (globalFilters == null) {
            section.put(FILTERS_LIST_SIZE, 0);
            return;
        }
        section.put(FILTERS_LIST_SIZE, globalFilters.size());
        int j = 0;
        while (j < globalFilters.size()) {
            if (globalFilters.get(j) == null) {
                return;
            }
            FilterCriteria criteria = globalFilters.get(j);
            DialogSettings subSection = (DialogSettings)section.getSection(FILTERS_LIST_CRITERIA + j);
            if (subSection == null) {
                subSection = (DialogSettings)section.addNewSection(FILTERS_LIST_CRITERIA + j);
            }
            criteria.save(subSection);
            ++j;
        }
    }

    public static void deactivateSavedGlobalFilters() {
        List<FilterCriteria> filters = FilterListDialog.getGlobalFilters();
        for (FilterCriteria criteria : filters) {
            criteria.setActive(false);
        }
        FilterListDialog.saveFiltersCriteria(filters);
    }

    protected class CriteriaTableItem {
        protected Criteria fCriteria;
        protected boolean fIsPositive;
        protected String fLoaderClassName;
        protected TableItem fTableItem;

        public CriteriaTableItem(Table parent, boolean isActive, boolean isPositive, String loaderClassName) {
            this.fTableItem = new TableItem(parent, 0);
            this.fTableItem.setData((Object)this);
            this.fTableItem.setChecked(isActive);
            this.fIsPositive = isPositive;
            this.fLoaderClassName = loaderClassName;
        }

        public CriteriaTableItem(Table parent, boolean isActive, boolean isPositive, String loaderClassName, int index) {
            this.fTableItem = new TableItem(parent, 0, index);
            this.fTableItem.setChecked(isActive);
            this.fIsPositive = isPositive;
            this.fLoaderClassName = loaderClassName;
        }

        public void setCriteria(Criteria criteria) {
            this.fCriteria = criteria;
            this.fTableItem.setText((this.fIsPositive ? Messages.SequenceDiagram_display : Messages.SequenceDiagram_hide) + " " + this.fCriteria.getExpression() + " " + this.fCriteria.getGraphNodeSummary(FilterListDialog.this.fProvider, this.fLoaderClassName));
        }

        public Criteria getCriteria() {
            return this.fCriteria;
        }

        public boolean isPositive() {
            return this.fIsPositive;
        }

        public String getLoaderClassName() {
            return this.fLoaderClassName;
        }
    }
}

