/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.preferences;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationReader;
import org.eclipse.wst.sse.ui.preferences.ICompletionProposalCategoriesConfigurationWriter;

public abstract class AbstractCompletionProposalCategoriesConfiguration
implements ICompletionProposalCategoriesConfigurationReader,
ICompletionProposalCategoriesConfigurationWriter {
    private static final String PREFERENCE_CATEGORY_SEPERATOR = "\u0000";
    private List fDefaultPageSortOrder;
    private List fOwnPageSortOrder = new ArrayList();
    private Set fShouldNotDisplayOnOwnPage;
    private Set fShouldNotDisplayOnDefaultPage;

    public AbstractCompletionProposalCategoriesConfiguration() {
        this.fDefaultPageSortOrder = new ArrayList();
        this.fShouldNotDisplayOnOwnPage = new HashSet();
        this.fShouldNotDisplayOnDefaultPage = new HashSet();
        this.loadUserConfiguration();
    }

    protected abstract IPreferenceStore getPreferenceStore();

    protected abstract String getPageSortOrderPrefKey();

    protected abstract String getDefaultPageSortOrderPrefKey();

    protected abstract String getShouldNotDisplayOnOwnPagePrefKey();

    protected abstract String getShouldNotDisplayOnDefaultPagePrefKey();

    @Override
    public int getPageSortOrder(String categoryID) {
        int sortOrder = this.fOwnPageSortOrder.indexOf(categoryID);
        if (sortOrder == -1) {
            sortOrder = Integer.MAX_VALUE;
        }
        return sortOrder;
    }

    @Override
    public int getDefaultPageSortOrder(String categoryID) {
        int sortOrder = this.fDefaultPageSortOrder.indexOf(categoryID);
        if (sortOrder == -1) {
            sortOrder = Integer.MAX_VALUE;
        }
        return sortOrder;
    }

    @Override
    public boolean shouldDisplayOnDefaultPage(String categoryID) {
        return !this.fShouldNotDisplayOnDefaultPage.contains(categoryID);
    }

    @Override
    public boolean shouldDisplayOnOwnPage(String categoryID) {
        return !this.fShouldNotDisplayOnOwnPage.contains(categoryID);
    }

    @Override
    public void loadDefaults() {
        this.loadDefaultPagePreference(true);
        this.loadPageSortOrder(true);
        this.loadDefaultPageSortOrder(true);
        this.loadShouldNotDisplayOnOwnPage(true);
    }

    @Override
    public boolean saveConfiguration() {
        this.saveShouldDisplayOnDefaultPageConfiguration();
        this.saveShouldDisplayOnOwnPageConfiguration();
        this.saveDefaultPageSortOrderConfiguration();
        this.savePageSortOrderConfiguration();
        return true;
    }

    @Override
    public void setShouldDisplayOnDefaultPage(String categoryID, boolean shouldDisplay) {
        if (shouldDisplay) {
            this.fShouldNotDisplayOnDefaultPage.remove(categoryID);
        } else {
            this.fShouldNotDisplayOnDefaultPage.add(categoryID);
        }
    }

    @Override
    public void setShouldDisplayOnOwnPage(String categoryID, boolean shouldDisplay) {
        if (shouldDisplay) {
            this.fShouldNotDisplayOnOwnPage.remove(categoryID);
        } else {
            this.fShouldNotDisplayOnOwnPage.add(categoryID);
        }
    }

    @Override
    public void setPageOrder(List order) {
        this.fOwnPageSortOrder = order;
    }

    @Override
    public void setDefaultPageOrder(List order) {
        this.fDefaultPageSortOrder = order;
    }

    private void loadUserConfiguration() {
        this.loadDefaultPagePreference(false);
        this.loadPageSortOrder(false);
        this.loadDefaultPageSortOrder(false);
        this.loadShouldNotDisplayOnOwnPage(false);
    }

    private void loadDefaultPagePreference(boolean useDefaults) {
        this.fShouldNotDisplayOnDefaultPage.clear();
        String displayOnDefaultPage = useDefaults ? this.getPreferenceStore().getDefaultString(this.getShouldNotDisplayOnDefaultPagePrefKey()) : this.getPreferenceStore().getString(this.getShouldNotDisplayOnDefaultPagePrefKey());
        StringTokenizer defaultPageTokenizer = new StringTokenizer(displayOnDefaultPage, PREFERENCE_CATEGORY_SEPERATOR);
        while (defaultPageTokenizer.hasMoreTokens()) {
            this.fShouldNotDisplayOnDefaultPage.add(defaultPageTokenizer.nextToken());
        }
    }

    private void loadPageSortOrder(boolean useDefaults) {
        this.fOwnPageSortOrder.clear();
        String sortOrder = useDefaults ? this.getPreferenceStore().getDefaultString(this.getPageSortOrderPrefKey()) : this.getPreferenceStore().getString(this.getPageSortOrderPrefKey());
        StringTokenizer tokenizer = new StringTokenizer(sortOrder, PREFERENCE_CATEGORY_SEPERATOR);
        while (tokenizer.hasMoreTokens()) {
            String categoryID = tokenizer.nextToken();
            this.fOwnPageSortOrder.add(categoryID);
        }
    }

    private void loadDefaultPageSortOrder(boolean useDefaults) {
        this.fDefaultPageSortOrder.clear();
        String sortOrder = useDefaults ? this.getPreferenceStore().getDefaultString(this.getDefaultPageSortOrderPrefKey()) : this.getPreferenceStore().getString(this.getDefaultPageSortOrderPrefKey());
        StringTokenizer tokenizer = new StringTokenizer(sortOrder, PREFERENCE_CATEGORY_SEPERATOR);
        while (tokenizer.hasMoreTokens()) {
            String categoryID = tokenizer.nextToken();
            this.fDefaultPageSortOrder.add(categoryID);
        }
    }

    private void loadShouldNotDisplayOnOwnPage(boolean useDefaults) {
        this.fShouldNotDisplayOnOwnPage.clear();
        String preference = useDefaults ? this.getPreferenceStore().getDefaultString(this.getShouldNotDisplayOnOwnPagePrefKey()) : this.getPreferenceStore().getString(this.getShouldNotDisplayOnOwnPagePrefKey());
        StringTokenizer tokenizer = new StringTokenizer(preference, PREFERENCE_CATEGORY_SEPERATOR);
        while (tokenizer.hasMoreTokens()) {
            String categoryID = tokenizer.nextToken();
            this.fShouldNotDisplayOnOwnPage.add(categoryID);
        }
    }

    private void saveShouldDisplayOnDefaultPageConfiguration() {
        StringBuffer defaultPageBuff = new StringBuffer();
        for (String categoryID : this.fShouldNotDisplayOnDefaultPage) {
            defaultPageBuff.append(String.valueOf(categoryID) + PREFERENCE_CATEGORY_SEPERATOR);
        }
        this.getPreferenceStore().setValue(this.getShouldNotDisplayOnDefaultPagePrefKey(), defaultPageBuff.toString());
    }

    private void savePageSortOrderConfiguration() {
        StringBuffer orderBuff = new StringBuffer();
        int i = 0;
        while (i < this.fOwnPageSortOrder.size()) {
            if (this.fOwnPageSortOrder.get(i) != null) {
                orderBuff.append(this.fOwnPageSortOrder.get(i) + PREFERENCE_CATEGORY_SEPERATOR);
            }
            ++i;
        }
        this.getPreferenceStore().setValue(this.getPageSortOrderPrefKey(), orderBuff.toString());
    }

    private void saveDefaultPageSortOrderConfiguration() {
        StringBuffer orderBuff = new StringBuffer();
        int i = 0;
        while (i < this.fDefaultPageSortOrder.size()) {
            if (this.fDefaultPageSortOrder.get(i) != null) {
                orderBuff.append(this.fDefaultPageSortOrder.get(i) + PREFERENCE_CATEGORY_SEPERATOR);
            }
            ++i;
        }
        this.getPreferenceStore().setValue(this.getDefaultPageSortOrderPrefKey(), orderBuff.toString());
    }

    private void saveShouldDisplayOnOwnPageConfiguration() {
        StringBuffer buff = new StringBuffer();
        for (String categoryID : this.fShouldNotDisplayOnOwnPage) {
            buff.append(String.valueOf(categoryID) + PREFERENCE_CATEGORY_SEPERATOR);
        }
        this.getPreferenceStore().setValue(this.getShouldNotDisplayOnOwnPagePrefKey(), buff.toString());
    }
}

