/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.filters.ui.lspFilterTextbox;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.lsp4j.ColorInformation;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tracecompass.incubator.internal.filters.core.client.wrapper.LanguageFilterClientWrapper;
import org.eclipse.tracecompass.incubator.internal.filters.core.shared.LspObserver;
import org.eclipse.tracecompass.incubator.internal.filters.ui.lspFilterTextbox.FilterBoxLocalTextCompletion;
import org.eclipse.tracecompass.incubator.internal.filters.ui.lspFilterTextbox.FilterValidityListener;
import org.eclipse.tracecompass.incubator.internal.filters.ui.lspFilterTextbox.RecentlyUsedFilters;

public class LspFilterTextbox
implements LspObserver {
    private final String fFilterBoxUri;
    private @Nullable LanguageFilterClientWrapper fLspClient;
    private List<FilterValidityListener> fListeners = new ArrayList<FilterValidityListener>();
    private final Color fDefaultFilterTextColor;
    private final Color fDefaultFilterBackgroundColor;
    private final StyledText fFilterStyledText;
    private final TextViewer fTextViewer;
    private final CLabel fSearchButton;
    private final CLabel fCancelButton;
    private final RecentlyUsedFilters fRecentlyUsedFilters;
    private String fLastTextUpdate;
    private final DefaultToolTip fToolTip;
    private Boolean fIsValidString = false;
    private List<ColorInformation> fColors = new ArrayList<ColorInformation>();
    private List<Diagnostic> fDiagnostics = new ArrayList<Diagnostic>();

    public LspFilterTextbox(Composite parent, String filterBoxUri) {
        this.fFilterBoxUri = filterBoxUri;
        Composite baseComposite = new Composite(parent, 2048);
        baseComposite.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        GridLayout baseCompositeGridLayout = new GridLayout(3, false);
        baseCompositeGridLayout.marginHeight = 0;
        baseCompositeGridLayout.marginWidth = 0;
        baseComposite.setLayout((Layout)baseCompositeGridLayout);
        this.fSearchButton = new CLabel(baseComposite, 0x1000000);
        this.fSearchButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.fSearchButton.setText("search");
        this.fTextViewer = new TextViewer(baseComposite, 2052);
        this.fFilterStyledText = this.fTextViewer.getTextWidget();
        this.fFilterStyledText.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.fCancelButton = new CLabel(baseComposite, 0x1000000);
        this.fCancelButton.setLayoutData((Object)GridDataFactory.fillDefaults().grab(false, true).create());
        this.fCancelButton.setText("clear");
        this.setIconsListener();
        this.setKeyListener();
        this.fDefaultFilterBackgroundColor = this.fFilterStyledText.getBackground();
        this.fLspClient = new LanguageFilterClientWrapper((LspObserver)this, this.fFilterBoxUri);
        this.fDefaultFilterTextColor = this.fFilterStyledText.getForeground();
        this.fRecentlyUsedFilters = new RecentlyUsedFilters(5, "GlobalFilterViewer");
        this.fToolTip = new DefaultToolTip((Control)this.fFilterStyledText);
        this.styleToolTip();
    }

    public boolean setFocus() {
        return this.fFilterStyledText.setFocus();
    }

    public String getText() {
        return this.fFilterStyledText.getText();
    }

    public void setText(String text) {
        this.fFilterStyledText.setText(text);
    }

    public void addValidListener(FilterValidityListener validListener) {
        this.fListeners.add(validListener);
    }

    private void styleToolTip() {
        this.fToolTip.setBackgroundColor(Display.getCurrent().getSystemColor(1));
        this.fToolTip.setForegroundColor(Display.getCurrent().getSystemColor(3));
        this.fToolTip.setShift(new Point(0, 10));
        this.fToolTip.deactivate();
    }

    private void notifyValid() {
        this.fRecentlyUsedFilters.addFilter(this.fFilterStyledText.getText());
        if (this.fIsValidString.booleanValue()) {
            for (FilterValidityListener validListener : this.fListeners) {
                validListener.validFilter();
            }
        }
    }

    private void notifyInvalid() {
        for (FilterValidityListener validListener : this.fListeners) {
            validListener.invalidFilter();
        }
    }

    private void setKeyListener() {
        this.fFilterStyledText.addKeyListener(new KeyListener(){

            public void keyReleased(@Nullable KeyEvent e) {
                Integer cursorPosition;
                String newText;
                if (e == null) {
                    return;
                }
                String text = Objects.requireNonNull(LspFilterTextbox.this.fFilterStyledText.getText());
                if (e.character != '\b' && e.character != '\u007f' && !text.equals(LspFilterTextbox.this.fLastTextUpdate) && !(newText = FilterBoxLocalTextCompletion.autocomplete(text, cursorPosition = Integer.valueOf(LspFilterTextbox.this.fFilterStyledText.getCaretOffset()))).equals(text)) {
                    LspFilterTextbox.this.fFilterStyledText.setText(newText);
                    LspFilterTextbox.this.fFilterStyledText.setCaretOffset(cursorPosition.intValue());
                    text = newText;
                }
                LspFilterTextbox.this.fLastTextUpdate = text;
                LspFilterTextbox.this.notifyLspClient(text);
            }

            public void keyPressed(@Nullable KeyEvent e) {
                if (e == null) {
                    return;
                }
                if (e.character == '\r') {
                    LspFilterTextbox.this.notifyValid();
                }
            }
        });
    }

    private void setIconsListener() {
        this.fSearchButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                LspFilterTextbox.this.notifyValid();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        this.fCancelButton.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
                LspFilterTextbox.this.fFilterStyledText.setText("");
                LspFilterTextbox.this.resetView();
            }

            public void mouseDown(MouseEvent e) {
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
    }

    public void diagnostic(String uri, final List<Diagnostic> diagnostics) {
        if (this.fFilterBoxUri.equals(uri)) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    LspFilterTextbox.this.fDiagnostics = diagnostics;
                    if (LspFilterTextbox.this.fDiagnostics.size() > 0) {
                        LspFilterTextbox.this.updateView();
                        LspFilterTextbox.this.fIsValidString = false;
                        LspFilterTextbox.this.notifyInvalid();
                        LspFilterTextbox.this.addErrorPopup();
                    } else {
                        LspFilterTextbox.this.fToolTip.deactivate();
                        LspFilterTextbox.this.fIsValidString = true;
                    }
                }
            });
        }
    }

    public void completion(String uri, Either<List<CompletionItem>, CompletionList> completion) {
        if (this.fFilterBoxUri.equals(uri)) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                }
            });
        }
    }

    public void syntaxHighlighting(String uri, final List<ColorInformation> colors) {
        if (this.fFilterBoxUri.equals(uri)) {
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    LspFilterTextbox.this.fColors = colors;
                    LspFilterTextbox.this.updateView();
                }
            });
        }
    }

    private void notifyLspClient(String message) {
        if (message.isEmpty()) {
            this.resetView();
        } else if (this.fLspClient != null) {
            this.fLspClient.notify(this.fFilterBoxUri, message, this.fFilterStyledText.getCaretOffset());
        }
    }

    private void resetView() {
        this.fFilterStyledText.setBackground(this.fDefaultFilterBackgroundColor);
    }

    private void addErrorPopup() {
        this.fToolTip.activate();
        Object toolTipText = "";
        int index = 0;
        for (Diagnostic diagnostic : this.fDiagnostics) {
            int start = diagnostic.getRange().getStart().getCharacter() + 1;
            toolTipText = (String)toolTipText + "Error at character " + start + " : " + diagnostic.getMessage();
            if (++index >= this.fDiagnostics.size()) continue;
            toolTipText = (String)toolTipText + "\n";
        }
        this.fToolTip.setText((String)toolTipText);
    }

    private void updateView() {
        int index = 0;
        while (index < this.fFilterStyledText.getText().length()) {
            Color foregroundColor = this.getColor(index);
            Boolean hasError = this.indexIsError(index);
            this.updateViewBetween(index, index + 1, foregroundColor, hasError);
            ++index;
        }
    }

    private void updateViewBetween(int start, int end, Color foregroundColor, Boolean hasError) {
        StyleRange styleRange = new StyleRange();
        styleRange.start = start;
        styleRange.length = end - start;
        styleRange.foreground = foregroundColor;
        if (hasError.booleanValue()) {
            styleRange.underline = true;
            styleRange.underlineColor = Display.getCurrent().getSystemColor(3);
        }
        this.fFilterStyledText.setStyleRange(styleRange);
    }

    private boolean indexIsError(int index) {
        for (Diagnostic diagnostic : this.fDiagnostics) {
            int start = diagnostic.getRange().getStart().getCharacter();
            int end = diagnostic.getRange().getEnd().getCharacter() - 1;
            if (index < start || index > end) continue;
            return true;
        }
        return false;
    }

    private Color getColor(int index) {
        for (ColorInformation colorInformation : this.fColors) {
            int start = colorInformation.getRange().getStart().getCharacter();
            int end = colorInformation.getRange().getEnd().getCharacter();
            if (index < start || index > end) continue;
            Display device = Display.getCurrent();
            Color color = new Color((Device)device, (int)(colorInformation.getColor().getRed() * 255.0), (int)(colorInformation.getColor().getGreen() * 255.0), (int)(colorInformation.getColor().getBlue() * 255.0));
            return color;
        }
        return this.fDefaultFilterTextColor;
    }
}

