/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core;

import java.io.PrintStream;
import org.eclipse.cdt.core.IPositionConverter;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

public class PositionTracker
implements IPositionConverter {
    private static final int MEMORY_SIZE = 48;
    private static final int NODE_MEMORY_SIZE = 32;
    private Node fAboveRoot = new Node(0, 0, 0);
    private PositionTracker fFollowedBy = null;
    private long fTimeStamp;

    public synchronized void clear() {
        this.fAboveRoot = new Node(0, 0, 0);
        this.fFollowedBy = null;
    }

    synchronized void revive() {
        this.fFollowedBy = null;
    }

    public synchronized void insert(int offset, int count) {
        assert (this.fFollowedBy == null);
        assert (offset >= 0);
        if (count == 0 || offset < 0) {
            return;
        }
        this.fAboveRoot.addChars(offset, count, 0);
    }

    public synchronized void delete(int offset, int count) {
        assert (this.fFollowedBy == null);
        assert (offset >= 0);
        if (count < 0) {
            this.delete(offset + count, -count);
        } else {
            if (count == 0 || offset < 0) {
                return;
            }
            this.fAboveRoot.removeChars(offset, count, 0, true);
        }
    }

    public synchronized int historicOffset(int currentOffset) {
        return this.historicOffset(currentOffset, true);
    }

    private synchronized int historicOffset(int currentOffset, boolean nextOnDelete) {
        int orig = currentOffset;
        if (this.fFollowedBy != null) {
            orig = this.fFollowedBy.historicOffset(orig, nextOnDelete);
        }
        orig = this.fAboveRoot.calculateOriginalOffset(orig, 0, nextOnDelete);
        return orig;
    }

    public synchronized int currentOffset(int historicOffset) {
        return this.currentOffset(historicOffset, true);
    }

    private synchronized int currentOffset(int historicOffset, boolean nextOnDelete) {
        int current = this.fAboveRoot.calculateCurrentOffset(historicOffset, 0, nextOnDelete);
        if (this.fFollowedBy != null) {
            current = this.fFollowedBy.currentOffset(current, nextOnDelete);
        }
        return current;
    }

    public synchronized void retire(PositionTracker inFavourOf) {
        assert (this.fFollowedBy == null);
        this.fFollowedBy = inFavourOf;
    }

    public synchronized void print(PrintStream out) {
        this.fAboveRoot.print(0, out, 0);
    }

    public synchronized int depth() {
        return this.fAboveRoot.depth() - 1;
    }

    public synchronized boolean isModified() {
        return this.fAboveRoot.fLeft != null || this.fAboveRoot.fRight != null;
    }

    public synchronized long getTimeStamp() {
        return this.fTimeStamp;
    }

    public synchronized void setTimeStamp(long timeStamp) {
        this.fTimeStamp = timeStamp;
    }

    public synchronized long getRetiredTimeStamp() {
        if (this.fFollowedBy == null) {
            return Long.MAX_VALUE;
        }
        return this.fFollowedBy.getTimeStamp();
    }

    public synchronized int getMemorySize() {
        return 48 + 32 * this.countNodes();
    }

    private synchronized int countNodes() {
        return this.fAboveRoot.countNodes();
    }

    @Override
    public synchronized IRegion actualToHistoric(IRegion actualPosition) {
        int actual = actualPosition.getOffset();
        int len = actualPosition.getLength();
        int historic = this.historicOffset(actual, true);
        if (len > 0) {
            len = this.historicOffset(actual + len - 1, false) - historic + 1;
        }
        assert (len >= 0);
        return new Region(historic, len);
    }

    @Override
    public synchronized IRegion historicToActual(IRegion historicPosition) {
        int historic = historicPosition.getOffset();
        int len = historicPosition.getLength();
        int actual = this.currentOffset(historic, true);
        if (len > 0) {
            len = this.currentOffset(historic + len - 1, false) - actual + 1;
        }
        assert (len >= 0);
        return new Region(actual, len);
    }

    private static class Node {
        private static final boolean RED = true;
        private static final boolean BLACK = false;
        private int fDeltaPos2;
        private int fPos1;
        private int fChange;
        private boolean fColor;
        private Node fLeft;
        private Node fRight;
        private Node fParent;

        Node(int pos1, int deltaPos2, int change) {
            this.fDeltaPos2 = deltaPos2;
            this.fPos1 = pos1;
            this.fChange = change;
            this.fParent = null;
            this.fRight = null;
            this.fLeft = null;
            this.fColor = true;
        }

        int depth() {
            if (this.fLeft == null) {
                if (this.fRight == null) {
                    return 1;
                }
                return this.fRight.depth() + 1;
            }
            if (this.fRight == null) {
                return this.fLeft.depth() + 1;
            }
            return StrictMath.max(this.fLeft.depth(), this.fRight.depth()) + 1;
        }

        int calculateCurrentOffset(int value1, int parentPos2, boolean nextOnDelete) {
            int fPos2 = parentPos2 + this.fDeltaPos2;
            int rel1 = value1 - this.fPos1;
            if (rel1 < 0) {
                if (this.fLeft != null) {
                    return this.fLeft.calculateCurrentOffset(value1, fPos2, nextOnDelete);
                }
                return rel1 + fPos2;
            }
            if (rel1 < -this.fChange) {
                return nextOnDelete ? fPos2 : fPos2 - 1;
            }
            if (this.fRight != null) {
                return this.fRight.calculateCurrentOffset(value1, fPos2, nextOnDelete);
            }
            return rel1 + fPos2 + this.fChange;
        }

        int calculateOriginalOffset(int value2, int parentPos2, boolean nextOnDelete) {
            int fPos2 = parentPos2 + this.fDeltaPos2;
            int rel2 = value2 - fPos2;
            if (rel2 < 0) {
                if (this.fLeft != null) {
                    return this.fLeft.calculateOriginalOffset(value2, fPos2, nextOnDelete);
                }
                return rel2 + this.fPos1;
            }
            if (rel2 < this.fChange) {
                return nextOnDelete ? this.fPos1 : this.fPos1 - 1;
            }
            if (this.fRight != null) {
                return this.fRight.calculateOriginalOffset(value2, fPos2, nextOnDelete);
            }
            return rel2 + this.fPos1 - this.fChange;
        }

        void addChars(int value2, int add, int fPos2) {
            int range2;
            int rel2 = value2 - fPos2;
            if (this.fParent != null) {
                this.fParent.balance();
            }
            if (rel2 < 0) {
                this.fDeltaPos2 += add;
                if (this.fLeft != null) {
                    int childPos2 = fPos2 + this.fLeft.fDeltaPos2;
                    this.fLeft.fDeltaPos2 -= add;
                    this.fLeft.addChars(value2, add, childPos2);
                    return;
                }
                this.addLeft(rel2 + this.fPos1, rel2 - add, add);
                return;
            }
            int n = range2 = this.fChange > 0 ? this.fChange : 0;
            if (rel2 <= range2 && !this.isHolder()) {
                this.fChange += add;
                if (this.fChange <= 0) {
                    this.fPos1 += add;
                    this.fDeltaPos2 += add;
                    if (this.fLeft != null) {
                        this.fLeft.fDeltaPos2 -= add;
                    }
                } else if (this.fRight != null) {
                    this.fRight.fDeltaPos2 += add;
                }
                return;
            }
            if (this.fRight != null) {
                this.fRight.addChars(value2, add, fPos2 + this.fRight.fDeltaPos2);
                return;
            }
            this.addRight(rel2 + this.fPos1 - this.fChange, rel2, add);
        }

        boolean removeChars(int firstChar2, int remove, int fPos2, boolean mustRemove) {
            int delBelow;
            int range2;
            int relFirstChar2 = firstChar2 - fPos2;
            int relAfterLastChar2 = relFirstChar2 + remove;
            if (mustRemove && this.fParent != null) {
                this.fParent.balance();
            }
            if (relAfterLastChar2 < 0) {
                this.fDeltaPos2 -= remove;
                if (this.fLeft != null) {
                    this.fLeft.fDeltaPos2 += remove;
                    return this.fLeft.removeChars(firstChar2, remove, fPos2 - remove + this.fLeft.fDeltaPos2, mustRemove);
                }
                if (mustRemove) {
                    this.addLeft(relFirstChar2 + this.fPos1, relFirstChar2 + remove, -remove);
                    return true;
                }
                return false;
            }
            int n = range2 = this.fChange > 0 ? this.fChange : 0;
            if (relFirstChar2 > range2 || this.isHolder()) {
                if (this.fRight != null) {
                    this.fRight.removeChars(firstChar2, remove, fPos2 + this.fRight.fDeltaPos2, mustRemove);
                    return true;
                }
                if (mustRemove) {
                    this.addRight(relFirstChar2 + this.fPos1 - this.fChange, relFirstChar2, -remove);
                    return true;
                }
                return false;
            }
            int delAbove = 0;
            if (relFirstChar2 < 0) {
                delAbove = -relFirstChar2;
            }
            if ((delBelow = relAfterLastChar2 - range2) < 0) {
                delBelow = 0;
            }
            int delInside = remove - delAbove - delBelow;
            if (delAbove > 0 && this.fLeft != null && this.fLeft.removeChars(firstChar2, delAbove, fPos2 + this.fLeft.fDeltaPos2, false)) {
                this.fDeltaPos2 -= delAbove;
                this.fLeft.fDeltaPos2 += delAbove;
                fPos2 -= delAbove;
                delAbove = 0;
            }
            if (delBelow > 0 && this.fRight != null && this.fRight.removeChars(fPos2 + range2, delBelow, fPos2 + this.fRight.fDeltaPos2, false)) {
                delBelow = 0;
            }
            this.fChange -= delAbove + delInside + delBelow;
            this.fDeltaPos2 -= delAbove;
            this.fPos1 -= delAbove;
            assert (this.fPos1 >= 0);
            if (this.fLeft != null) {
                this.fLeft.fDeltaPos2 += delAbove;
            }
            if (this.fRight != null) {
                this.fRight.fDeltaPos2 -= delInside;
            }
            return true;
        }

        private void balance() {
            if (this.fParent == null) {
                if (this.fRight != null) {
                    this.fRight.fColor = false;
                }
                return;
            }
            Node grandParent = this.fParent.fParent;
            if (this.fLeft == null || this.fRight == null) {
                return;
            }
            if (this.fLeft.isRed() && this.fRight.isRed()) {
                this.fRight.fColor = false;
                this.fLeft.fColor = false;
                if (grandParent != null) {
                    this.fColor = true;
                    if (this.fParent.isRed()) {
                        this.rotateAround(grandParent);
                    }
                }
            }
        }

        private void rotateAround(Node grandParent) {
            if (grandParent.fLeft == this.fParent) {
                this.rotateRightAround(grandParent);
            } else {
                this.rotateLeftAround(grandParent);
            }
        }

        private void rotateRightAround(Node grandParent) {
            if (this.fParent.fLeft == this) {
                grandParent.rotateRight();
                this.fParent.fColor = false;
                this.fParent.fRight.fColor = true;
            } else {
                this.fParent.rotateLeft();
                grandParent.rotateRight();
                this.fColor = false;
                grandParent.fColor = true;
            }
        }

        private void rotateLeftAround(Node grandParent) {
            if (this.fParent.fRight == this) {
                grandParent.rotateLeft();
                this.fParent.fColor = false;
                this.fParent.fLeft.fColor = true;
            } else {
                this.fParent.rotateRight();
                grandParent.rotateLeft();
                this.fColor = false;
                grandParent.fColor = true;
            }
        }

        private void rotateRight() {
            assert (this.fLeft != null);
            Node root = this;
            Node left = this.fLeft;
            Node leftRight = left.fRight;
            int rootAbove = root.fDeltaPos2;
            int aboveLeft = -root.fDeltaPos2 - left.fDeltaPos2;
            int leftRoot = left.fDeltaPos2;
            if (this.fParent.fLeft == this) {
                this.fParent.putLeft(left);
            } else {
                this.fParent.putRight(left);
            }
            left.fDeltaPos2 += rootAbove;
            left.putRight(root);
            root.fDeltaPos2 += aboveLeft;
            root.putLeft(leftRight);
            if (leftRight != null) {
                leftRight.fDeltaPos2 += leftRoot;
            }
        }

        private void rotateLeft() {
            assert (this.fRight != null);
            Node root = this;
            Node right = this.fRight;
            Node rightLeft = right.fLeft;
            int rootAbove = root.fDeltaPos2;
            int parentRight = -root.fDeltaPos2 - right.fDeltaPos2;
            int rightRoot = right.fDeltaPos2;
            if (this.fParent.fRight == this) {
                this.fParent.putRight(right);
            } else {
                this.fParent.putLeft(right);
            }
            right.fDeltaPos2 += rootAbove;
            right.putLeft(root);
            root.fDeltaPos2 += parentRight;
            root.putRight(rightLeft);
            if (rightLeft != null) {
                rightLeft.fDeltaPos2 += rightRoot;
            }
        }

        private boolean isRed() {
            return this.fColor;
        }

        private void putLeft(Node add) {
            this.fLeft = add;
            if (this.fLeft != null) {
                this.fLeft.fParent = this;
            }
        }

        private void putRight(Node add) {
            this.fRight = add;
            if (this.fRight != null) {
                this.fRight.fParent = this;
            }
        }

        private void addLeft(int pos1, int pos2, int change) {
            this.fLeft = new Node(pos1, pos2, change);
            this.fLeft.fParent = this;
            if (this.isHolder()) {
                assert (false);
            } else if (this.isRed()) {
                this.fLeft.rotateAround(this.fParent);
            }
        }

        private boolean isHolder() {
            return this.fParent == null;
        }

        private void addRight(int pos1, int pos2, int change) {
            this.fRight = new Node(pos1, pos2, change);
            this.fRight.fParent = this;
            if (this.isHolder()) {
                this.fRight.fColor = false;
            } else if (this.isRed()) {
                this.fRight.rotateAround(this.fParent);
            }
        }

        public void print(int i, PrintStream out, int parentOffset) {
            parentOffset += this.fDeltaPos2;
            if (this.fRight != null) {
                this.fRight.print(i + 1, out, parentOffset);
            }
            int j = 0;
            while (j < i) {
                out.print("  ");
                ++j;
            }
            out.println(this.fPos1 + "<->" + parentOffset + " : " + this.fChange + (this.fColor ? " // red" : ""));
            if (this.fLeft != null) {
                this.fLeft.print(i + 1, out, parentOffset);
            }
        }

        public int countNodes() {
            int count = 1;
            if (this.fLeft != null) {
                count += this.fLeft.countNodes();
            }
            if (this.fRight != null) {
                count += this.fRight.countNodes();
            }
            return count;
        }
    }
}

