/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.inandout.ui;

import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.incubator.internal.inandout.core.analysis.SegmentSpecifier;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SegmentSpecifierDialog
extends Dialog {
    private final SegmentSpecifier fSegmentSpecifier;
    private boolean[] fValid = new boolean[]{true, true, true, true};
    private @Nullable String fLabel = null;
    private @Nullable String fInRegex = null;
    private @Nullable String fOutRegex = null;
    private @Nullable String fContextInRegex = null;
    private @Nullable String fContextOutRegex = null;
    private @Nullable String fCategory = null;
    private ITmfTrace fRef;
    private boolean fUpdated = false;

    private void setLabel(String value) {
        this.fLabel = value;
    }

    private void setInRegex(String value) {
        try {
            Pattern.compile(value);
            this.fInRegex = value;
            this.fValid[0] = true;
        }
        catch (PatternSyntaxException e) {
            this.fValid[0] = false;
        }
    }

    private void setOutRegex(String value) {
        try {
            Pattern.compile(value);
            this.fOutRegex = value;
            this.fValid[1] = true;
        }
        catch (PatternSyntaxException e) {
            this.fValid[1] = false;
        }
    }

    private void setContextInRegex(String value) {
        try {
            Pattern.compile(value);
            this.fContextInRegex = value;
            this.fValid[2] = true;
        }
        catch (PatternSyntaxException e) {
            this.fValid[2] = false;
        }
    }

    private void setContextOutRegex(String value) {
        try {
            Pattern.compile(value);
            this.fContextOutRegex = value;
            this.fValid[3] = true;
        }
        catch (PatternSyntaxException e) {
            this.fValid[3] = false;
        }
    }

    private void setCategory(String category) {
        this.fCategory = category;
    }

    protected SegmentSpecifierDialog(Shell parentShell, SegmentSpecifier segmentSpecifier, ITmfTrace ref) {
        super(parentShell);
        this.fSegmentSpecifier = segmentSpecifier;
        this.fRef = ref;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Control createDialogArea(Composite parent) {
        if (parent == null || this.fRef == null) {
            return null;
        }
        Shell shell = this.getShell();
        shell.setText("Configure In and Out analysis");
        Composite localParent = (Composite)super.createDialogArea(parent);
        localParent.setLayout((Layout)GridLayoutFactory.fillDefaults().numColumns(2).create());
        localParent.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.createEntry(localParent, "Label", () -> ((SegmentSpecifier)this.fSegmentSpecifier).getLabel(), this::setLabel);
        this.createEntry(localParent, "InRegex", () -> ((SegmentSpecifier)this.fSegmentSpecifier).getInRegex(), this::setInRegex);
        this.createEntry(localParent, "OutRegex", () -> ((SegmentSpecifier)this.fSegmentSpecifier).getOutRegex(), this::setOutRegex);
        this.createEntry(localParent, "ContextIn", () -> ((SegmentSpecifier)this.fSegmentSpecifier).getContextInRegex(), this::setContextInRegex);
        this.createEntry(localParent, "ContextOut", () -> ((SegmentSpecifier)this.fSegmentSpecifier).getContextOutRegex(), this::setContextOutRegex);
        Label label = new Label(localParent, 0);
        label.setText("Classifier");
        label.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        final Combo classifier = new Combo(localParent, 0);
        for (ITmfEventAspect aspect : this.fRef.getEventAspects()) {
            String name = aspect.getName();
            classifier.add(name);
            if (!name.equals(this.fSegmentSpecifier.getClassifierType())) continue;
            classifier.select(classifier.getItemCount() - 1);
        }
        classifier.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = classifier.getSelectionIndex();
                if (index >= 0) {
                    SegmentSpecifierDialog.this.setCategory(classifier.getItems()[index]);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        classifier.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        return localParent;
    }

    private void createEntry(Composite parent, String labelText, Supplier<String> resolver, Consumer<String> setter) {
        Label label = new Label(parent, 0);
        label.setText(labelText);
        label.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        Text text = new Text(parent, 0);
        text.setText(resolver.get());
        text.setLayoutData((Object)GridDataFactory.fillDefaults().hint(-1, 20).grab(true, false).create());
        text.addModifyListener(listener -> {
            setter.accept(text.getText());
            boolean[] blArray = this.fValid;
            int n = this.fValid.length;
            int n2 = 0;
            while (n2 < n) {
                boolean validentry = blArray[n2];
                if (!validentry) {
                    this.getButton(0).setEnabled(false);
                    return;
                }
                ++n2;
            }
            this.getButton(0).setEnabled(true);
        });
    }

    protected void okPressed() {
        this.fUpdated = this.fSegmentSpecifier.setIfNotNull(this.fLabel, this.fInRegex, this.fOutRegex, this.fContextInRegex, this.fContextOutRegex, this.fCategory);
        super.okPressed();
    }

    public boolean isUpdated() {
        return this.fUpdated;
    }
}

