/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.analysis.profiling.core.tree.ITree;
import org.eclipse.tracecompass.analysis.profiling.core.tree.IWeightedTreeSet;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.diff.DifferentialWeightedTree;

public class DifferentialWeightedTreeSet<@NonNull N>
implements IWeightedTreeSet<N, Object, DifferentialWeightedTree<N>> {
    private static final String DEFAULT_ELEMENT = "diff";
    private final Set<Object> fRootElements = new HashSet<Object>();
    private final Multimap<Object, DifferentialWeightedTree<N>> fTrees = HashMultimap.create();

    public static <N> DifferentialWeightedTreeSet<@NonNull N> create(Collection<DifferentialWeightedTree<N>> trees) {
        DifferentialWeightedTreeSet<N> treeSet = new DifferentialWeightedTreeSet<N>();
        for (DifferentialWeightedTree<N> tree : trees) {
            treeSet.addWeightedTree(DEFAULT_ELEMENT, tree);
        }
        return treeSet;
    }

    public Collection<Object> getElements() {
        return this.fRootElements;
    }

    public Collection<@NonNull DifferentialWeightedTree<N>> getTreesFor(Object element) {
        return Objects.requireNonNull(this.fTrees.get(element));
    }

    public void addWeightedTree(Object dstGroup, DifferentialWeightedTree<N> tree) {
        Object root = dstGroup;
        if (dstGroup instanceof ITree) {
            ITree parent = ((ITree)dstGroup).getParent();
            while (parent != null) {
                root = parent;
                parent = parent.getParent();
            }
            this.fRootElements.add(root);
        }
        this.fRootElements.add(root);
        Collection trees = this.fTrees.get(dstGroup);
        for (DifferentialWeightedTree currentTree : trees) {
            if (!currentTree.getObject().equals(tree.getObject())) continue;
            currentTree.merge(tree);
            return;
        }
        this.fTrees.put(dstGroup, tree);
    }
}

