/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.jsdt.core.IBuffer;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ILocalVariable;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.WorkingCopyOwner;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.SourceRange;
import org.eclipse.wst.jsdt.internal.core.SourceRefElement;
import org.eclipse.wst.jsdt.internal.core.util.MementoTokenizer;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class LocalVariable
extends SourceRefElement
implements ILocalVariable {
    String name;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int nameStart;
    public int nameEnd;
    String typeSignature;

    public LocalVariable(JavaElement parent, String name, int declarationSourceStart, int declarationSourceEnd, int nameStart, int nameEnd, String typeSignature) {
        super(parent);
        this.name = name;
        this.declarationSourceStart = declarationSourceStart;
        this.declarationSourceEnd = declarationSourceEnd;
        this.nameStart = nameStart;
        this.nameEnd = nameEnd;
        this.typeSignature = typeSignature;
    }

    @Override
    protected void closing(Object info) {
    }

    @Override
    protected Object createElementInfo() {
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LocalVariable)) {
            return false;
        }
        LocalVariable other = (LocalVariable)o;
        return this.declarationSourceStart == other.declarationSourceStart && this.declarationSourceEnd == other.declarationSourceEnd && this.nameStart == other.nameStart && this.nameEnd == other.nameEnd && super.equals(o);
    }

    @Override
    public boolean exists() {
        return this.parent.exists();
    }

    @Override
    protected void generateInfos(Object info, HashMap newElements, IProgressMonitor pm) {
    }

    @Override
    public IJavaScriptElement getHandleFromMemento(String token, MementoTokenizer memento, WorkingCopyOwner owner) {
        switch (token.charAt(0)) {
            case '!': {
                return this.getHandleUpdatingCountFromMemento(memento, owner);
            }
        }
        return this;
    }

    @Override
    protected void getHandleMemento(StringBuffer buff) {
        ((JavaElement)this.getParent()).getHandleMemento(buff);
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.name);
        buff.append('!');
        buff.append(this.declarationSourceStart);
        buff.append('!');
        buff.append(this.declarationSourceEnd);
        buff.append('!');
        buff.append(this.nameStart);
        buff.append('!');
        buff.append(this.nameEnd);
        buff.append('!');
        buff.append(this.typeSignature);
        if (this.occurrenceCount > 1) {
            buff.append('!');
            buff.append(this.occurrenceCount);
        }
    }

    @Override
    protected char getHandleMementoDelimiter() {
        return '@';
    }

    @Override
    public IResource getCorrespondingResource() {
        return null;
    }

    @Override
    public String getElementName() {
        return this.name;
    }

    @Override
    public int getElementType() {
        return 14;
    }

    @Override
    public ISourceRange getNameRange() {
        return new SourceRange(this.nameStart, this.nameEnd - this.nameStart + 1);
    }

    @Override
    public IPath getPath() {
        return this.parent.getPath();
    }

    @Override
    public IResource getResource() {
        return this.parent.getResource();
    }

    @Override
    public String getSource() throws JavaScriptModelException {
        IOpenable openable = this.parent.getOpenableParent();
        IBuffer buffer = openable.getBuffer();
        if (buffer == null) {
            return null;
        }
        ISourceRange range = this.getSourceRange();
        int offset = range.getOffset();
        int length = range.getLength();
        if (offset == -1 || length == 0) {
            return null;
        }
        try {
            return buffer.getText(offset, length);
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    @Override
    public ISourceRange getSourceRange() {
        return new SourceRange(this.declarationSourceStart, this.declarationSourceEnd - this.declarationSourceStart + 1);
    }

    @Override
    public String getTypeSignature() {
        return this.typeSignature;
    }

    @Override
    public IResource getUnderlyingResource() throws JavaScriptModelException {
        return this.parent.getUnderlyingResource();
    }

    @Override
    public int hashCode() {
        return Util.combineHashCodes(this.parent.hashCode(), this.nameStart);
    }

    @Override
    public boolean isStructureKnown() throws JavaScriptModelException {
        return true;
    }

    @Override
    protected void toStringInfo(int tab, StringBuffer buffer, Object info, boolean showResolvedInfo) {
        buffer.append(this.tabString(tab));
        if (info != NO_INFO) {
            buffer.append(Signature.toString(this.getTypeSignature()));
            buffer.append(" ");
        }
        this.toStringName(buffer);
    }
}

