/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.ui.internal.selection;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.texteditor.ITextEditor;

public class SelectionHistory {
    private ITextEditor fEditor;
    private List<IRegion> fHistory;
    private List<IAction> fHistoryActions;
    private int fSelectionChangeListenerCounter;
    private ISelectionChangedListener fSelectionListener;

    public SelectionHistory(ITextEditor editor) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fHistory = new ArrayList<IRegion>(3);
        this.fSelectionListener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (SelectionHistory.this.fSelectionChangeListenerCounter == 0) {
                    SelectionHistory.this.flush();
                }
            }
        };
        this.fEditor.getSelectionProvider().addSelectionChangedListener(this.fSelectionListener);
    }

    public void dispose() {
        this.fEditor.getSelectionProvider().removeSelectionChangedListener(this.fSelectionListener);
        this.fEditor = null;
        if (this.fHistory != null && !this.fHistory.isEmpty()) {
            this.fHistory.clear();
        }
        if (this.fHistoryActions != null && !this.fHistoryActions.isEmpty()) {
            this.fHistoryActions.clear();
        }
    }

    public void flush() {
        if (this.fHistory.isEmpty()) {
            return;
        }
        this.fHistory.clear();
        this.updateHistoryAction();
    }

    public IRegion getLast() {
        if (this.isEmpty()) {
            return null;
        }
        int size = this.fHistory.size();
        IRegion result = this.fHistory.remove(size - 1);
        this.updateHistoryAction();
        return result;
    }

    public void ignoreSelectionChanges() {
        ++this.fSelectionChangeListenerCounter;
    }

    public boolean isEmpty() {
        return this.fHistory.isEmpty();
    }

    public void listenToSelectionChanges() {
        --this.fSelectionChangeListenerCounter;
    }

    public void remember(IRegion region) {
        this.fHistory.add(region);
        this.updateHistoryAction();
    }

    public void setHistoryAction(IAction action) {
        Assert.isNotNull((Object)action);
        if (this.fHistoryActions == null) {
            this.fHistoryActions = new ArrayList<IAction>();
        }
        if (!this.fHistoryActions.contains(action)) {
            this.fHistoryActions.add(action);
        }
        if (this.fHistory != null && !this.fHistory.isEmpty()) {
            action.setEnabled(true);
        } else {
            action.setEnabled(false);
        }
    }

    private void updateHistoryAction() {
        if (this.fHistoryActions != null && !this.fHistoryActions.isEmpty()) {
            boolean enabled = false;
            if (this.fHistory != null && !this.fHistory.isEmpty()) {
                enabled = true;
            }
            Iterator<IAction> iter = this.fHistoryActions.iterator();
            while (iter.hasNext()) {
                iter.next().setEnabled(enabled);
            }
        }
    }
}

