/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.beans.property;

import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import org.eclipse.gef4.common.beans.property.ReadOnlyMultisetProperty;
import org.eclipse.gef4.common.beans.value.WritableMultisetValue;
import org.eclipse.gef4.common.collections.CollectionUtils;
import org.eclipse.gef4.common.collections.ObservableMultiset;

public abstract class MultisetProperty<E>
extends ReadOnlyMultisetProperty<E>
implements Property<ObservableMultiset<E>>,
WritableMultisetValue<E> {
    public void bindBidirectional(Property<ObservableMultiset<E>> other) {
        try {
            Bindings.bindBidirectional((Property)this, other);
        }
        catch (IllegalArgumentException e) {
            if ("Cannot bind property to itself".equals(e.getMessage()) && this != other) {
                if (other.getValue() == null) {
                    if (this.getValue() == null) {
                        this.setValue(CollectionUtils.observableHashMultiset());
                    }
                } else if (this.getValue().equals(other)) {
                    this.setValue(null);
                }
                Bindings.bindBidirectional((Property)this, other);
            }
            throw e;
        }
    }

    public void setValue(ObservableMultiset<E> v) {
        this.set(v);
    }

    public void unbindBidirectional(Property<ObservableMultiset<E>> other) {
        try {
            Bindings.unbindBidirectional((Property)this, other);
        }
        catch (IllegalArgumentException e) {
            if ("Cannot bind property to itself".equals(e.getMessage()) && this != other) {
                Object oldValue = this.getValue();
                if (other.getValue() == null) {
                    this.setValue(CollectionUtils.observableHashMultiset());
                } else {
                    this.setValue(null);
                }
                Bindings.unbindBidirectional((Property)this, other);
                this.setValue((ObservableMultiset<E>)oldValue);
            }
            throw e;
        }
    }
}

