/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.eclipse.gef4.common.beans.property.ReadOnlyListWrapperEx;
import org.eclipse.gef4.common.beans.property.ReadOnlySetMultimapProperty;
import org.eclipse.gef4.common.beans.property.ReadOnlySetMultimapWrapper;
import org.eclipse.gef4.common.collections.CollectionUtils;
import org.eclipse.gef4.common.collections.ObservableSetMultimap;
import org.eclipse.gef4.common.reflect.Types;
import org.eclipse.gef4.mvc.behaviors.ContentBehavior;
import org.eclipse.gef4.mvc.parts.AbstractVisualPart;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public abstract class AbstractContentPart<VR, V extends VR>
extends AbstractVisualPart<VR, V>
implements IContentPart<VR, V> {
    private final ObjectProperty<Object> contentProperty = new SimpleObjectProperty((Object)this, "content");
    private ObservableList<Object> contentChildren = CollectionUtils.observableArrayList();
    private ObservableList<Object> contentChildrenUnmodifiable;
    private ReadOnlyListWrapper<Object> contentChildrenUnmodifiableProperty;
    private ObservableSetMultimap<Object, String> contentAnchorages = CollectionUtils.observableHashMultimap();
    private ObservableSetMultimap<Object, String> contentAnchoragesUnmodifiable;
    private ReadOnlySetMultimapWrapper<Object, String> contentAnchoragesUnmodifiableProperty;

    public AbstractContentPart() {
        this.contentProperty.addListener((ChangeListener)new ChangeListener<Object>(){

            public void changed(ObservableValue<? extends Object> observable, Object oldValue, Object newValue) {
                AbstractContentPart.this.onContentChanged(oldValue, newValue);
            }
        });
    }

    @Override
    public final void addContentChild(Object contentChild, int index) {
        ArrayList<Object> oldContentChildren = new ArrayList<Object>(this.doGetContentChildren());
        if (oldContentChildren.contains(contentChild)) {
            int oldIndex = oldContentChildren.indexOf(contentChild);
            if (oldIndex == index) {
                throw new IllegalArgumentException("Cannot add " + contentChild + " because its already contained at given index " + index);
            }
            throw new IllegalArgumentException("Cannot add " + contentChild + " because its already a content child at index " + oldIndex);
        }
        this.doAddContentChild(contentChild, index);
        List<Object> newContentChildren = this.doGetContentChildren();
        if (!newContentChildren.contains(contentChild)) {
            throw new IllegalStateException("doAddContentChild(Object, int) did not add content child " + contentChild + " .");
        }
        int newIndex = newContentChildren.indexOf(contentChild);
        if (newIndex != index) {
            throw new IllegalStateException("doAddContentChild(Object, int) did not add content child " + contentChild + " at index " + index + ", but at index " + newIndex + ".");
        }
        this.contentChildren.setAll(newContentChildren);
    }

    @Override
    public final void attachToContentAnchorage(Object contentAnchorage, String role) {
        HashMultimap oldContentAnchorages = HashMultimap.create(this.doGetContentAnchorages());
        if (oldContentAnchorages.containsEntry(contentAnchorage, (Object)role)) {
            throw new IllegalArgumentException("Already attached to anchorage " + contentAnchorage + " in role '" + role + "'.");
        }
        this.doAttachToContentAnchorage(contentAnchorage, role);
        HashMultimap newContentAnchorages = HashMultimap.create(this.doGetContentAnchorages());
        if (!newContentAnchorages.containsEntry(contentAnchorage, (Object)role)) {
            throw new IllegalArgumentException("doAttachToContentAnchorage did not properly attach to " + contentAnchorage + " with role '" + role + "'.");
        }
        for (Object key : oldContentAnchorages.keySet()) {
            if (newContentAnchorages.containsKey(key)) {
                this.contentAnchorages.replaceValues(key, (Iterable)newContentAnchorages.get(key));
                continue;
            }
            this.contentAnchorages.removeAll(key);
        }
        for (Object key : newContentAnchorages.keySet()) {
            if (oldContentAnchorages.containsKey(key)) continue;
            this.contentAnchorages.putAll(key, (Iterable)newContentAnchorages.get(key));
        }
    }

    @Override
    public ReadOnlySetMultimapProperty<Object, String> contentAnchoragesUnmodifiableProperty() {
        if (this.contentAnchoragesUnmodifiableProperty == null) {
            this.contentAnchoragesUnmodifiableProperty = new ReadOnlySetMultimapWrapper((Object)this, "contentAnchorages", this.getContentAnchoragesUnmodifiable());
        }
        return this.contentAnchoragesUnmodifiableProperty.getReadOnlyProperty();
    }

    @Override
    public ReadOnlyListProperty<Object> contentChildrenUnmodifiableProperty() {
        if (this.contentChildrenUnmodifiableProperty == null) {
            this.contentChildrenUnmodifiableProperty = new ReadOnlyListWrapperEx((Object)this, "contentChildren", this.getContentChildrenUnmodifiable());
        }
        return this.contentChildrenUnmodifiableProperty.getReadOnlyProperty();
    }

    @Override
    public final ObjectProperty<Object> contentProperty() {
        return this.contentProperty;
    }

    @Override
    public final void detachFromContentAnchorage(Object contentAnchorage, String role) {
        HashMultimap oldContentAnchorages = HashMultimap.create(this.doGetContentAnchorages());
        if (!oldContentAnchorages.containsEntry(contentAnchorage, (Object)role)) {
            throw new IllegalArgumentException("Not attached to content anchorage " + contentAnchorage + " with role '" + role + "'.");
        }
        this.doDetachFromContentAnchorage(contentAnchorage, role);
        HashMultimap newContentAnchorages = HashMultimap.create(this.doGetContentAnchorages());
        if (newContentAnchorages.containsEntry(contentAnchorage, (Object)role)) {
            throw new IllegalArgumentException("doDetachFromContentAnchorage did not properly detach from " + contentAnchorage + " with role '" + role + "'.");
        }
        for (Object key : oldContentAnchorages.keySet()) {
            if (newContentAnchorages.containsKey(key)) {
                this.contentAnchorages.replaceValues(key, (Iterable)newContentAnchorages.get(key));
                continue;
            }
            this.contentAnchorages.removeAll(key);
        }
        for (Object key : newContentAnchorages.keySet()) {
            if (oldContentAnchorages.containsKey(key)) continue;
            this.contentAnchorages.putAll(key, (Iterable)newContentAnchorages.get(key));
        }
    }

    protected void doAddContentChild(Object contentChild, int index) {
        throw new UnsupportedOperationException("Need to implement doAddContentChild(Object, int) for " + this.getClass());
    }

    protected void doAttachToContentAnchorage(Object contentAnchorage, String role) {
        throw new UnsupportedOperationException("Need to implement doAttachContentChild(Object, String) for " + this.getClass());
    }

    protected void doDetachFromContentAnchorage(Object contentAnchorage, String role) {
        throw new UnsupportedOperationException("Need to implement doDetachContentChild(Object, String) for " + this.getClass());
    }

    protected abstract SetMultimap<? extends Object, String> doGetContentAnchorages();

    protected abstract List<? extends Object> doGetContentChildren();

    protected void doRemoveContentChild(Object contentChild) {
        throw new UnsupportedOperationException("Need to implement doRemoveContentChild(Object, int) for " + this.getClass());
    }

    protected void doReorderContentChild(Object contentChild, int newIndex) {
        throw new UnsupportedOperationException("Need to implement doReorderContentChild(Object, int) for " + this.getClass());
    }

    @Override
    public Object getContent() {
        return this.contentProperty.get();
    }

    @Override
    public ObservableSetMultimap<Object, String> getContentAnchoragesUnmodifiable() {
        if (this.contentAnchoragesUnmodifiable == null) {
            this.contentAnchoragesUnmodifiable = CollectionUtils.unmodifiableObservableSetMultimap(this.contentAnchorages);
        }
        return this.contentAnchoragesUnmodifiable;
    }

    @Override
    public ObservableList<Object> getContentChildrenUnmodifiable() {
        if (this.contentChildrenUnmodifiable == null) {
            this.contentChildrenUnmodifiable = FXCollections.unmodifiableObservableList(this.contentChildren);
        }
        return this.contentChildrenUnmodifiable;
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    @Override
    public boolean isSelectable() {
        return true;
    }

    protected void onContentChanged(Object oldContent, Object newContent) {
        if (oldContent != null && oldContent != newContent) {
            if (this.getViewer() != null) {
                this.unregisterFromContentPartMap(this.getViewer(), oldContent);
            }
            if (newContent == null) {
                this.contentChildren.clear();
                this.contentAnchorages.clear();
            }
        }
        if (newContent != null && newContent != oldContent) {
            if (this.getViewer() != null) {
                this.registerAtContentPartMap(this.getViewer(), newContent);
            }
            this.contentChildren.setAll(this.doGetContentChildren());
            this.contentAnchorages.replaceAll(this.doGetContentAnchorages());
        }
    }

    @Override
    public void refreshContentAnchorages() {
        this.contentAnchorages.replaceAll(this.doGetContentAnchorages());
    }

    @Override
    public void refreshContentChildren() {
        this.contentChildren.setAll(this.doGetContentChildren());
    }

    @Override
    protected void register(IViewer<VR> viewer) {
        super.register(viewer);
        if (this.contentProperty.get() != null) {
            this.registerAtContentPartMap(viewer, this.contentProperty.get());
        }
    }

    protected void registerAtContentPartMap(IViewer<VR> viewer, Object content) {
        viewer.getContentPartMap().put(content, this);
    }

    @Override
    public final void removeContentChild(Object contentChild) {
        ArrayList<Object> oldContentChildren = new ArrayList<Object>(this.doGetContentChildren());
        if (!oldContentChildren.contains(contentChild)) {
            throw new IllegalArgumentException("Cannot remove " + contentChild + " because its not a content child.");
        }
        this.doRemoveContentChild(contentChild);
        List<Object> newContentChildren = this.doGetContentChildren();
        if (newContentChildren.contains(contentChild)) {
            throw new IllegalStateException("doRemoveContentChild(Object, int) did not remove content child " + contentChild + " .");
        }
        this.contentChildren.setAll(newContentChildren);
    }

    @Override
    public void reorderContentChild(Object contentChild, int newIndex) {
        ArrayList<Object> oldContentChildren = new ArrayList<Object>(this.doGetContentChildren());
        if (oldContentChildren.contains(contentChild)) {
            throw new IllegalArgumentException("Cannot reorder " + contentChild + " because its not a content child.");
        }
        if (oldContentChildren.indexOf(contentChild) == newIndex) {
            throw new IllegalArgumentException("Cannot reorder " + contentChild + " to given index + " + newIndex + ", because its already there.");
        }
        this.doReorderContentChild(contentChild, newIndex);
        List<Object> newContentChildren = this.doGetContentChildren();
        if (newContentChildren.indexOf(contentChild) != newIndex) {
            throw new IllegalStateException("doReorderContentChild(Object, int) did not reorder content child " + contentChild + " to index " + newIndex + ".");
        }
        this.contentChildren.setAll(newContentChildren);
    }

    @Override
    public void setContent(Object content) {
        this.contentProperty.set(content);
    }

    @Override
    protected void unregister(IViewer<VR> viewer) {
        ContentBehavior contentBehavior = (ContentBehavior)this.getAdapter(new TypeToken<ContentBehavior<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(viewer.getClass())));
        if (contentBehavior != null) {
            contentBehavior.synchronizeContentChildren(Collections.emptyList());
            contentBehavior.synchronizeContentAnchorages((SetMultimap<Object, String>)HashMultimap.create());
        }
        super.unregister(viewer);
        if (this.getContent() != null) {
            this.unregisterFromContentPartMap(viewer, this.getContent());
        }
    }

    protected void unregisterFromContentPartMap(IViewer<VR> viewer, Object content) {
        Map<Object, IContentPart<VR, VR>> registry = viewer.getContentPartMap();
        if (registry.get(content) != this) {
            throw new IllegalArgumentException("Not registered under content");
        }
        registry.remove(content);
    }
}

