/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.behaviors;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.Collections;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.reflect.Types;
import org.eclipse.gef4.mvc.behaviors.AbstractBehavior;
import org.eclipse.gef4.mvc.models.HoverModel;
import org.eclipse.gef4.mvc.parts.IFeedbackPartFactory;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class HoverBehavior<VR>
extends AbstractBehavior<VR> {
    public static final String HOVER_FEEDBACK_PART_FACTORY = "HOVER_FEEDBACK_PART_FACTORY";
    public static final String HOVER_HANDLE_PART_FACTORY = "HOVER_HANDLE_PART_FACTORY";
    private ChangeListener<IVisualPart<VR, ? extends VR>> hoverObserver = new ChangeListener<IVisualPart<VR, ? extends VR>>(){

        public void changed(ObservableValue<? extends IVisualPart<VR, ? extends VR>> observable, IVisualPart<VR, ? extends VR> oldValue, IVisualPart<VR, ? extends VR> newValue) {
            HoverBehavior.this.onHoverChange(oldValue, newValue);
        }
    };

    @Override
    protected void doActivate() {
        HoverModel<VR> hoverModel = this.getHoverModel();
        hoverModel.hoverProperty().addListener(this.hoverObserver);
        IVisualPart<VR, VR> hover = hoverModel.getHover();
        if (hover != null) {
            this.onHoverChange(null, hover);
        }
    }

    @Override
    protected void doDeactivate() {
        HoverModel<VR> hoverModel = this.getHoverModel();
        IVisualPart<VR, VR> hover = hoverModel.getHover();
        if (hover != null) {
            this.onHoverChange(hover, null);
        }
        hoverModel.hoverProperty().removeListener(this.hoverObserver);
    }

    protected IFeedbackPartFactory<VR> getFeedbackPartFactory() {
        IViewer viewer = this.getHost().getRoot().getViewer();
        return (IFeedbackPartFactory)viewer.getAdapter(AdapterKey.get((TypeToken)new TypeToken<IFeedbackPartFactory<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(viewer.getClass())), (String)HOVER_FEEDBACK_PART_FACTORY));
    }

    protected HoverModel<VR> getHoverModel() {
        IViewer viewer = this.getHost().getRoot().getViewer();
        HoverModel hoverModel = (HoverModel)viewer.getAdapter(new TypeToken<HoverModel<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(viewer.getClass())));
        return hoverModel;
    }

    protected void onHoverChange(IVisualPart<VR, ? extends VR> oldHovered, IVisualPart<VR, ? extends VR> newHovered) {
        if (this.getHost() != oldHovered && this.getHost() == newHovered) {
            this.switchAdaptableScopes();
            List targets = Collections.singletonList(this.getHost());
            this.addFeedback(targets, this.getFeedbackPartFactory().createFeedbackParts(targets, this, Collections.emptyMap()));
        } else if (this.getHost() == oldHovered && this.getHost() != newHovered) {
            this.removeFeedback(Collections.singletonList(this.getHost()));
        }
    }
}

