/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.operations;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.common.reflect.Types;
import org.eclipse.gef4.mvc.models.SelectionModel;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.viewer.IViewer;

public class DeselectOperation<VR>
extends AbstractOperation
implements ITransactionalOperation {
    public static final String DEFAULT_LABEL = "Deselect";
    private IViewer<VR> viewer;
    private List<IContentPart<VR, ? extends VR>> initialSelection;
    private List<IContentPart<VR, ? extends VR>> toBeDeselected;
    private ArrayList<IContentPart<VR, ? extends VR>> deselected;

    public DeselectOperation(IViewer<VR> viewer, List<? extends IContentPart<VR, ? extends VR>> toBeDeselected) {
        this(DEFAULT_LABEL, viewer, toBeDeselected);
    }

    public DeselectOperation(String label, IViewer<VR> viewer, List<? extends IContentPart<VR, ? extends VR>> toBeDeselected) {
        super(label);
        this.viewer = viewer;
        this.toBeDeselected = new ArrayList<IContentPart<VR, VR>>(toBeDeselected);
        SelectionModel<VR> selectionModel = this.getSelectionModel();
        this.initialSelection = new ArrayList<IContentPart<VR, VR>>(selectionModel.getSelectionUnmodifiable());
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel<? extends VR> selectionModel = this.getSelectionModel();
        this.deselected = new ArrayList<IContentPart<VR, VR>>(this.toBeDeselected);
        this.deselected.retainAll(new ArrayList<IContentPart<VR, VR>>(selectionModel.getSelectionUnmodifiable()));
        selectionModel.removeFromSelection(this.deselected);
        return Status.OK_STATUS;
    }

    protected SelectionModel<VR> getSelectionModel() {
        SelectionModel selectionModel = (SelectionModel)this.viewer.getAdapter(new TypeToken<SelectionModel<VR>>(){}.where(new TypeParameter<VR>(){}, Types.argumentOf(this.viewer.getClass())));
        return selectionModel;
    }

    public List<IContentPart<VR, ? extends VR>> getToBeDeselected() {
        return this.toBeDeselected;
    }

    @Override
    public boolean isContentRelevant() {
        return false;
    }

    @Override
    public boolean isNoOp() {
        return Collections.disjoint(this.initialSelection, this.toBeDeselected);
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        SelectionModel<? extends VR> selectionModel = this.getSelectionModel();
        selectionModel.removeFromSelection(this.deselected);
        return Status.OK_STATUS;
    }
}

