/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.fx.operations;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;

public class FXUpdateAnchorHintsOperation
extends AbstractOperation
implements ITransactionalOperation {
    private final Connection connection;
    private final Point initialStartHint;
    private final Point initialEndHint;
    private Point newStartHint;
    private Point newEndHint;

    public FXUpdateAnchorHintsOperation(Connection connection) {
        super("Update Anchor Hints");
        this.connection = connection;
        this.initialStartHint = connection.getStartPointHint() == null ? null : connection.getStartPointHint().getCopy();
        this.initialEndHint = connection.getEndPointHint() == null ? null : connection.getEndPointHint().getCopy();
        this.newStartHint = this.initialStartHint == null ? null : this.initialStartHint.getCopy();
        this.newEndHint = this.initialEndHint == null ? null : this.initialEndHint.getCopy();
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.connection != null) {
            this.setHints(this.newStartHint, this.newEndHint);
        }
        return Status.OK_STATUS;
    }

    public boolean isContentRelevant() {
        return false;
    }

    public boolean isNoOp() {
        boolean endHintEquals;
        boolean startHintEquals;
        boolean bl = this.initialStartHint == null ? this.newStartHint == null : (startHintEquals = this.initialStartHint.equals((Object)this.newStartHint));
        boolean bl2 = this.initialEndHint == null ? this.newEndHint == null : (endHintEquals = this.initialEndHint.equals((Object)this.newEndHint));
        return startHintEquals && endHintEquals;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    private void setHints(Point startHint, Point endHint) {
        Point currentEndHint;
        Point currentStartHint = this.connection.getStartPointHint();
        if (currentStartHint == null || !currentStartHint.equals((Object)startHint)) {
            this.connection.setStartPointHint(startHint);
        }
        if ((currentEndHint = this.connection.getEndPointHint()) == null || !currentEndHint.equals((Object)endHint)) {
            this.connection.setEndPointHint(endHint);
        }
    }

    public void setNewHints(Point newStartHint, Point newEndHint) {
        this.newStartHint = newStartHint == null ? null : newStartHint.getCopy();
        this.newEndHint = newEndHint == null ? null : newEndHint.getCopy();
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (this.connection != null) {
            this.setHints(this.initialStartHint, this.initialEndHint);
        }
        return Status.OK_STATUS;
    }
}

