/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.euclidean;

import java.io.Serializable;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.internal.utils.PrecisionUtils;
import org.eclipse.gef4.geometry.planar.Point;

public class Vector
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final Vector NULL = new Vector(0.0, 0.0);
    public double x;
    public double y;

    public Vector(double x, double y) {
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException("x coordinate has to be differen from NaN.");
        }
        if (Double.isNaN(y)) {
            throw new IllegalArgumentException("y coordinate has to be differen from NaN.");
        }
        this.x = x;
        this.y = y;
    }

    public Vector(Point p) {
        this(p.x, p.y);
    }

    public Vector(Point start, Point end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public Vector(Vector start, Vector end) {
        this.x = end.x - start.x;
        this.y = end.y - start.y;
    }

    public Vector clone() {
        return this.getCopy();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Vector) {
            Vector r = (Vector)obj;
            return PrecisionUtils.equal(this.x, r.x) && PrecisionUtils.equal(this.y, r.y);
        }
        return false;
    }

    public Vector getAdded(Vector other) {
        return new Vector(this.x + other.x, this.y + other.y);
    }

    public Angle getAngle(Vector other) {
        double length = this.getLength() * other.getLength();
        if (length == 0.0) {
            throw new ArithmeticException("Division by zero.");
        }
        double cosAlpha = this.getDotProduct(other) / length;
        if (cosAlpha > 1.0) {
            cosAlpha = 1.0;
        } else if (cosAlpha < -1.0) {
            cosAlpha = -1.0;
        }
        return Angle.fromRad(Math.acos(cosAlpha));
    }

    public Angle getAngleCCW(Vector other) {
        Angle angle = this.getAngle(other);
        if (this.getCrossProduct(other) > 0.0) {
            return angle.getOppositeFull();
        }
        return angle;
    }

    public Angle getAngleCW(Vector other) {
        return this.getAngleCCW(other).getOppositeFull();
    }

    public Vector getAveraged(Vector other) {
        return new Vector((this.x + other.x) / 2.0, (this.y + other.y) / 2.0);
    }

    public Vector getCopy() {
        return new Vector(this.x, this.y);
    }

    public double getCrossProduct(Vector other) {
        return this.x * other.y - this.y * other.x;
    }

    public double getDissimilarity(Vector other) {
        return Math.abs(this.getNormalized().getCrossProduct(other.getNormalized()));
    }

    public Vector getDivided(double factor) {
        if (factor == 0.0) {
            throw new ArithmeticException("Division by zero.");
        }
        return new Vector(this.x / factor, this.y / factor);
    }

    public double getDotProduct(Vector other) {
        return this.x * other.x + this.y * other.y;
    }

    public double getLength() {
        return Math.sqrt(this.getDotProduct(this));
    }

    public Vector getMultiplied(double factor) {
        return new Vector(this.x * factor, this.y * factor);
    }

    public Vector getNormalized() {
        return this.clone().getMultiplied(1.0 / this.getLength());
    }

    public Vector getOrthogonalComplement() {
        return new Vector(-this.y, this.x);
    }

    public Vector getRotatedCCW(Angle angle) {
        return this.clone().rotateCCW(angle);
    }

    public Vector getRotatedCW(Angle angle) {
        return this.clone().rotateCW(angle);
    }

    public double getSimilarity(Vector other) {
        return Math.abs(this.getDotProduct(other));
    }

    public Vector getSubtracted(Vector other) {
        return new Vector(this.x - other.x, this.y - other.y);
    }

    public int hashCode() {
        return 0;
    }

    public boolean isHorizontal() {
        return !PrecisionUtils.equal(this.x, 0.0) && PrecisionUtils.equal(this.y, 0.0);
    }

    public boolean isNull() {
        return this.equals(NULL);
    }

    public boolean isOrthogonalTo(Vector other) {
        return PrecisionUtils.equal(this.getSimilarity(other), 0.0);
    }

    public boolean isParallelTo(Vector other) {
        Angle alpha = this.getAngle(other);
        alpha.setRad(2.0 * alpha.rad());
        return alpha.equals(Angle.fromRad(0.0));
    }

    public boolean isVertical() {
        return !PrecisionUtils.equal(this.y, 0.0) && PrecisionUtils.equal(this.x, 0.0);
    }

    public Vector rotateCCW(Angle angle) {
        return this.rotateCW(angle.getOppositeFull());
    }

    public Vector rotateCW(Angle angle) {
        double alpha = angle.rad();
        double nx = this.x * Math.cos(alpha) - this.y * Math.sin(alpha);
        double ny = this.x * Math.sin(alpha) + this.y * Math.cos(alpha);
        this.x = nx;
        this.y = ny;
        return this;
    }

    public Point toPoint() {
        return new Point(this.x, this.y);
    }

    public String toString() {
        return "Vector: [" + this.x + "," + this.y + "]";
    }
}

