/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.adapt.inject;

import com.google.common.reflect.TypeToken;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.MembersInjector;
import com.google.inject.Provider;
import com.google.inject.multibindings.MapBinderBinding;
import com.google.inject.multibindings.MultibinderBinding;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.ConstructorBinding;
import com.google.inject.spi.ConvertedConstantBinding;
import com.google.inject.spi.ExposedBinding;
import com.google.inject.spi.InstanceBinding;
import com.google.inject.spi.LinkedKeyBinding;
import com.google.inject.spi.ProviderBinding;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderKeyBinding;
import com.google.inject.spi.UntargettedBinding;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.common.adapt.IAdaptable;
import org.eclipse.gef4.common.adapt.inject.AdapterMap;

public class AdapterInjector
implements MembersInjector<IAdaptable> {
    private static final Comparator<Key<?>> ADAPTER_MAP_BINDING_KEY_COMPARATOR = new Comparator<Key<?>>(){

        @Override
        public int compare(Key<?> o1, Key<?> o2) {
            if (!AdapterMap.class.equals((Object)o1.getAnnotationType()) || !AdapterMap.class.equals((Object)o2.getAnnotationType())) {
                throw new IllegalArgumentException("Can only compare keys with AdapterMap annotations");
            }
            AdapterMap a1 = (AdapterMap)o1.getAnnotation();
            AdapterMap a2 = (AdapterMap)o2.getAnnotation();
            if (a1.adaptableType().equals(a2.adaptableType())) {
                return 0;
            }
            if (a1.adaptableType().isAssignableFrom(a2.adaptableType())) {
                return -1;
            }
            return 1;
        }
    };
    private final List<IAdaptable> deferredInstances = new ArrayList<IAdaptable>();
    private Injector injector;
    private final Method method;

    public AdapterInjector(Method method) {
        this.method = method;
    }

    protected void injectAdapters(IAdaptable adaptable) {
        ArrayList<String> issues = new ArrayList<String>();
        this.injectAdapters(adaptable, issues);
        for (String issue : issues) {
            System.err.println(issue);
        }
    }

    protected void injectAdapters(final IAdaptable adaptable, final List<String> issues) {
        final Map allBindings = this.injector.getAllBindings();
        TreeMap directlyApplicableBindings = new TreeMap(ADAPTER_MAP_BINDING_KEY_COMPARATOR);
        final IdentityHashMap<Key, Binding> deferredBindings = new IdentityHashMap<Key, Binding>();
        for (Key key : allBindings.keySet()) {
            AdapterMap keyAnnotation;
            if (key.getAnnotationType() == null || !AdapterMap.class.equals((Object)key.getAnnotationType()) || !(keyAnnotation = (AdapterMap)key.getAnnotation()).adaptableType().isAssignableFrom(adaptable.getClass())) continue;
            if (!"default".equals(keyAnnotation.adaptableRole())) {
                if (!(adaptable instanceof IAdaptable.Bound)) continue;
                if (((IAdaptable.Bound)((Object)adaptable)).getAdaptable() != null) {
                    if (!keyAnnotation.adaptableRole().equals(((IAdaptable)((IAdaptable.Bound)((Object)adaptable)).getAdaptable()).getAdapterKey(adaptable).getRole())) continue;
                    directlyApplicableBindings.put(key, (Binding)allBindings.get(key));
                    continue;
                }
                Binding binding = (Binding)allBindings.get(key);
                deferredBindings.put(key, binding);
                continue;
            }
            directlyApplicableBindings.put(key, (Binding)allBindings.get(key));
        }
        this.injectAdapters(adaptable, issues, directlyApplicableBindings);
        if (!deferredBindings.isEmpty()) {
            ((IAdaptable.Bound)((Object)adaptable)).adaptableProperty().addListener((ChangeListener)new ChangeListener<IAdaptable>(){

                public void changed(ObservableValue<? extends IAdaptable> observable, IAdaptable oldValue, IAdaptable newValue) {
                    if (newValue != null) {
                        String adaptableRole = newValue.getAdapterKey(adaptable).getRole();
                        TreeMap deferredApplicableBindings = new TreeMap(ADAPTER_MAP_BINDING_KEY_COMPARATOR);
                        for (Key key : deferredBindings.keySet()) {
                            if (!((AdapterMap)key.getAnnotation()).adaptableRole().equals(adaptableRole)) continue;
                            deferredApplicableBindings.put(key, (Binding)allBindings.get(key));
                        }
                        AdapterInjector.this.injectAdapters(adaptable, issues, deferredApplicableBindings);
                        for (String issue : issues) {
                            System.err.println(issue);
                        }
                        observable.removeListener((ChangeListener)this);
                    }
                }
            });
        }
    }

    protected void injectAdapters(IAdaptable adaptable, List<String> issues, SortedMap<Key<?>, Binding<?>> adapterMapBindings) {
        for (Map.Entry<Key<?>, Binding<?>> entry : adapterMapBindings.entrySet()) {
            try {
                Map adapterMap = (Map)entry.getValue().acceptTargetVisitor((BindingTargetVisitor)new AdapterMapInferrer(issues));
                if (adapterMap == null || adapterMap.isEmpty()) continue;
                for (AdapterKey key : adapterMap.keySet()) {
                    Object adapter = adapterMap.get(key);
                    TypeToken adapterType = key.getKey();
                    String role = key.getRole();
                    this.method.setAccessible(true);
                    this.method.invoke((Object)adaptable, adapterType, adapter, role);
                }
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    public void injectMembers(IAdaptable instance) {
        if (this.injector == null) {
            this.deferredInstances.add(instance);
        } else {
            this.injectAdapters(instance);
        }
    }

    @Inject
    public void setInjector(Injector injector) {
        this.injector = injector;
        for (IAdaptable instance : this.deferredInstances) {
            this.injectAdapters(instance);
        }
        this.deferredInstances.clear();
    }

    private class AdapterMapInferrer
    implements MultibindingsTargetVisitor<Object, Map<AdapterKey<?>, Object>> {
        private List<String> issues;

        public AdapterMapInferrer(List<String> issues) {
            this.issues = issues;
        }

        protected TypeToken<?> determineAdapterType(Binding<?> binding, AdapterKey<?> bindingKey, Object adapter) {
            TypeToken bindingInferredType = (TypeToken)binding.acceptTargetVisitor((BindingTargetVisitor)new AdapterTypeInferrer());
            this.validateBindings(adapter, binding, bindingKey, bindingInferredType);
            TypeToken bindingKeyType = bindingKey.getKey();
            return bindingKeyType != null ? bindingKeyType : (bindingInferredType != null ? bindingInferredType : TypeToken.of(adapter.getClass()));
        }

        protected void validateBindings(Object adapter, Binding<?> binding, AdapterKey<?> bindingAdapterKey, TypeToken<?> bindingInferredType) {
            TypeToken<?> bindingKeyType = bindingAdapterKey.getKey();
            if (bindingInferredType != null) {
                if (bindingKeyType != null) {
                    if (bindingKeyType.equals(bindingInferredType)) {
                        this.issues.add("*** INFO: The actual type of adapter " + adapter + " could already be inferred as " + bindingInferredType + " from the binding at " + binding.getSource() + ".\n" + "          The redundant type key " + bindingKeyType + " may be omitted in the adapter key of the binding, using " + ("default".equals(bindingAdapterKey.getRole()) ? "AdapterKey.defaultRole()" : " AdapterKey.role(" + bindingAdapterKey.getRole() + ")") + " instead.");
                    } else if (bindingInferredType.getType() instanceof ParameterizedType) {
                        this.issues.add("*** WARNING: The given key type " + bindingKeyType + " does not seem to match the actual type of adapter " + adapter + " which was inferred as " + bindingInferredType + " from the binding at " + binding.getSource() + ".\n" + "             The adapter will only be retrievable via key types assignable to " + bindingKeyType + ". You should probably adjust your binding.");
                    } else if (!bindingInferredType.getRawType().equals(bindingKeyType.getRawType())) {
                        this.issues.add("*** ERROR: The given key (raw) type " + bindingKeyType.getRawType().getName() + " does not match the actual (raw) type of adapter " + adapter + " which was inferred as " + bindingInferredType + " from the binding at " + binding.getSource() + ".\n" + "           The adapter will only be retrievable via key types assignable to " + bindingKeyType + ". You need to adjust your binding.");
                    }
                }
            } else if (bindingKeyType == null) {
                this.issues.add("*** WARNING: The actual type of adapter " + adapter + " could not be inferred from the binding at " + binding.getSource() + ". The adapter will only be retrievable via key types assignable to " + TypeToken.of(adapter.getClass()) + ", which is the actual type inferred from the instance.\n" + "             You should probably adjust your binding to provide a type key using " + ("default".equals(bindingAdapterKey.getRole()) ? "AdapterKey.get(<type>)" : "AdapterKey.get(<type>, " + bindingAdapterKey.getRole() + ")") + ".");
            } else if (!bindingKeyType.getRawType().isAssignableFrom(adapter.getClass()) || !adapter.getClass().isAnonymousClass() && !adapter.getClass().isAssignableFrom(bindingKeyType.getRawType())) {
                this.issues.add("*** ERROR: The given key (raw) type " + bindingKeyType.getRawType().getName() + " does not match the actual (raw) type of adapter " + adapter + ", which was inferred as " + adapter.getClass().getName() + ".\n" + "           You need to adjust your binding.");
            } else {
                this.issues.add("*** WARNING: The actual type of adapter " + adapter + " could not be inferred from the binding at " + binding.getSource() + ". Therefore, the given type key " + bindingKeyType + " can not be confirmed.\n" + "             Make sure the provided type key " + bindingKeyType + " matches to the actual type of the adapter.");
            }
        }

        public Map<AdapterKey<?>, Object> visit(ConstructorBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ConvertedConstantBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ExposedBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(InstanceBinding<? extends Object> binding) {
            Map.Entry entry = (Map.Entry)binding.getProvider().get();
            AdapterKey key = (AdapterKey)entry.getKey();
            Object adapter = ((Provider)entry.getValue()).get();
            TypeToken<?> adapterType = this.determineAdapterType((Binding<?>)binding, key, adapter);
            return Collections.singletonMap(AdapterKey.get(adapterType, key.getRole()), adapter);
        }

        public Map<AdapterKey<?>, Object> visit(LinkedKeyBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(MapBinderBinding<? extends Object> mapbinding) {
            HashMap adapters = new HashMap();
            for (Map.Entry entry : mapbinding.getEntries()) {
                AdapterKey key = (AdapterKey)entry.getKey();
                Object adapter = ((Binding)entry.getValue()).getProvider().get();
                TypeToken<?> adapterType = this.determineAdapterType((Binding)entry.getValue(), key, adapter);
                adapters.put(AdapterKey.get(adapterType, key.getRole()), adapter);
            }
            return adapters;
        }

        public Map<AdapterKey<?>, Object> visit(MultibinderBinding<? extends Object> multibinding) {
            HashMap adapters = new HashMap();
            for (Binding binding : multibinding.getElements()) {
                adapters.putAll((Map)binding.acceptTargetVisitor((BindingTargetVisitor)this));
            }
            return adapters;
        }

        public Map<AdapterKey<?>, Object> visit(ProviderBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(ProviderInstanceBinding<? extends Object> binding) {
            HashMap adapters = new HashMap();
            Map adaptersOrProvidersByKeys = (Map)binding.getProviderInstance().get();
            for (AdapterKey adapterKey : adaptersOrProvidersByKeys.keySet()) {
                Object adaptersOrProvider = adaptersOrProvidersByKeys.get(adapterKey);
                if (adaptersOrProvider instanceof Provider) {
                    Object adapter = ((Provider)adaptersOrProvider).get();
                    TypeToken<?> adapterType = this.determineAdapterType((Binding<?>)binding, adapterKey, adapter);
                    adapters.put(AdapterKey.get(adapterType, adapterKey.getRole()), adapter);
                    continue;
                }
                if (!(adaptersOrProvider instanceof Set)) continue;
                for (Object adapter : (Set)adaptersOrProvider) {
                    TypeToken<?> adapterType = this.determineAdapterType((Binding<?>)binding, adapterKey, adapter);
                    adapters.put(AdapterKey.get(adapterType, adapterKey.getRole()), adapter);
                }
            }
            return adapters;
        }

        public Map<AdapterKey<?>, Object> visit(ProviderKeyBinding<? extends Object> binding) {
            return null;
        }

        public Map<AdapterKey<?>, Object> visit(UntargettedBinding<? extends Object> binding) {
            return null;
        }
    }

    private class AdapterTypeInferrer
    implements BindingTargetVisitor<Object, TypeToken<?>> {
        private AdapterTypeInferrer() {
        }

        public TypeToken<?> visit(ConstructorBinding<? extends Object> binding) {
            return TypeToken.of((Type)binding.getKey().getTypeLiteral().getType());
        }

        public TypeToken<?> visit(ConvertedConstantBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(ExposedBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(InstanceBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(LinkedKeyBinding<? extends Object> binding) {
            Binding linkedKeyBinding = AdapterInjector.this.injector.getBinding(binding.getLinkedKey());
            return (TypeToken)linkedKeyBinding.acceptTargetVisitor((BindingTargetVisitor)this);
        }

        public TypeToken<?> visit(ProviderBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(ProviderInstanceBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(ProviderKeyBinding<? extends Object> binding) {
            return null;
        }

        public TypeToken<?> visit(UntargettedBinding<? extends Object> binding) {
            return null;
        }
    }
}

