/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.policies;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.reflect.TypeToken;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Effect;
import javafx.scene.effect.Reflection;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Rectangle;
import javafx.scene.transform.Affine;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.common.adapt.AdapterKey;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.examples.logo.policies.IFXCreationMenuItem;
import org.eclipse.gef4.mvc.fx.parts.FXDefaultHoverFeedbackPartFactory;
import org.eclipse.gef4.mvc.fx.parts.FXRootPart;
import org.eclipse.gef4.mvc.fx.policies.FXTransformPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnClickPolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.parts.IContentPart;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.policies.AbstractInteractionPolicy;
import org.eclipse.gef4.mvc.policies.CreationPolicy;

public class FXCreationMenuOnClickPolicy
extends AbstractInteractionPolicy<Node>
implements IFXOnClickPolicy {
    public static final String MENU_ITEM_PROVIDER_ROLE = "Provider<List<IFXCreationMenuItem>>";
    private static final Paint ARROW_FILL = Color.WHITE;
    private static final Paint ARROW_STROKE = Color.web((String)"#5a61af");
    private static final double ARROW_STROKE_WIDTH = 2.5;
    private static final Double[] LEFT_ARROW_POINTS = new Double[]{10.0, 0.0, 0.0, 5.0, 10.0, 10.0};
    private static final double DROP_SHADOW_RADIUS = 5.0;
    private static final Double[] RIGHT_ARROW_POINTS = new Double[]{0.0, 0.0, 10.0, 5.0, 0.0, 10.0};
    private final List<IFXCreationMenuItem> items = new ArrayList<IFXCreationMenuItem>();
    private double maxWidth = 0.0;
    private double maxHeight = 0.0;
    private int currentItemIndex = 1;
    private Point initialMousePositionInScene;
    private final double padding = 12.0;
    private HBox hbox;
    private Group templateGroup;

    private static Reflection createDropShadowReflectionEffect(double effectRadius, Color color) {
        DropShadow dropShadow = new DropShadow(effectRadius, color);
        Reflection reflection = new Reflection();
        reflection.setInput((Effect)dropShadow);
        return reflection;
    }

    private static boolean isNested(Parent parent, Node node) {
        while (node != null && node != parent) {
            node = node.getParent();
        }
        return node == parent;
    }

    public void click(MouseEvent e) {
        Node targetNode;
        EventTarget target;
        if (MouseButton.SECONDARY.equals((Object)e.getButton())) {
            EventTarget target2;
            if (this.isMenuOpen()) {
                this.closeMenu();
            }
            if ((target2 = e.getTarget()) instanceof Node) {
                this.initialMousePositionInScene = new Point(e.getSceneX(), e.getSceneY());
                this.openMenu(e);
            }
        } else if (MouseButton.PRIMARY.equals((Object)e.getButton()) && this.isMenuOpen() && (target = e.getTarget()) instanceof Node && !FXCreationMenuOnClickPolicy.isNested((Parent)this.hbox, targetNode = (Node)target)) {
            this.closeMenu();
        }
    }

    private void closeMenu() {
        this.getViewer().getCanvas().getScrolledOverlayGroup().getChildren().remove((Object)this.hbox);
    }

    private Node createArrow(final boolean left) {
        Polygon arrow = new Polygon();
        arrow.getPoints().addAll((Object[])(left ? LEFT_ARROW_POINTS : RIGHT_ARROW_POINTS));
        arrow.setStrokeWidth(2.5);
        arrow.setStroke(ARROW_STROKE);
        arrow.setFill(ARROW_FILL);
        this.effectOnHover((Node)arrow, (Effect)new DropShadow(5.0, this.getHighlightColor()));
        arrow.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FXCreationMenuOnClickPolicy.this.nextElement(left);
            }
        });
        return arrow;
    }

    private Node createMenuItem() {
        this.templateGroup = new Group();
        this.refreshMenuItem();
        this.templateGroup.setEffect((Effect)FXCreationMenuOnClickPolicy.createDropShadowReflectionEffect(5.0, Color.TRANSPARENT));
        this.effectOnHover((Node)this.templateGroup, (Effect)FXCreationMenuOnClickPolicy.createDropShadowReflectionEffect(5.0, this.getHighlightColor()));
        this.templateGroup.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                FXCreationMenuOnClickPolicy.this.onItemClick();
            }
        });
        this.templateGroup.setOnScroll((EventHandler)new EventHandler<ScrollEvent>(){

            public void handle(ScrollEvent event) {
                FXCreationMenuOnClickPolicy.this.nextElement(event.getDeltaY() < 0.0);
            }
        });
        return this.templateGroup;
    }

    private void effectOnHover(final Node node, final Effect effect) {
        final Effect[] oldEffect = new Effect[1];
        node.setOnMouseEntered((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                oldEffect[0] = node.getEffect();
                node.setEffect(effect);
            }
        });
        node.setOnMouseExited((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                node.setEffect(oldEffect[0]);
            }
        });
    }

    protected Color getHighlightColor() {
        Provider hoverFeedbackColorProvider = (Provider)this.getViewer().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<Color>>(){}, (String)"HOVER_FEEDBACK_COLOR_PROVIDER"));
        return hoverFeedbackColorProvider == null ? FXDefaultHoverFeedbackPartFactory.DEFAULT_HOVER_FEEDBACK_COLOR : (Color)hoverFeedbackColorProvider.get();
    }

    private FXViewer getViewer() {
        return (FXViewer)this.getHost().getRoot().getViewer();
    }

    public boolean isMenuOpen() {
        return this.hbox != null && this.hbox.getParent() != null;
    }

    private void nextElement(boolean left) {
        if (left) {
            --this.currentItemIndex;
            if (this.currentItemIndex < 0) {
                this.currentItemIndex = this.items.size() - 1;
            }
        } else {
            ++this.currentItemIndex;
            if (this.currentItemIndex >= this.items.size()) {
                this.currentItemIndex = 0;
            }
        }
        this.refreshMenuItem();
    }

    private void onItemClick() {
        Node itemVisual = (Node)this.templateGroup.getChildren().get(0);
        Bounds bounds = itemVisual.getLayoutBounds();
        Bounds boundsInContent = ((FXRootPart)this.getHost().getRoot()).contentLayer.sceneToLocal(itemVisual.localToScene(bounds));
        double dx = bounds.getWidth() - boundsInContent.getWidth();
        double dy = bounds.getHeight() - boundsInContent.getHeight();
        Affine contentsTransform = (Affine)this.getViewer().getCanvas().contentTransformProperty().get();
        double x = boundsInContent.getMinX() - bounds.getMinX() / contentsTransform.getMxx() - dx / 2.0;
        double y = boundsInContent.getMinY() - bounds.getMinY() / contentsTransform.getMyy() - dy / 2.0;
        this.closeMenu();
        IFXCreationMenuItem item = this.items.get(this.currentItemIndex);
        Object toCreate = item.createContent();
        IRootPart root = this.getHost().getRoot();
        CreationPolicy creationPolicy = (CreationPolicy)root.getAdapter((TypeToken)new TypeToken<CreationPolicy<Node>>(){});
        creationPolicy.init();
        IContentPart contentPart = creationPolicy.create(toCreate, item.findContentParent((IRootPart<Node, ? extends Node>)root), (SetMultimap)HashMultimap.create());
        FXTransformPolicy txPolicy = (FXTransformPolicy)contentPart.getAdapter(FXTransformPolicy.class);
        txPolicy.init();
        txPolicy.setTransform(new AffineTransform(1.0, 0.0, 0.0, 1.0, x, y));
        ReverseUndoCompositeOperation rev = new ReverseUndoCompositeOperation("CreateOnClick");
        rev.add((IUndoableOperation)creationPolicy.commit());
        rev.add((IUndoableOperation)txPolicy.commit());
        try {
            this.getViewer().getDomain().execute((ITransactionalOperation)rev);
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    private void openMenu(MouseEvent e) {
        this.refreshMenuItems();
        Node leftArrow = this.createArrow(true);
        Node menuItem = this.createMenuItem();
        Node rightArrow = this.createArrow(false);
        this.hbox = new HBox();
        this.hbox.getChildren().addAll((Object[])new Node[]{this.wrapWithPadding(leftArrow, 12.0), this.wrapWithPadding(menuItem, 12.0, this.maxWidth, this.maxHeight), this.wrapWithPadding(rightArrow, 12.0)});
        final Group overlayGroup = this.getViewer().getCanvas().getScrolledOverlayGroup();
        overlayGroup.getChildren().add((Object)this.hbox);
        this.hbox.layoutBoundsProperty().addListener((ChangeListener)new ChangeListener<Bounds>(){

            public void changed(ObservableValue<? extends Bounds> observable, Bounds oldBounds, Bounds newBounds) {
                Affine contentTransform = FXCreationMenuOnClickPolicy.this.getViewer().getCanvas().getContentTransform();
                FXCreationMenuOnClickPolicy.this.hbox.setTranslateX(-newBounds.getWidth() / 2.0);
                FXCreationMenuOnClickPolicy.this.hbox.setTranslateY(-newBounds.getHeight() / 2.0);
                FXCreationMenuOnClickPolicy.this.hbox.setScaleX(contentTransform.getMxx());
                FXCreationMenuOnClickPolicy.this.hbox.setScaleY(contentTransform.getMyy());
                Point2D pos = overlayGroup.sceneToLocal(((FXCreationMenuOnClickPolicy)FXCreationMenuOnClickPolicy.this).initialMousePositionInScene.x, ((FXCreationMenuOnClickPolicy)FXCreationMenuOnClickPolicy.this).initialMousePositionInScene.y);
                FXCreationMenuOnClickPolicy.this.hbox.setLayoutX(pos.getX());
                FXCreationMenuOnClickPolicy.this.hbox.setLayoutY(pos.getY());
            }
        });
    }

    private void refreshMenuItem() {
        this.templateGroup.getChildren().clear();
        this.templateGroup.getChildren().add((Object)this.items.get(this.currentItemIndex).createVisual());
    }

    private void refreshMenuItems() {
        List menuItems = (List)((Provider)this.getHost().getAdapter(AdapterKey.get((TypeToken)new TypeToken<Provider<List<IFXCreationMenuItem>>>(){}, (String)MENU_ITEM_PROVIDER_ROLE))).get();
        this.items.clear();
        this.items.addAll(menuItems);
        this.maxWidth = 0.0;
        this.maxHeight = 0.0;
        for (IFXCreationMenuItem item : this.items) {
            Bounds bounds = item.createVisual().getLayoutBounds();
            if (bounds.getWidth() > this.maxWidth) {
                this.maxWidth = bounds.getWidth();
            }
            if (!(bounds.getHeight() > this.maxHeight)) continue;
            this.maxHeight = bounds.getHeight();
        }
        if (this.currentItemIndex >= this.items.size()) {
            this.currentItemIndex = 0;
        }
    }

    private StackPane wrapWithPadding(Node node, double padding) {
        return this.wrapWithPadding(node, padding, node.getLayoutBounds().getWidth(), node.getLayoutBounds().getHeight());
    }

    private StackPane wrapWithPadding(Node node, double padding, double width, double height) {
        StackPane stack = new StackPane();
        stack.getChildren().addAll((Object[])new Node[]{new Rectangle(width + padding + padding, height + padding + padding, (Paint)Color.TRANSPARENT), node});
        return stack;
    }
}

