/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.policies;

import javafx.scene.input.MouseEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.fx.policies.AbstractFXInteractionPolicy;
import org.eclipse.gef4.mvc.fx.policies.IFXOnClickPolicy;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.zest.fx.operations.NavigateOperation;
import org.eclipse.gef4.zest.fx.parts.ZestFxRootPart;

public class OpenParentGraphOnDoubleClickPolicy
extends AbstractFXInteractionPolicy
implements IFXOnClickPolicy {
    public void click(MouseEvent event) {
        if (event.getClickCount() == 2) {
            Graph nestingGraph;
            if (this.isRegistered(event.getTarget()) && !this.isRegisteredForHost(event.getTarget())) {
                return;
            }
            ContentModel contentModel = (ContentModel)this.getHost().getRoot().getViewer().getAdapter(ContentModel.class);
            if (contentModel == null) {
                throw new IllegalArgumentException("ContentModel could not be obtained!");
            }
            Graph currentGraph = (Graph)contentModel.getContents().get(0);
            Graph graph = nestingGraph = currentGraph.getNestingNode() != null ? currentGraph.getNestingNode().getGraph() : null;
            if (nestingGraph != null) {
                FXViewer viewer = (FXViewer)this.getHost().getRoot().getViewer();
                try {
                    viewer.getDomain().execute((ITransactionalOperation)new NavigateOperation(viewer, nestingGraph, false));
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public ZestFxRootPart getHost() {
        return (ZestFxRootPart)super.getHost();
    }
}

