/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.behaviors;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javafx.collections.SetChangeListener;
import javafx.scene.Node;
import org.eclipse.gef4.mvc.behaviors.BehaviorUtils;
import org.eclipse.gef4.mvc.parts.IRootPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;
import org.eclipse.gef4.zest.fx.behaviors.AbstractHidingBehavior;
import org.eclipse.gef4.zest.fx.parts.HiddenNeighborsFeedbackPart;
import org.eclipse.gef4.zest.fx.parts.NodePart;

public class NodeHidingBehavior
extends AbstractHidingBehavior {
    private IVisualPart<Node, ? extends Node> hiddenNeighborsFeedbackPart;

    private boolean containsAny(Set<org.eclipse.gef4.graph.Node> hidden, Set<org.eclipse.gef4.graph.Node> neighbors) {
        boolean containsAny = false;
        for (org.eclipse.gef4.graph.Node n : neighbors) {
            if (!hidden.contains(n)) continue;
            containsAny = true;
            break;
        }
        return containsAny;
    }

    protected void createHiddenNeighborsFeedbackPart() {
        if (this.hiddenNeighborsFeedbackPart == null) {
            this.hiddenNeighborsFeedbackPart = new HiddenNeighborsFeedbackPart();
        }
        BehaviorUtils.addAnchoreds((IRootPart)this.getHost().getRoot(), Collections.singletonList(this.getHost()), Collections.singletonList(this.hiddenNeighborsFeedbackPart));
    }

    @Override
    protected boolean determineHiddenStatus() {
        return this.getHidingModel().isHidden(this.getHost().getContent());
    }

    @Override
    protected void doActivate() {
        super.doActivate();
        if (this.getHidingModel().hasHiddenNeighbors(this.getHost())) {
            this.createHiddenNeighborsFeedbackPart();
        }
    }

    @Override
    protected void doDeactivate() {
        if (this.getHidingModel().hasHiddenNeighbors(this.getHost())) {
            this.removeHiddenNeighborsFeedbackPart();
        }
        super.doDeactivate();
    }

    protected IVisualPart<Node, ? extends Node> getHiddenNeighborsFeedbackPart() {
        return this.hiddenNeighborsFeedbackPart;
    }

    public NodePart getHost() {
        return (NodePart)super.getHost();
    }

    @Override
    protected void onHidingModelChange(SetChangeListener.Change<? extends org.eclipse.gef4.graph.Node> change) {
        super.onHidingModelChange(change);
        HashSet<org.eclipse.gef4.graph.Node> newHidden = new HashSet<org.eclipse.gef4.graph.Node>((Collection<org.eclipse.gef4.graph.Node>)change.getSet());
        HashSet<org.eclipse.gef4.graph.Node> oldHidden = new HashSet<org.eclipse.gef4.graph.Node>((Collection<org.eclipse.gef4.graph.Node>)change.getSet());
        oldHidden.remove(change.getElementAdded());
        oldHidden.add((org.eclipse.gef4.graph.Node)change.getElementRemoved());
        org.eclipse.gef4.graph.Node content = this.getHost().getContent();
        Set neighbors = content.getLocalNeighbors();
        if (!this.containsAny(oldHidden, neighbors) && this.containsAny(newHidden, neighbors)) {
            this.createHiddenNeighborsFeedbackPart();
        } else if (this.containsAny(oldHidden, neighbors) && !this.containsAny(newHidden, neighbors)) {
            this.removeHiddenNeighborsFeedbackPart();
        } else if (this.hiddenNeighborsFeedbackPart != null) {
            this.updateHiddenNeighborsFeedbackPart();
        }
    }

    protected void removeHiddenNeighborsFeedbackPart() {
        BehaviorUtils.removeAnchoreds((IRootPart)this.getHost().getRoot(), Collections.singletonList(this.getHost()), Collections.singletonList(this.hiddenNeighborsFeedbackPart));
    }

    protected void updateHiddenNeighborsFeedbackPart() {
        this.hiddenNeighborsFeedbackPart.refreshVisual();
    }
}

