/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.dot.internal;

import com.google.inject.Injector;
import java.io.File;
import java.io.StringReader;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef4.dot.internal.DotFileUtils;
import org.eclipse.gef4.dot.internal.DotInterpreter;
import org.eclipse.gef4.dot.internal.parser.DotStandaloneSetup;
import org.eclipse.gef4.dot.internal.parser.dot.DotAst;
import org.eclipse.gef4.dot.internal.parser.parser.antlr.DotParser;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.SyntaxErrorMessage;
import org.eclipse.xtext.parser.IParseResult;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class DotImport {
    private static final Injector dotInjector = new DotStandaloneSetup().createInjectorAndDoEMFRegistration();
    private static final DotParser dotParser = (DotParser)((Object)dotInjector.getInstance(DotParser.class));

    public Graph importDot(String dotString) {
        Graph _xblockexpression = null;
        StringReader _stringReader = new StringReader(dotString);
        IParseResult parseResult = dotParser.parse(_stringReader);
        boolean _hasSyntaxErrors = parseResult.hasSyntaxErrors();
        if (_hasSyntaxErrors) {
            Iterable _syntaxErrors = parseResult.getSyntaxErrors();
            Functions.Function1<INode, String> _function = new Functions.Function1<INode, String>(){

                public String apply(INode it) {
                    SyntaxErrorMessage _syntaxErrorMessage = it.getSyntaxErrorMessage();
                    return _syntaxErrorMessage.getMessage();
                }
            };
            Iterable _map = IterableExtensions.map((Iterable)_syntaxErrors, (Functions.Function1)_function);
            String _join = IterableExtensions.join((Iterable)_map, (CharSequence)",");
            String _plus = "Given DOT string is not valid: " + _join;
            throw new IllegalArgumentException(_plus);
        }
        DotInterpreter _dotInterpreter = new DotInterpreter();
        EObject _rootASTElement = parseResult.getRootASTElement();
        List<Graph> _interpret = _dotInterpreter.interpret((DotAst)_rootASTElement);
        _xblockexpression = (Graph)IterableExtensions.head(_interpret);
        return _xblockexpression;
    }

    public Graph importDot(File dotFile) {
        String _read = DotFileUtils.read(dotFile);
        return this.importDot(_read);
    }
}

