/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.reflect;

import java.lang.reflect.Field;

public class ReflectionUtils {
    public static <T> T getPrivateFieldValue(Object owner, String fieldName) {
        Field field = ReflectionUtils.getPrivateField(owner, fieldName);
        try {
            return (T)field.get(owner);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static Field getPrivateField(Object owner, String fieldName) {
        Class<?> currentClass = owner.getClass();
        Field field = null;
        do {
            try {
                field = currentClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                currentClass = currentClass.getSuperclass();
                if (currentClass != null) continue;
                return null;
            }
        } while (field == null);
        field.setAccessible(true);
        return field;
    }

    public static <T> void setPrivateFieldValue(Object owner, String fieldName, T value) {
        Field field = ReflectionUtils.getPrivateField(owner, fieldName);
        try {
            field.set(owner, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }
}

