/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.policies;

import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.mvc.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef4.mvc.operations.ITransactionalOperation;
import org.eclipse.gef4.mvc.operations.ResizeContentOperation;
import org.eclipse.gef4.mvc.parts.IResizableContentPart;
import org.eclipse.gef4.mvc.policies.AbstractTransactionPolicy;

public abstract class AbstractResizePolicy<VR>
extends AbstractTransactionPolicy<VR> {
    private Dimension initialSize;

    protected void applySize(double dw, double dh) {
        this.updateResizeOperation(dw, dh);
        this.locallyExecuteOperation();
    }

    @Override
    public ITransactionalOperation commit() {
        ITransactionalOperation commitOperation = super.commit();
        if (commitOperation != null && !commitOperation.isNoOp() && this.isContentResizable()) {
            ForwardUndoCompositeOperation composite = new ForwardUndoCompositeOperation("Resize Content");
            composite.add(commitOperation);
            composite.add(this.createResizeContentOperation());
            commitOperation = composite;
        }
        this.initialSize = null;
        return commitOperation;
    }

    protected ITransactionalOperation createResizeContentOperation() {
        ResizeContentOperation resizeOperation = new ResizeContentOperation((IResizableContentPart)this.getHost(), this.getInitialSize(), this.getCurrentSize());
        return resizeOperation;
    }

    protected abstract Dimension getCurrentSize();

    protected Dimension getInitialSize() {
        return this.initialSize;
    }

    @Override
    public void init() {
        super.init();
        this.initialSize = this.getCurrentSize();
    }

    protected boolean isContentResizable() {
        return this.getHost() instanceof IResizableContentPart;
    }

    public void resize(double finalDw, double finalDh) {
        this.checkInitialized();
        this.applySize(finalDw, finalDh);
    }

    protected abstract void updateResizeOperation(double var1, double var3);
}

