/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.zest.fx.operations;

import java.util.Collections;
import javafx.scene.transform.Transform;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.gef4.fx.nodes.InfiniteCanvas;
import org.eclipse.gef4.geometry.convert.fx.FX2Geometry;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.mvc.fx.operations.FXChangeViewportOperation;
import org.eclipse.gef4.mvc.fx.viewer.FXViewer;
import org.eclipse.gef4.mvc.models.ContentModel;
import org.eclipse.gef4.mvc.operations.ChangeContentsOperation;
import org.eclipse.gef4.mvc.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef4.mvc.viewer.IViewer;
import org.eclipse.gef4.zest.fx.models.NavigationModel;

public class NavigateOperation
extends ReverseUndoCompositeOperation {
    private ChangeContentsOperation changeContentsOperation;
    private FXChangeViewportOperation changeViewportOperation;
    private NavigationModel navigationModel;
    private Graph initialGraph;
    private NavigationModel.ViewportState initialViewportState;

    public NavigateOperation(FXViewer viewer) {
        super("NavigateGraph");
        this.initialGraph = (Graph)((ContentModel)viewer.getAdapter(ContentModel.class)).getContents().get(0);
        this.navigationModel = (NavigationModel)viewer.getAdapter(NavigationModel.class);
        this.changeViewportOperation = new FXChangeViewportOperation(viewer.getCanvas());
        this.changeContentsOperation = new ChangeContentsOperation((IViewer)viewer, Collections.singletonList(this.initialGraph));
        this.add((IUndoableOperation)this.changeViewportOperation);
        this.add((IUndoableOperation)this.changeContentsOperation);
        InfiniteCanvas canvas = viewer.getCanvas();
        this.initialViewportState = new NavigationModel.ViewportState(canvas.getHorizontalScrollOffset(), canvas.getVerticalScrollOffset(), canvas.getWidth(), canvas.getHeight(), FX2Geometry.toAffineTransform((Transform)canvas.getContentTransform()));
        this.navigationModel.setViewportState(this.initialGraph, this.initialViewportState);
    }

    public NavigateOperation(FXViewer viewer, Graph finalGraph, boolean isNestedGraph) {
        this(viewer);
        this.setFinalState(finalGraph, isNestedGraph);
    }

    public FXChangeViewportOperation getChangeViewportOperation() {
        return this.changeViewportOperation;
    }

    public void setFinalState(Graph finalGraph, boolean isNestedGraph) {
        NavigationModel.ViewportState newViewportState = this.navigationModel.getViewportState(finalGraph);
        if (newViewportState == null || isNestedGraph) {
            newViewportState = new NavigationModel.ViewportState(0.0, 0.0, this.initialViewportState.getWidth(), this.initialViewportState.getHeight(), new AffineTransform());
        }
        this.changeViewportOperation.setNewWidth(newViewportState.getWidth());
        this.changeViewportOperation.setNewHeight(newViewportState.getHeight());
        this.changeViewportOperation.setNewHorizontalScrollOffset(newViewportState.getTranslateX());
        this.changeViewportOperation.setNewVerticalScrollOffset(newViewportState.getTranslateY());
        this.changeViewportOperation.setNewContentTransform(newViewportState.getContentsTransform());
        this.changeContentsOperation.setNewContents(Collections.singletonList(finalGraph));
    }
}

