/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.graph;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.gef4.common.attributes.IAttributeCopier;
import org.eclipse.gef4.common.attributes.IAttributeStore;
import org.eclipse.gef4.graph.Edge;
import org.eclipse.gef4.graph.Graph;
import org.eclipse.gef4.graph.Node;

public class GraphCopier {
    private Map<Node, Node> inputToOutputNodes = new IdentityHashMap<Node, Node>();
    private IAttributeCopier attributeCopier;

    public GraphCopier(IAttributeCopier attributeCopier) {
        this.attributeCopier = attributeCopier;
    }

    public Graph copy(Graph graph) {
        Graph outputGraph = new Graph();
        this.copyAttributes(graph, outputGraph);
        for (Node inputNode : graph.getNodes()) {
            Node outputNode = this.copyNode(inputNode);
            if (outputNode == null) continue;
            this.inputToOutputNodes.put(inputNode, outputNode);
            outputNode.setGraph(outputGraph);
            outputGraph.getNodes().add((Object)outputNode);
        }
        for (Edge inputEdge : graph.getEdges()) {
            Edge outputEdge = this.copyEdge(inputEdge);
            if (outputEdge == null) continue;
            outputEdge.setGraph(outputGraph);
            outputGraph.getEdges().add((Object)outputEdge);
        }
        this.inputToOutputNodes.clear();
        return outputGraph;
    }

    protected void copyAttributes(IAttributeStore inputStore, IAttributeStore outputStore) {
        this.attributeCopier.copy(inputStore, outputStore);
    }

    protected Edge copyEdge(Edge edge) {
        Node outputSource = this.inputToOutputNodes.get(edge.getSource());
        Node outputTarget = this.inputToOutputNodes.get(edge.getTarget());
        Edge outputEdge = new Edge(outputSource, outputTarget);
        this.copyAttributes(edge, outputEdge);
        return outputEdge;
    }

    protected Node copyNode(Node node) {
        Node outputNode = new Node();
        this.copyAttributes(node, outputNode);
        if (node.getNestedGraph() != null) {
            Graph nested = this.copy(node.getNestedGraph());
            outputNode.setNestedGraph(nested);
        }
        return outputNode;
    }
}

