/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.euclidean.Straight;
import org.eclipse.gef4.geometry.euclidean.Vector;
import org.eclipse.gef4.geometry.internal.utils.PrecisionUtils;
import org.eclipse.gef4.geometry.planar.Dimension;
import org.eclipse.gef4.geometry.planar.Rectangle;

public class Point
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    public double x;
    public double y;

    private static Point[] eliminateDuplicates(Point ... points) {
        Arrays.sort(points, 0, points.length, new Comparator<Point>(){

            @Override
            public int compare(Point p1, Point p2) {
                if (p1.x < p2.x) {
                    return -1;
                }
                if (p1.x == p2.x && p1.y < p2.y) {
                    return -1;
                }
                if (p1.x == p2.x && p1.y == p2.y) {
                    return 0;
                }
                return 1;
            }
        });
        ArrayList<Point> uniquePoints = new ArrayList<Point>(points.length);
        int i = 0;
        while (i < points.length - 1) {
            if (!points[i].equals(points[i + 1])) {
                uniquePoints.add(points[i]);
            }
            ++i;
        }
        uniquePoints.add(points[points.length - 1]);
        return uniquePoints.toArray(new Point[0]);
    }

    public static Rectangle getBounds(Point ... points) {
        if (points.length == 0) {
            return new Rectangle();
        }
        Point topLeft = points[0];
        Point bottomRight = points[0];
        Point[] pointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            topLeft = Point.min(topLeft, p);
            bottomRight = Point.max(bottomRight, p);
            ++n2;
        }
        return new Rectangle(topLeft, bottomRight);
    }

    public static Point getCentroid(Point ... points) {
        double a;
        if (points.length == 0) {
            return null;
        }
        if (points.length == 1) {
            return points[0].getCopy();
        }
        double cx = 0.0;
        double cy = 0.0;
        double sa = 0.0;
        int i = 0;
        while (i < points.length - 1) {
            a = points[i].x * points[i + 1].y - points[i].y * points[i + 1].x;
            sa += a;
            cx += (points[i].x + points[i + 1].x) * a;
            cy += (points[i].y + points[i + 1].y) * a;
            ++i;
        }
        a = points[points.length - 1].x * points[0].y - points[points.length - 1].y * points[0].x;
        cx += (points[points.length - 1].x + points[0].x) * a;
        cy += (points[points.length - 1].y + points[0].y) * a;
        if ((sa += a) == 0.0) {
            return new Point(cx, cy);
        }
        return new Point(cx / (3.0 * sa), cy / (3.0 * sa));
    }

    /*
     * Unable to fully structure code
     */
    public static Point[] getConvexHull(Point ... points) {
        if (points.length <= 3) {
            return Point.getCopy(points);
        }
        points = Point.eliminateDuplicates(points);
        minIdx = 0;
        min = points[minIdx];
        i = 1;
        while (i < points.length) {
            if (points[i].y < min.y || points[i].y == min.y && points[i].x < min.x) {
                min = points[i];
                minIdx = i;
            }
            ++i;
        }
        tmp = points[0];
        points[0] = points[minIdx];
        points[minIdx] = tmp;
        p0 = points[0];
        Arrays.sort(points, 1, points.length, new Comparator<Point>(){

            @Override
            public int compare(Point p1, Point p2) {
                double d = Straight.getSignedDistanceCCW(Point.this, p1, p2);
                if (PrecisionUtils.equal(d, 0.0)) {
                    return 0;
                }
                return d < 0.0 ? -1 : 1;
            }
        });
        convexHull = new ArrayList<Point>();
        convexHull.add(points[2]);
        convexHull.add(points[1]);
        convexHull.add(points[0]);
        i = 3;
        ** GOTO lbl33
        {
            convexHull.remove(0);
            do {
                if (convexHull.size() > 2 && Straight.getSignedDistanceCCW((Point)convexHull.get(1), (Point)convexHull.get(0), points[i]) > 0.0) continue block1;
                convexHull.add(0, points[i]);
                ++i;
lbl33:
                // 2 sources

            } while (i < points.length);
        }
        return convexHull.toArray(new Point[0]);
    }

    public static final Point[] getCopy(Point ... points) {
        if (points == null) {
            throw new IllegalArgumentException("points may not be null.");
        }
        Point[] copy = new Point[points.length];
        int i = 0;
        while (i < points.length) {
            copy[i] = points[i].getCopy();
            ++i;
        }
        return copy;
    }

    public static final Point[] getReverseCopy(Point ... points) {
        Point[] reversed = new Point[points.length];
        int i = 0;
        while (i < points.length) {
            reversed[i] = points[points.length - i - 1].getCopy();
            ++i;
        }
        return reversed;
    }

    public static Point max(Point p1, Point p2) {
        return new Point(Math.max(p1.x, p2.x), Math.max(p1.y, p2.y));
    }

    public static Point min(Point p1, Point p2) {
        return new Point(Math.min(p1.x, p2.x), Math.min(p1.y, p2.y));
    }

    public static Point nearest(Point referencePoint, Point ... candidates) {
        if (candidates.length == 0) {
            return null;
        }
        Point nearest = candidates[0];
        double minDistance = referencePoint.getDistance(nearest);
        int i = 1;
        while (i < candidates.length) {
            double d = referencePoint.getDistance(candidates[i]);
            if (d < minDistance) {
                minDistance = d;
                nearest = candidates[i];
            }
            ++i;
        }
        return nearest;
    }

    public static void rotateCCW(Point[] points, Angle angle, double cx, double cy) {
        Point.translate(points, -cx, -cy);
        Point[] pointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            Point np = new Vector(p).rotateCCW(angle).toPoint();
            p.x = np.x;
            p.y = np.y;
            ++n2;
        }
        Point.translate(points, cx, cy);
    }

    public static void rotateCW(Point[] points, Angle angle, double cx, double cy) {
        Point.translate(points, -cx, -cy);
        Point[] pointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            Point np = new Vector(p).rotateCW(angle).toPoint();
            p.x = np.x;
            p.y = np.y;
            ++n2;
        }
        Point.translate(points, cx, cy);
    }

    public static void scale(Point[] points, double fx, double fy, double cx, double cy) {
        Point.translate(points, -cx, -cy);
        Point[] pointArray = points;
        int n = points.length;
        int n2 = 0;
        while (n2 < n) {
            Point p = pointArray[n2];
            p.scale(fx, fy);
            ++n2;
        }
        Point.translate(points, cx, cy);
    }

    public static void translate(Point[] points, double dx, double dy) {
        int i = 0;
        while (i < points.length) {
            points[i].x += dx;
            points[i].y += dy;
            ++i;
        }
    }

    public Point() {
    }

    public Point(double x, double y) {
        if (Double.isNaN(x)) {
            throw new IllegalArgumentException("x coordinate has to be different from NaN.");
        }
        if (Double.isNaN(y)) {
            throw new IllegalArgumentException("y coordinate has to be different from NaN.");
        }
        this.x = x;
        this.y = y;
    }

    public Point(Point p) {
        this(p.x, p.y);
    }

    public Point clone() {
        return this.getCopy();
    }

    public boolean equals(double x, double y) {
        return PrecisionUtils.equal(this.x, x) && PrecisionUtils.equal(this.y, y);
    }

    public boolean equals(Object o) {
        if (o instanceof Point) {
            Point p = (Point)o;
            return this.equals(p.x, p.y);
        }
        return false;
    }

    public Point getCopy() {
        return new Point(this);
    }

    public Point getDifference(Point other) {
        return new Point(other.x - this.x, other.y - this.y);
    }

    public double getDistance(Point p) {
        double i = p.x - this.x;
        double j = p.y - this.y;
        return Math.sqrt(i * i + j * j);
    }

    public Point getNegated() {
        return this.getCopy().negate();
    }

    public Point getScaled(double factor) {
        return this.getCopy().scale(factor);
    }

    public Point getScaled(double xFactor, double yFactor) {
        return this.getCopy().scale(xFactor, yFactor);
    }

    public Point getScaled(double factorX, double factorY, Point center) {
        return this.getCopy().scale(factorX, factorY, center);
    }

    public Point getTranslated(Dimension d) {
        return this.getCopy().translate(d);
    }

    public Point getTranslated(double x, double y) {
        return this.getCopy().translate(x, y);
    }

    public Point getTranslated(Point p) {
        return this.getCopy().translate(p);
    }

    public Point getTransposed() {
        return this.getCopy().transpose();
    }

    public int hashCode() {
        return 0;
    }

    public Point negate() {
        this.scale(-1.0);
        return this;
    }

    public Point scale(double factor) {
        return this.scale(factor, factor);
    }

    public Point scale(double xFactor, double yFactor) {
        this.x *= xFactor;
        this.y *= yFactor;
        return this;
    }

    public Point scale(double factorX, double factorY, Point center) {
        this.translate(center.getNegated());
        this.scale(factorX, factorY);
        this.translate(center);
        return this;
    }

    public Point setLocation(double x, double y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Point setLocation(Point p) {
        this.x = p.x;
        this.y = p.y;
        return this;
    }

    public Point setX(double x) {
        this.x = x;
        return this;
    }

    public Point setY(double y) {
        this.y = y;
        return this;
    }

    public String toString() {
        return "Point(" + this.x + ", " + this.y + ")";
    }

    public Point translate(Dimension d) {
        return this.translate(d.width, d.height);
    }

    public Point translate(double dx, double dy) {
        this.x += dx;
        this.y += dy;
        return this;
    }

    public Point translate(Point p) {
        return this.translate(p.x, p.y);
    }

    public Point transpose() {
        double temp = this.x;
        this.x = this.y;
        this.y = temp;
        return this;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }
}

