/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.parts;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Polygon;
import javafx.scene.shape.Shape;
import javafx.scene.shape.StrokeLineCap;
import org.eclipse.gef4.fx.anchors.DynamicAnchor;
import org.eclipse.gef4.fx.anchors.IAnchor;
import org.eclipse.gef4.fx.anchors.OrthogonalProjectionStrategy;
import org.eclipse.gef4.fx.nodes.Connection;
import org.eclipse.gef4.fx.nodes.GeometryNode;
import org.eclipse.gef4.fx.nodes.IConnectionInterpolator;
import org.eclipse.gef4.fx.nodes.IConnectionRouter;
import org.eclipse.gef4.fx.nodes.OrthogonalRouter;
import org.eclipse.gef4.fx.nodes.PolyBezierInterpolator;
import org.eclipse.gef4.fx.nodes.PolylineInterpolator;
import org.eclipse.gef4.fx.nodes.StraightRouter;
import org.eclipse.gef4.geometry.planar.AffineTransform;
import org.eclipse.gef4.geometry.planar.IGeometry;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.mvc.examples.logo.model.AbstractFXGeometricElement;
import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricCurve;
import org.eclipse.gef4.mvc.examples.logo.parts.AbstractFXGeometricElementPart;
import org.eclipse.gef4.mvc.fx.providers.IAnchorProvider;
import org.eclipse.gef4.mvc.parts.IBendableContentPart;
import org.eclipse.gef4.mvc.parts.ITransformableContentPart;
import org.eclipse.gef4.mvc.parts.IVisualPart;

public class FXGeometricCurvePart
extends AbstractFXGeometricElementPart<Connection>
implements ITransformableContentPart<Node, Connection>,
IBendableContentPart<Node, Connection> {
    private static final String END_ROLE = "END";
    private static final String START_ROLE = "START";
    private final CircleHead START_CIRCLE_HEAD = new CircleHead();
    private final CircleHead END_CIRCLE_HEAD = new CircleHead();
    private final ArrowHead START_ARROW_HEAD = new ArrowHead();
    private final ArrowHead END_ARROW_HEAD = new ArrowHead();
    private FXGeometricCurve previousContent;
    private final ListChangeListener<Point> wayPointsChangeListener = new ListChangeListener<Point>(){

        public void onChanged(ListChangeListener.Change<? extends Point> c) {
            FXGeometricCurvePart.this.refreshVisual();
        }
    };
    private final ListChangeListener<Double> dashesChangeListener = new ListChangeListener<Double>(){

        public void onChanged(ListChangeListener.Change<? extends Double> c) {
            FXGeometricCurvePart.this.refreshVisual();
        }
    };
    private final ChangeListener<FXGeometricCurve.RoutingStyle> routingStyleChangeListener = new ChangeListener<FXGeometricCurve.RoutingStyle>(){

        public void changed(ObservableValue<? extends FXGeometricCurve.RoutingStyle> observable, FXGeometricCurve.RoutingStyle oldValue, FXGeometricCurve.RoutingStyle newValue) {
            FXGeometricCurvePart.this.refreshVisual();
        }
    };
    private final ChangeListener<FXGeometricCurve.Decoration> decorationChangeListener = new ChangeListener<FXGeometricCurve.Decoration>(){

        public void changed(ObservableValue<? extends FXGeometricCurve.Decoration> observable, FXGeometricCurve.Decoration oldValue, FXGeometricCurve.Decoration newValue) {
            FXGeometricCurvePart.this.refreshVisual();
        }
    };

    protected void attachToAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        IAnchor anchor = ((IAnchorProvider)anchorage.getAdapter(IAnchorProvider.class)).get((IVisualPart)this, role);
        if (role.equals(START_ROLE)) {
            ((Connection)this.getVisual()).setStartAnchor(anchor);
        } else if (role.equals(END_ROLE)) {
            ((Connection)this.getVisual()).setEndAnchor(anchor);
        } else {
            throw new IllegalStateException("Cannot attach to anchor with role <" + role + ">.");
        }
    }

    public void bendContent(List<IBendableContentPart.BendPoint> bendPoints) {
        this.getContent().getSourceAnchorages().clear();
        this.getContent().getTargetAnchorages().clear();
        ArrayList<Point> waypoints = new ArrayList<Point>();
        int i = 0;
        while (i < bendPoints.size()) {
            IBendableContentPart.BendPoint bp = bendPoints.get(i);
            if (bp.isAttached()) {
                if (i == 0) {
                    this.getContent().addSourceAnchorage((AbstractFXGeometricElement)bp.getContentAnchorage());
                    waypoints.add(bp.getPosition());
                }
                if (i == bendPoints.size() - 1) {
                    this.getContent().addTargetAnchorage((AbstractFXGeometricElement)bp.getContentAnchorage());
                    waypoints.add(bp.getPosition());
                }
            } else {
                waypoints.add(bp.getPosition());
            }
            ++i;
        }
        this.refreshContentAnchorages();
        this.getContent().setWayPoints(waypoints.toArray(new Point[0]));
    }

    protected Connection createVisual() {
        Connection visual = new Connection();
        visual.setInterpolator((IConnectionInterpolator)new PolyBezierInterpolator());
        ((GeometryNode)visual.getCurve()).setStrokeLineCap(StrokeLineCap.BUTT);
        return visual;
    }

    protected void detachFromAnchorageVisual(IVisualPart<Node, ? extends Node> anchorage, String role) {
        if (role.equals(START_ROLE)) {
            ((Connection)this.getVisual()).setStartPoint(((Connection)this.getVisual()).getStartPoint());
        } else if (role.equals(END_ROLE)) {
            ((Connection)this.getVisual()).setEndPoint(((Connection)this.getVisual()).getEndPoint());
        } else {
            throw new IllegalStateException("Cannot detach from anchor with role <" + role + ">.");
        }
    }

    protected void doAttachToContentAnchorage(Object contentAnchorage, String role) {
        if (!(contentAnchorage instanceof AbstractFXGeometricElement)) {
            throw new IllegalArgumentException("Inappropriate content anchorage: wrong type.");
        }
        AbstractFXGeometricElement geom = (AbstractFXGeometricElement)contentAnchorage;
        if (START_ROLE.equals(role)) {
            this.getContent().getSourceAnchorages().add(geom);
        } else if (END_ROLE.equals(role)) {
            this.getContent().getTargetAnchorages().add(geom);
        }
    }

    protected void doDetachFromContentAnchorage(Object contentAnchorage, String role) {
        if (START_ROLE.equals(role)) {
            this.getContent().getSourceAnchorages().remove(contentAnchorage);
        } else if (END_ROLE.equals(role)) {
            this.getContent().getTargetAnchorages().remove(contentAnchorage);
        }
    }

    protected SetMultimap<Object, String> doGetContentAnchorages() {
        HashMultimap anchorages = HashMultimap.create();
        Set<AbstractFXGeometricElement<? extends IGeometry>> sourceAnchorages = this.getContent().getSourceAnchorages();
        for (AbstractFXGeometricElement<? extends IGeometry> src : sourceAnchorages) {
            anchorages.put(src, (Object)START_ROLE);
        }
        Set<AbstractFXGeometricElement<? extends IGeometry>> targetAnchorages = this.getContent().getTargetAnchorages();
        for (AbstractFXGeometricElement<? extends IGeometry> dst : targetAnchorages) {
            anchorages.put(dst, (Object)END_ROLE);
        }
        return anchorages;
    }

    protected List<? extends Object> doGetContentChildren() {
        return Collections.emptyList();
    }

    @Override
    protected void doRefreshVisual(Connection visual) {
        FXGeometricCurve content = this.getContent();
        List<Point> wayPoints = content.getWayPointsCopy();
        AffineTransform transform = content.getTransform();
        if ((this.previousContent == null || transform != null && !transform.equals((Object)this.previousContent.getTransform()) || transform == null && this.previousContent.getTransform() != null) && transform != null) {
            Point[] transformedWayPoints = transform.getTransformed(wayPoints.toArray(new Point[0]));
            wayPoints = Arrays.asList(transformedWayPoints);
        }
        if (!this.getContentAnchoragesUnmodifiable().containsValue((Object)START_ROLE)) {
            visual.setStartPoint(wayPoints.remove(0));
        } else {
            visual.setStartPointHint(wayPoints.remove(0));
        }
        if (!this.getContentAnchoragesUnmodifiable().containsValue((Object)END_ROLE)) {
            visual.setEndPoint(wayPoints.remove(wayPoints.size() - 1));
        } else {
            visual.setEndPointHint(wayPoints.remove(wayPoints.size() - 1));
        }
        if (!visual.getControlPoints().equals(wayPoints)) {
            visual.setControlPoints(wayPoints);
        }
        switch (content.getSourceDecoration()) {
            case NONE: {
                if (visual.getStartDecoration() == null) break;
                visual.setStartDecoration(null);
                break;
            }
            case CIRCLE: {
                if (visual.getStartDecoration() != null && visual.getStartDecoration() instanceof CircleHead) break;
                visual.setStartDecoration((Node)this.START_CIRCLE_HEAD);
                break;
            }
            case ARROW: {
                if (visual.getStartDecoration() != null && visual.getStartDecoration() instanceof ArrowHead) break;
                visual.setStartDecoration((Node)this.START_ARROW_HEAD);
            }
        }
        switch (content.getTargetDecoration()) {
            case NONE: {
                if (visual.getEndDecoration() == null) break;
                visual.setEndDecoration(null);
                break;
            }
            case CIRCLE: {
                if (visual.getEndDecoration() != null && visual.getEndDecoration() instanceof CircleHead) break;
                visual.setEndDecoration((Node)this.END_CIRCLE_HEAD);
                break;
            }
            case ARROW: {
                if (visual.getEndDecoration() != null && visual.getEndDecoration() instanceof ArrowHead) break;
                visual.setEndDecoration((Node)this.END_ARROW_HEAD);
            }
        }
        Shape startDecorationVisual = (Shape)visual.getStartDecoration();
        Shape endDecorationVisual = (Shape)visual.getEndDecoration();
        if (((GeometryNode)visual.getCurve()).getStroke() != content.getStroke()) {
            ((GeometryNode)visual.getCurve()).setStroke(content.getStroke());
        }
        if (startDecorationVisual != null && startDecorationVisual.getStroke() != content.getStroke()) {
            startDecorationVisual.setStroke(content.getStroke());
        }
        if (endDecorationVisual != null && endDecorationVisual.getStroke() != content.getStroke()) {
            endDecorationVisual.setStroke(content.getStroke());
        }
        if (((GeometryNode)visual.getCurve()).getStrokeWidth() != content.getStrokeWidth()) {
            ((GeometryNode)visual.getCurve()).setStrokeWidth(content.getStrokeWidth());
        }
        if (startDecorationVisual != null && startDecorationVisual.getStrokeWidth() != content.getStrokeWidth()) {
            startDecorationVisual.setStrokeWidth(content.getStrokeWidth());
        }
        if (endDecorationVisual != null && endDecorationVisual.getStrokeWidth() != content.getStrokeWidth()) {
            endDecorationVisual.setStrokeWidth(content.getStrokeWidth());
        }
        ArrayList<Double> dashList = new ArrayList<Double>(content.getDashes().length);
        Double[] doubleArray = content.getDashes();
        int n = doubleArray.length;
        int n2 = 0;
        while (n2 < n) {
            double d = doubleArray[n2];
            dashList.add(d);
            ++n2;
        }
        if (!((GeometryNode)visual.getCurve()).getStrokeDashArray().equals(dashList)) {
            ((GeometryNode)visual.getCurve()).getStrokeDashArray().setAll(dashList);
        }
        if (content.getRoutingStyle().equals((Object)FXGeometricCurve.RoutingStyle.ORTHOGONAL)) {
            if (((Connection)this.getVisual()).getStartAnchor() != null && ((Connection)this.getVisual()).getStartAnchor() instanceof DynamicAnchor && !(((DynamicAnchor)((Connection)this.getVisual()).getStartAnchor()).getComputationStrategy() instanceof OrthogonalProjectionStrategy)) {
                IVisualPart anchorage = (IVisualPart)this.getViewer().getVisualPartMap().get(((Connection)this.getVisual()).getStartAnchor().getAnchorage());
                this.detachFromAnchorageVisual((IVisualPart<Node, ? extends Node>)anchorage, START_ROLE);
                if (anchorage != this) {
                    this.attachToAnchorageVisual((IVisualPart<Node, ? extends Node>)anchorage, START_ROLE);
                }
            }
            if (((Connection)this.getVisual()).getEndAnchor() != null && ((Connection)this.getVisual()).getEndAnchor() instanceof DynamicAnchor && !(((DynamicAnchor)((Connection)this.getVisual()).getEndAnchor()).getComputationStrategy() instanceof OrthogonalProjectionStrategy)) {
                IVisualPart anchorage = (IVisualPart)this.getViewer().getVisualPartMap().get(((Connection)this.getVisual()).getEndAnchor().getAnchorage());
                this.detachFromAnchorageVisual((IVisualPart<Node, ? extends Node>)anchorage, END_ROLE);
                if (anchorage != this) {
                    this.attachToAnchorageVisual((IVisualPart<Node, ? extends Node>)anchorage, END_ROLE);
                }
            }
            if (!(visual.getInterpolator() instanceof PolylineInterpolator)) {
                visual.setInterpolator((IConnectionInterpolator)new PolylineInterpolator());
            }
            if (!(visual.getRouter() instanceof OrthogonalRouter)) {
                visual.setRouter((IConnectionRouter)new OrthogonalRouter());
            }
        } else {
            if (((Connection)this.getVisual()).getStartAnchor() != null && ((Connection)this.getVisual()).getStartAnchor() instanceof DynamicAnchor && ((DynamicAnchor)((Connection)this.getVisual()).getStartAnchor()).getComputationStrategy() instanceof OrthogonalProjectionStrategy) {
                IVisualPart anchorage = (IVisualPart)this.getViewer().getVisualPartMap().get(((Connection)this.getVisual()).getStartAnchor().getAnchorage());
                this.detachFromAnchorageVisual((IVisualPart<Node, ? extends Node>)anchorage, START_ROLE);
                this.attachToAnchorageVisual((IVisualPart<Node, ? extends Node>)anchorage, START_ROLE);
            }
            if (((Connection)this.getVisual()).getEndAnchor() != null && ((Connection)this.getVisual()).getEndAnchor() instanceof DynamicAnchor && ((DynamicAnchor)((Connection)this.getVisual()).getEndAnchor()).getComputationStrategy() instanceof OrthogonalProjectionStrategy) {
                IVisualPart anchorage = (IVisualPart)this.getViewer().getVisualPartMap().get(((Connection)this.getVisual()).getEndAnchor().getAnchorage());
                this.detachFromAnchorageVisual((IVisualPart<Node, ? extends Node>)anchorage, END_ROLE);
                this.attachToAnchorageVisual((IVisualPart<Node, ? extends Node>)anchorage, END_ROLE);
            }
            if (!(visual.getInterpolator() instanceof PolyBezierInterpolator)) {
                visual.setInterpolator((IConnectionInterpolator)new PolyBezierInterpolator());
            }
            if (!(visual.getRouter() instanceof StraightRouter)) {
                visual.setRouter((IConnectionRouter)new StraightRouter());
            }
        }
        this.previousContent = content;
        super.doRefreshVisual(visual);
    }

    @Override
    public FXGeometricCurve getContent() {
        return (FXGeometricCurve)super.getContent();
    }

    public void setContent(Object model) {
        if (model != null && !(model instanceof FXGeometricCurve)) {
            throw new IllegalArgumentException("Only ICurve models are supported.");
        }
        if (this.getContent() != null) {
            this.getContent().wayPointsProperty().removeListener(this.wayPointsChangeListener);
            this.getContent().dashesProperty().removeListener(this.dashesChangeListener);
            this.getContent().routingStyleProperty().removeListener(this.routingStyleChangeListener);
            this.getContent().sourceDecorationProperty().removeListener(this.decorationChangeListener);
            this.getContent().targetDecorationProperty().removeListener(this.decorationChangeListener);
        }
        super.setContent(model);
        if (this.getContent() != null) {
            this.getContent().wayPointsProperty().addListener(this.wayPointsChangeListener);
            this.getContent().dashesProperty().addListener(this.dashesChangeListener);
            this.getContent().routingStyleProperty().addListener(this.routingStyleChangeListener);
            this.getContent().sourceDecorationProperty().addListener(this.decorationChangeListener);
            this.getContent().targetDecorationProperty().addListener(this.decorationChangeListener);
        }
    }

    public void transformContent(AffineTransform transform) {
        this.getContent().setWayPoints(transform.getTransformed(this.getContent().getWayPoints().toArray(new Point[0])));
    }

    public static class ArrowHead
    extends Polygon {
        public ArrowHead() {
            super(new double[]{0.0, 0.0, 10.0, 3.0, 10.0, -3.0});
            this.setFill((Paint)Color.TRANSPARENT);
        }
    }

    public static class CircleHead
    extends Circle {
        public CircleHead() {
            super(5.0);
            this.setFill((Paint)Color.TRANSPARENT);
        }
    }
}

