/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.mvc.examples.logo.ui.properties;

import org.eclipse.gef4.mvc.examples.logo.model.FXGeometricCurve;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class FXCurvePropertySource
implements IPropertySource {
    public static final IPropertyDescriptor SOURCE_DECORATION_PROPERTY = new ComboBoxPropertyDescriptor((Object)"sourceDecoration", "Source Decoration", new String[]{FXGeometricCurve.Decoration.NONE.name(), FXGeometricCurve.Decoration.ARROW.name(), FXGeometricCurve.Decoration.CIRCLE.name()});
    public static final IPropertyDescriptor TARGET_DECORATION_PROPERTY = new ComboBoxPropertyDescriptor((Object)"targetDecoration", "Target Decoration", new String[]{FXGeometricCurve.Decoration.NONE.name(), FXGeometricCurve.Decoration.ARROW.name(), FXGeometricCurve.Decoration.CIRCLE.name()});
    public static final IPropertyDescriptor STROKE_WIDTH_PROPERTY = new TextPropertyDescriptor((Object)"strokeWidth", "Stroke Width");
    public static final IPropertyDescriptor ROUTING_STYLE_PROPERTY = new ComboBoxPropertyDescriptor((Object)"routingStyle", "Routing Style", new String[]{FXGeometricCurve.RoutingStyle.STRAIGHT.name(), FXGeometricCurve.RoutingStyle.ORTHOGONAL.name()});
    private FXGeometricCurve curve;

    public FXCurvePropertySource(FXGeometricCurve curve) {
        this.curve = curve;
    }

    public FXGeometricCurve getCurve() {
        return this.curve;
    }

    public Object getEditableValue() {
        return null;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        return new IPropertyDescriptor[]{SOURCE_DECORATION_PROPERTY, TARGET_DECORATION_PROPERTY, STROKE_WIDTH_PROPERTY, ROUTING_STYLE_PROPERTY};
    }

    public Object getPropertyValue(Object id) {
        if (SOURCE_DECORATION_PROPERTY.getId().equals(id)) {
            return this.curve.getSourceDecoration().ordinal();
        }
        if (TARGET_DECORATION_PROPERTY.getId().equals(id)) {
            return this.curve.getTargetDecoration().ordinal();
        }
        if (STROKE_WIDTH_PROPERTY.getId().equals(id)) {
            return new Double(this.curve.getStrokeWidth()).toString();
        }
        if (ROUTING_STYLE_PROPERTY.getId().equals(id)) {
            return this.curve.getRoutingStyle().ordinal();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (SOURCE_DECORATION_PROPERTY.getId().equals(id)) {
            return !this.curve.getSourceDecoration().equals((Object)FXGeometricCurve.Decoration.NONE);
        }
        if (TARGET_DECORATION_PROPERTY.getId().equals(id)) {
            return !this.curve.getTargetDecoration().equals((Object)FXGeometricCurve.Decoration.NONE);
        }
        if (STROKE_WIDTH_PROPERTY.getId().equals(id)) {
            return this.curve.getStrokeWidth() != 1.0;
        }
        if (ROUTING_STYLE_PROPERTY.getId().equals(id)) {
            return !this.curve.getRoutingStyle().equals((Object)FXGeometricCurve.RoutingStyle.STRAIGHT);
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (SOURCE_DECORATION_PROPERTY.getId().equals(id)) {
            this.curve.setSourceDecoration(FXGeometricCurve.Decoration.NONE);
        } else if (TARGET_DECORATION_PROPERTY.getId().equals(id)) {
            this.curve.setTargetDecoration(FXGeometricCurve.Decoration.NONE);
        } else if (STROKE_WIDTH_PROPERTY.getId().equals(id)) {
            this.curve.setStrokeWidth(1.0);
        } else if (ROUTING_STYLE_PROPERTY.getId().equals(id)) {
            this.curve.setRoutingStyle(FXGeometricCurve.RoutingStyle.STRAIGHT);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (SOURCE_DECORATION_PROPERTY.getId().equals(id)) {
            this.curve.setSourceDecoration(FXGeometricCurve.Decoration.values()[(Integer)value]);
        } else if (TARGET_DECORATION_PROPERTY.getId().equals(id)) {
            this.curve.setTargetDecoration(FXGeometricCurve.Decoration.values()[(Integer)value]);
        } else if (STROKE_WIDTH_PROPERTY.getId().equals(id)) {
            this.curve.setStrokeWidth(Double.parseDouble((String)value));
        } else if (ROUTING_STYLE_PROPERTY.getId().equals(id)) {
            this.curve.setRoutingStyle(FXGeometricCurve.RoutingStyle.values()[(Integer)value]);
        }
    }
}

