/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.geometry.planar;

import org.eclipse.gef4.geometry.euclidean.Angle;
import org.eclipse.gef4.geometry.internal.utils.PrecisionUtils;
import org.eclipse.gef4.geometry.planar.AbstractArcBasedGeometry;
import org.eclipse.gef4.geometry.planar.AbstractRectangleBasedGeometry;
import org.eclipse.gef4.geometry.planar.CubicCurve;
import org.eclipse.gef4.geometry.planar.CurveUtils;
import org.eclipse.gef4.geometry.planar.ICurve;
import org.eclipse.gef4.geometry.planar.Point;
import org.eclipse.gef4.geometry.planar.PolyBezier;
import org.eclipse.gef4.geometry.planar.Rectangle;

public final class Arc
extends AbstractArcBasedGeometry<Arc, PolyBezier>
implements ICurve {
    private static final long serialVersionUID = 1L;

    public Arc(AbstractRectangleBasedGeometry<?, ?> r, Angle startAngle, Angle angularExtent) {
        super(r.x, r.y, r.width, r.height, startAngle, angularExtent);
    }

    public Arc(double x, double y, double width, double height, Angle startAngle, Angle angularExtent) {
        super(x, y, width, height, startAngle, angularExtent);
    }

    @Override
    public boolean contains(Point p) {
        CubicCurve[] cubicCurveArray = this.computeBezierApproximation();
        int n = cubicCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubicCurve c = cubicCurveArray[n2];
            if (c.contains(p)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Arc)) {
            return false;
        }
        Arc o = (Arc)obj;
        return PrecisionUtils.equal(this.x, o.x) && PrecisionUtils.equal(this.y, o.y) && PrecisionUtils.equal(this.width, o.width) && PrecisionUtils.equal(this.height, o.height) && this.angularExtent.equals(o.angularExtent) && this.startAngle.equals(o.startAngle);
    }

    @Override
    public Rectangle getBounds() {
        return new PolyBezier(this.toBezier()).getBounds();
    }

    @Override
    public Arc getCopy() {
        return new Arc(this.x, this.y, this.width, this.height, this.startAngle, this.angularExtent);
    }

    @Override
    public Point[] getIntersections(ICurve c) {
        return CurveUtils.getIntersections((ICurve)this, c);
    }

    @Override
    public ICurve[] getOverlaps(ICurve c) {
        return CurveUtils.getOverlaps(this, c);
    }

    @Override
    public Point getProjection(Point reference) {
        double minDistance = 0.0;
        Point minProjection = null;
        CubicCurve[] cubicCurveArray = this.toBezier();
        int n = cubicCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubicCurve bc = cubicCurveArray[n2];
            Point projection = bc.getProjection(reference);
            double distance = projection.getDistance(reference);
            if (minProjection == null || distance < minDistance) {
                minProjection = projection;
                minDistance = distance;
            }
            ++n2;
        }
        return minProjection;
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle) {
        return this.getRotatedCCW(angle, this.getCenter());
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle, double cx, double cy) {
        return new PolyBezier(this.computeBezierApproximation()).rotateCCW(angle, cx, cy);
    }

    @Override
    public PolyBezier getRotatedCCW(Angle angle, Point center) {
        return new PolyBezier(this.computeBezierApproximation()).rotateCCW(angle, center);
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle) {
        return this.getRotatedCW(angle, this.getCenter());
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle, double cx, double cy) {
        return new PolyBezier(this.computeBezierApproximation()).rotateCW(angle, cx, cy);
    }

    @Override
    public PolyBezier getRotatedCW(Angle angle, Point center) {
        return new PolyBezier(this.computeBezierApproximation()).rotateCW(angle, center);
    }

    @Override
    public boolean intersects(ICurve c) {
        return CurveUtils.getIntersections((ICurve)this, c).length > 0;
    }

    @Override
    public boolean overlaps(ICurve c) {
        CubicCurve[] cubicCurveArray = this.computeBezierApproximation();
        int n = cubicCurveArray.length;
        int n2 = 0;
        while (n2 < n) {
            CubicCurve seg1 = cubicCurveArray[n2];
            if (seg1.overlaps(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public CubicCurve[] toBezier() {
        return this.computeBezierApproximation();
    }

    public String toString() {
        return "Arc(x = " + this.x + ", y = " + this.y + ", width = " + this.width + ", height = " + this.height + ", startAngle = " + this.startAngle.deg() + ", angularExtend = " + this.angularExtent.deg() + ")";
    }
}

